/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class LongLiteralsEndingWithLowercaseLInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("LongLiteralEndingWithLowercaseL" == null) {
            LongLiteralsEndingWithLowercaseLInspection.$$$reportNull$$$0(0);
        }
        return "LongLiteralEndingWithLowercaseL";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("long.literals.ending.with.lowercase.l.display.name", new Object[0]);
        if (string == null) {
            LongLiteralsEndingWithLowercaseLInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("long.literals.ending.with.lowercase.l.problem.descriptor", new Object[0]);
        if (string == null) {
            LongLiteralsEndingWithLowercaseLInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LongLiteralWithLowercaseLVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new LongLiteralFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LongLiteralWithLowercaseLVisitor
    extends BaseInspectionVisitor {
        private LongLiteralWithLowercaseLVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                LongLiteralWithLowercaseLVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.LONG)) {
                return;
            }
            String text2 = expression.getText();
            if (text2 == null) {
                return;
            }
            int length = text2.length();
            if (length == 0) {
                return;
            }
            if (text2.charAt(length - 1) != 'l') {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection$LongLiteralWithLowercaseLVisitor", "visitLiteralExpression"));
        }
    }

    private static class LongLiteralFix
    extends InspectionGadgetsFix {
        private LongLiteralFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("long.literals.ending.with.lowercase.l.replace.quickfix", new Object[0]);
            if (string == null) {
                LongLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression literal = (PsiExpression)descriptor.getPsiElement();
            String text2 = literal.getText();
            String newText = text2.replace('l', 'L');
            PsiReplacementUtil.replaceExpression(literal, newText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection$LongLiteralFix", "getFamilyName"));
        }
    }
}

