/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Chunk;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.impl.CycleFinder;
import com.intellij.util.graph.impl.KShortestPathsFinder;
import com.intellij.util.graph.impl.ShortestPathFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GraphAlgorithmsImpl
extends GraphAlgorithms {
    @Override
    public <Node> List<Node> findShortestPath(@NotNull Graph<Node> graph, @NotNull Node start, @NotNull Node finish) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(0);
        }
        if (start == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(1);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(2);
        }
        return new ShortestPathFinder<Node>(graph).findPath(start, finish);
    }

    @Override
    @NotNull
    public <Node> List<List<Node>> findKShortestPaths(@NotNull Graph<Node> graph, @NotNull Node start, @NotNull Node finish, int k, @NotNull ProgressIndicator progressIndicator) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(3);
        }
        if (start == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(4);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(5);
        }
        if (progressIndicator == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(6);
        }
        List<List<Node>> list = new KShortestPathsFinder<Node>(graph, start, finish, progressIndicator).findShortestPaths(k);
        if (list == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public <Node> Set<List<Node>> findCycles(@NotNull Graph<Node> graph, @NotNull Node node) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(8);
        }
        if (node == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(9);
        }
        Set<List<Node>> set = new CycleFinder<Node>(graph).getNodeCycles(node);
        if (set == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Override
    @NotNull
    public <Node> Graph<Node> invertEdgeDirections(final @NotNull Graph<Node> graph) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(11);
        }
        Graph graph2 = new Graph<Node>(){

            @Override
            public Collection<Node> getNodes() {
                return graph.getNodes();
            }

            @Override
            public Iterator<Node> getIn(Node n) {
                return graph.getOut(n);
            }

            @Override
            public Iterator<Node> getOut(Node n) {
                return graph.getIn(n);
            }
        };
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(12);
        }
        return graph2;
    }

    @Override
    @NotNull
    public <Node> Graph<Chunk<Node>> computeSCCGraph(final @NotNull Graph<Node> graph) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(13);
        }
        DFSTBuilder<Node> builder = new DFSTBuilder<Node>(graph);
        Collection<Collection<Node>> components = builder.getComponents();
        final ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(components.size());
        final LinkedHashMap<Node, Chunk<Node>> nodeToChunkMap = new LinkedHashMap<Node, Chunk<Node>>();
        for (Collection<Node> component : components) {
            Set<Node> chunkNodes = component.size() == 1 ? Collections.singleton(component.iterator().next()) : new LinkedHashSet<Node>(component);
            Chunk<Node> chunk = new Chunk<Node>(chunkNodes);
            chunks.add(chunk);
            for (Node node : component) {
                nodeToChunkMap.put(node, chunk);
            }
        }
        Graph<Chunk<Node>> graph2 = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<Chunk<Node>>(){

            @Override
            public Collection<Chunk<Node>> getNodes() {
                return chunks;
            }

            @Override
            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet ins = new LinkedHashSet();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add(nodeToChunkMap.get(in));
                    }
                }
                return ins.iterator();
            }
        }));
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(14);
        }
        return graph2;
    }

    @Override
    public <Node> void collectOutsRecursively(@NotNull Graph<Node> graph, Node start, Set<Node> set) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(15);
        }
        if (!set.add(start)) {
            return;
        }
        Iterator<Node> iterator = graph.getOut(start);
        while (iterator.hasNext()) {
            Node node = iterator.next();
            this.collectOutsRecursively(graph, node, set);
        }
    }

    @Override
    @NotNull
    public <Node> Collection<Chunk<Node>> computeStronglyConnectedComponents(@NotNull Graph<Node> graph) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(16);
        }
        Collection<Chunk<Node>> collection = this.computeSCCGraph(graph).getNodes();
        if (collection == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @Override
    @NotNull
    public <Node> List<List<Node>> removePathsWithCycles(@NotNull List<List<Node>> paths) {
        if (paths == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(18);
        }
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        for (List<Node> path : paths) {
            if (GraphAlgorithmsImpl.containsCycle(path)) continue;
            result.add(path);
        }
        ArrayList<List<Node>> arrayList = result;
        if (arrayList == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static boolean containsCycle(List<?> path) {
        return new HashSet(path).size() != path.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/graph/impl/GraphAlgorithmsImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/graph/impl/GraphAlgorithmsImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findKShortestPaths";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findCycles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "invertEdgeDirections";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSCCGraph";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStronglyConnectedComponents";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "removePathsWithCycles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findShortestPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findKShortestPaths";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCycles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invertEdgeDirections";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeSCCGraph";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectOutsRecursively";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeStronglyConnectedComponents";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removePathsWithCycles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

