/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeCastFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final PsiType myType;

    public AddTypeCastFix(@NotNull PsiType type, @NotNull PsiExpression expression) {
        if (type == null) {
            AddTypeCastFix.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            AddTypeCastFix.$$$reportNull$$$0(1);
        }
        super(expression);
        this.myType = type;
    }

    @Override
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.typecast.text", this.myType.isValid() ? this.myType.getCanonicalText() : "");
        if (string == null) {
            AddTypeCastFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.typecast.family", new Object[0]);
        if (string == null) {
            AddTypeCastFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddTypeCastFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AddTypeCastFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            AddTypeCastFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            AddTypeCastFix.$$$reportNull$$$0(7);
        }
        return this.myType.isValid() && PsiTypesUtil.isDenotableType(this.myType) && startElement.getManager().isInProject(startElement);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddTypeCastFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            AddTypeCastFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            AddTypeCastFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            AddTypeCastFix.$$$reportNull$$$0(11);
        }
        AddTypeCastFix.addTypeCast(project, (PsiExpression)startElement, this.myType);
    }

    private static void addTypeCast(Project project, PsiExpression originalExpression, PsiType type) {
        PsiExpression typeCast = AddTypeCastFix.createCastExpression(originalExpression, project, type);
        originalExpression.replace(typeCast);
    }

    static PsiExpression createCastExpression(PsiExpression original, Project project, PsiType type) {
        PsiExpression expression = PsiUtil.deparenthesizeExpression(original);
        if (expression == null) {
            return null;
        }
        if (type.equals(PsiType.NULL)) {
            return null;
        }
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        String text2 = "(" + type.getCanonicalText(false) + ")value";
        PsiElementFactory factory = JavaPsiFacade.getInstance(original.getProject()).getElementFactory();
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)factory.createExpressionFromText(text2, original);
        typeCast = (PsiTypeCastExpression)JavaCodeStyleManager.getInstance(project).shortenClassReferences(typeCast);
        typeCast = (PsiTypeCastExpression)CodeStyleManager.getInstance(project).reformat(typeCast);
        if (expression instanceof PsiConditionalExpression) {
            PsiType elseType;
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression.copy();
            PsiExpression thenE = conditional.getThenExpression();
            PsiExpression elseE = conditional.getElseExpression();
            PsiType thenType = thenE == null ? null : thenE.getType();
            PsiType psiType = elseType = elseE == null ? null : elseE.getType();
            if (elseType != null && thenType != null) {
                boolean replaceElse;
                boolean replaceThen = !TypeConversionUtil.isAssignable(type, thenType);
                boolean bl = replaceElse = !TypeConversionUtil.isAssignable(type, elseType);
                if (replaceThen != replaceElse) {
                    if (replaceThen) {
                        ObjectUtils.assertNotNull(typeCast.getOperand()).replace(thenE);
                        thenE.replace(typeCast);
                    } else {
                        ObjectUtils.assertNotNull(typeCast.getOperand()).replace(elseE);
                        elseE.replace(typeCast);
                    }
                    return conditional;
                }
            }
        }
        ObjectUtils.assertNotNull(typeCast.getOperand()).replace(expression);
        return typeCast;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

