/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.LambdaIndy;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class DataInterpreter
extends Interpreter<DataValue> {
    private int called = -1;
    private final MethodNode methodNode;
    private final int shift;
    final int rangeStart;
    final int rangeEnd;
    final int arity;
    final EffectQuantum[] effects;
    DataValue returnValue = null;

    protected DataInterpreter(MethodNode methodNode) {
        super(393216);
        this.methodNode = methodNode;
        this.shift = (methodNode.access & 8) == 0 ? 2 : 1;
        this.arity = Type.getArgumentTypes((String)methodNode.desc).length;
        this.rangeStart = this.shift;
        this.rangeEnd = this.arity + this.shift;
        this.effects = new EffectQuantum[methodNode.instructions.size()];
    }

    public DataValue newValue(Type type) {
        if (type == null) {
            return DataValue.UnknownDataValue1;
        }
        ++this.called;
        if (type.toString().equals("Lthis;")) {
            return DataValue.ThisDataValue;
        }
        if (this.called < this.rangeEnd && this.rangeStart <= this.called) {
            if (type == Type.VOID_TYPE) {
                return null;
            }
            if (ASMUtils.isReferenceType(type)) {
                return new DataValue.ParameterDataValue(this.called - this.shift);
            }
            return type.getSize() == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
        }
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return type.getSize() == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
    }

    public DataValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 187: {
                return DataValue.LocalDataValue;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                return DataValue.UnknownDataValue2;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                int size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 178: {
                int size = Type.getType((String)((FieldInsnNode)insn).desc).getSize();
                return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    public DataValue binaryOperation(AbstractInsnNode insn, DataValue value1, DataValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return DataValue.UnknownDataValue2;
            }
            case 181: {
                EffectQuantum effectQuantum = DataInterpreter.getChangeQuantum(value1);
                int insnIndex = this.methodNode.instructions.indexOf(insn);
                this.effects[insnIndex] = effectQuantum;
                return DataValue.UnknownDataValue1;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    @Nullable
    private static EffectQuantum getChangeQuantum(DataValue value) {
        if (value == DataValue.ThisDataValue || value == DataValue.OwnedDataValue) {
            return EffectQuantum.ThisChangeQuantum;
        }
        if (value == DataValue.LocalDataValue) {
            return null;
        }
        if (value instanceof DataValue.ParameterDataValue) {
            return new EffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)value).n);
        }
        if (value instanceof DataValue.ReturnDataValue) {
            return new EffectQuantum.ReturnChangeQuantum(((DataValue.ReturnDataValue)value).key);
        }
        return EffectQuantum.TopEffectQuantum;
    }

    public DataValue copyOperation(AbstractInsnNode insn, DataValue value) throws AnalyzerException {
        return value;
    }

    public DataValue naryOperation(AbstractInsnNode insn, List<? extends DataValue> values) throws AnalyzerException {
        int insnIndex = this.methodNode.instructions.indexOf(insn);
        int opCode = insn.getOpcode();
        switch (opCode) {
            case 197: {
                return DataValue.LocalDataValue;
            }
            case 186: {
                if (LambdaIndy.from((InvokeDynamicInsnNode)insn) == null) {
                    this.effects[insnIndex] = EffectQuantum.TopEffectQuantum;
                }
                return ASMUtils.getReturnSizeFast(((InvokeDynamicInsnNode)insn).desc) == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                boolean stable = opCode == 183 || opCode == 184;
                MethodInsnNode mNode = (MethodInsnNode)insn;
                DataValue[] data = values.toArray(new DataValue[0]);
                Method method = new Method(mNode.owner, mNode.name, mNode.desc);
                EKey key = new EKey(method, Direction.Pure, stable);
                EffectQuantum quantum = new EffectQuantum.CallQuantum(key, data, opCode == 184);
                DataValue result2 = ASMUtils.getReturnSizeFast(mNode.desc) == 1 ? (ASMUtils.isReferenceReturnType(mNode.desc) ? new DataValue.ReturnDataValue(key) : DataValue.UnknownDataValue1) : DataValue.UnknownDataValue2;
                if (HardCodedPurity.getInstance().isPureMethod(method)) {
                    quantum = null;
                    result2 = DataValue.LocalDataValue;
                } else if (HardCodedPurity.getInstance().isThisChangingMethod(method)) {
                    DataValue receiver = ArrayUtil.getFirstElement(data);
                    if (receiver == DataValue.ThisDataValue) {
                        quantum = EffectQuantum.ThisChangeQuantum;
                    } else if (receiver == DataValue.LocalDataValue || receiver == DataValue.OwnedDataValue) {
                        quantum = null;
                    } else if (receiver instanceof DataValue.ParameterDataValue) {
                        quantum = new EffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)receiver).n);
                    }
                    if (HardCodedPurity.getInstance().isBuilderChainCall(method)) {
                        result2 = receiver;
                    }
                }
                this.effects[insnIndex] = quantum;
                return result2;
            }
        }
        return null;
    }

    public DataValue unaryOperation(AbstractInsnNode insn, DataValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                return DataValue.UnknownDataValue2;
            }
            case 180: {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                if (value == DataValue.ThisDataValue && HardCodedPurity.getInstance().isOwnedField(fieldInsn)) {
                    return DataValue.OwnedDataValue;
                }
                return ASMUtils.getSizeFast(fieldInsn.desc) == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 192: {
                return value;
            }
            case 179: {
                int insnIndex = this.methodNode.instructions.indexOf(insn);
                this.effects[insnIndex] = EffectQuantum.TopEffectQuantum;
                return DataValue.UnknownDataValue1;
            }
            case 188: 
            case 189: {
                return DataValue.LocalDataValue;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    public DataValue ternaryOperation(AbstractInsnNode insn, DataValue value1, DataValue value2, DataValue value3) throws AnalyzerException {
        int insnIndex = this.methodNode.instructions.indexOf(insn);
        this.effects[insnIndex] = DataInterpreter.getChangeQuantum(value1);
        return DataValue.UnknownDataValue1;
    }

    public void returnOperation(AbstractInsnNode insn, DataValue value, DataValue expected) throws AnalyzerException {
        if (insn.getOpcode() == 176) {
            if (this.returnValue == null) {
                this.returnValue = value;
            } else if (!this.returnValue.equals(value)) {
                this.returnValue = DataValue.UnknownDataValue1;
            }
        }
    }

    public DataValue merge(DataValue v1, DataValue v2) {
        if (v1.equals(v2)) {
            return v1;
        }
        int size = Math.min(v1.getSize(), v2.getSize());
        return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
    }
}

