/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MapUpdateInliner
implements CallInliner {
    private static final CallMatcher MAP_COMPUTE = CallMatcher.instanceCall("java.util.Map", "computeIfAbsent", "computeIfPresent", "compute").parameterCount(2);
    private static final CallMatcher MAP_MERGE = CallMatcher.instanceCall("java.util.Map", "merge").parameterCount(3);

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            MapUpdateInliner.$$$reportNull$$$0(1);
        }
        if (MAP_COMPUTE.test(call)) {
            String name;
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type = call.getType();
            if (type == null) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression key = args[0];
            PsiExpression function = args[1];
            builder.pushExpression(qualifier).checkNotNull(call, NullabilityProblemKind.callNPE).pop();
            switch (name = Objects.requireNonNull(call.getMethodExpression().getReferenceName())) {
                case "computeIfAbsent": {
                    MapUpdateInliner.inlineComputeIfAbsent(builder, key, function, type);
                    break;
                }
                case "computeIfPresent": {
                    MapUpdateInliner.inlineComputeIfPresent(builder, key, function, type);
                    break;
                }
                case "compute": {
                    MapUpdateInliner.inlineCompute(builder, key, function, type);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported name: " + name);
                }
            }
            return true;
        }
        if (MAP_MERGE.test(call)) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type = call.getType();
            if (type == null) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression key = args[0];
            PsiExpression value = args[1];
            PsiExpression function = args[2];
            builder.pushExpression(qualifier).checkNotNull(call, NullabilityProblemKind.callNPE).pop().pushExpression(key).pop().pushExpression(value).checkNotNull(value, NullabilityProblemKind.passingNullableToNotNullParameter).evaluateFunction(function).pushUnknown().ifNotNull().push(builder.getFactory().createTypeValue(type, Nullness.NOT_NULL)).swap().invokeFunction(2, function).endIf().flushFields();
            return true;
        }
        return false;
    }

    private static void inlineComputeIfAbsent(@NotNull CFGBuilder builder, PsiExpression key, PsiExpression function, PsiType type) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(2);
        }
        builder.pushExpression(key).evaluateFunction(function).pushUnknown().ifNull().invokeFunction(1, function).flushFields().elseBranch().pop().push(builder.getFactory().createTypeValue(type, Nullness.NOT_NULL)).endIf();
    }

    private static void inlineComputeIfPresent(@NotNull CFGBuilder builder, PsiExpression key, PsiExpression function, PsiType type) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(3);
        }
        builder.pushExpression(key).evaluateFunction(function).pushUnknown().ifNotNull().push(builder.getFactory().createTypeValue(type, Nullness.NOT_NULL)).invokeFunction(2, function).flushFields().elseBranch().pop().pushNull().endIf();
    }

    private static void inlineCompute(@NotNull CFGBuilder builder, PsiExpression key, PsiExpression function, PsiType type) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(4);
        }
        builder.pushExpression(key).evaluateFunction(function).push(builder.getFactory().createTypeValue(type, Nullness.NULLABLE)).invokeFunction(2, function).flushFields();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inliner/MapUpdateInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineComputeIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineComputeIfPresent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineCompute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

