/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.inheritance.ImplicitSubclassProvider;
import com.intellij.codeInspection.visibility.VisibilityInspection;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.TObjectIntHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessCanBeTightenedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private final VisibilityInspection myVisibilityInspection;

    AccessCanBeTightenedInspection(@NotNull VisibilityInspection visibilityInspection) {
        if (visibilityInspection == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(0);
        }
        this.myVisibilityInspection = visibilityInspection;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VISIBILITY_GROUP_NAME;
        if (string == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Member access can be tightened" == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(2);
        }
        return "Member access can be tightened";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("WeakerAccess" == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(3);
        }
        return "WeakerAccess";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(4);
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(5);
        }
        return myVisitor;
    }

    @Nullable
    private static PsiPackage getPackage(@NotNull PsiElement element) {
        PsiFile file;
        PsiDirectory directory;
        if (element == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(6);
        }
        return (directory = (file = element.getContainingFile()).getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
    }

    private static boolean samePackages(PsiPackage package1, PsiPackage package2) {
        return package2 == package1 || package2 != null && package1 != null && Comparing.strEqual(package2.getQualifiedName(), package1.getQualifiedName());
    }

    private static PsiExpression getQualifier(@NotNull PsiElement element) {
        if (element == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(7);
        }
        PsiExpression qualifier = null;
        if (element instanceof PsiReferenceExpression) {
            qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
        } else if (element instanceof PsiMethodCallExpression) {
            qualifier = ((PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression();
        }
        return qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression ? null : qualifier;
    }

    private static boolean isInnerClass(@NotNull PsiClass memberClass) {
        if (memberClass == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(8);
        }
        return memberClass.getContainingClass() != null || memberClass instanceof PsiAnonymousClass;
    }

    private static boolean isConstantField(PsiMember member) {
        return member instanceof PsiField && member.hasModifierProperty("static") && member.hasModifierProperty("final") && ((PsiField)member).hasInitializer();
    }

    private static boolean isInReferenceList(@Nullable PsiElement list, final @NotNull PsiMember member) {
        if (member == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(9);
        }
        if (list == null) {
            return false;
        }
        final PsiManager psiManager = member.getManager();
        final boolean[] result2 = new boolean[1];
        list.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (psiManager.areElementsEquivalent(reference.resolve(), member)) {
                    result2[0] = true;
                    this.stopWalking();
                }
            }
        });
        return result2[0];
    }

    @PsiUtil.AccessLevel
    private int suggestPackageLocal(@NotNull PsiMember member) {
        if (member == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(10);
        }
        boolean suggestPackageLocal = member instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)member) ? this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES : this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS;
        return suggestPackageLocal ? 2 : 4;
    }

    private static void log(String s) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPackage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInnerClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInReferenceList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestPackageLocal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final UnusedDeclarationInspectionBase myDeadCodeInspection;
        private final TObjectIntHashMap<PsiClass> maxSuggestedLevelForChildMembers;

        public MyVisitor(ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.maxSuggestedLevelForChildMembers = new TObjectIntHashMap();
            this.myHolder = holder;
            this.myDeadCodeInspection = UnusedDeclarationInspectionBase.findUnusedDeclarationInspection(holder.getFile());
        }

        @Override
        public void visitClass(PsiClass aClass) {
            this.checkMember(aClass);
        }

        @Override
        public void visitMethod(PsiMethod method) {
            this.checkMember(method);
        }

        @Override
        public void visitField(PsiField field) {
            this.checkMember(field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkMember(@NotNull PsiMember member) {
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (!((AccessCanBeTightenedInspection)AccessCanBeTightenedInspection.this).myVisibilityInspection.SUGGEST_FOR_CONSTANTS && AccessCanBeTightenedInspection.isConstantField(member)) {
                return;
            }
            PsiClass memberClass = member.getContainingClass();
            PsiModifierList memberModifierList = member.getModifierList();
            if (memberModifierList == null) {
                return;
            }
            int currentLevel = PsiUtil.getAccessLevel(memberModifierList);
            int suggestedLevel = this.suggestLevel(member, memberClass, currentLevel);
            if (memberClass != null) {
                TObjectIntHashMap<PsiClass> tObjectIntHashMap = this.maxSuggestedLevelForChildMembers;
                synchronized (tObjectIntHashMap) {
                    int prevMax = this.maxSuggestedLevelForChildMembers.get((Object)memberClass);
                    this.maxSuggestedLevelForChildMembers.put((Object)memberClass, Math.max(prevMax, suggestedLevel));
                }
            }
            AccessCanBeTightenedInspection.log(member.getName() + ": effective level is '" + PsiUtil.getAccessModifier(suggestedLevel) + "'");
            if (suggestedLevel < currentLevel) {
                PsiElement toHighlight;
                if (member instanceof PsiClass) {
                    int memberMaxLevel;
                    TObjectIntHashMap<PsiClass> prevMax = this.maxSuggestedLevelForChildMembers;
                    synchronized (prevMax) {
                        memberMaxLevel = this.maxSuggestedLevelForChildMembers.get((Object)((PsiClass)member));
                    }
                    if (memberMaxLevel > suggestedLevel) {
                        return;
                    }
                }
                PsiElement psiElement = toHighlight = currentLevel == 2 ? ((PsiNameIdentifierOwner)((Object)member)).getNameIdentifier() : ContainerUtil.find(memberModifierList.getChildren(), element -> element instanceof PsiKeyword && element.getText().equals(PsiUtil.getAccessModifier(currentLevel)));
                if (toHighlight != null) {
                    String suggestedModifier = PsiUtil.getAccessModifier(suggestedLevel);
                    this.myHolder.registerProblem(toHighlight, "Access can be " + VisibilityUtil.toPresentableText(suggestedModifier), new ChangeModifierFix(suggestedModifier));
                }
            }
        }

        @PsiUtil.AccessLevel
        private int suggestLevel(@NotNull PsiMember member, PsiClass memberClass, @PsiUtil.AccessLevel int currentLevel) {
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (member.hasModifierProperty("private") || member.hasModifierProperty("native")) {
                return currentLevel;
            }
            if (member instanceof PsiMethod && member instanceof SyntheticElement || !member.isPhysical()) {
                return currentLevel;
            }
            if (member instanceof PsiMethod) {
                ImplicitSubclassProvider[] method = (ImplicitSubclassProvider[])member;
                if (!method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overrides");
                    return currentLevel;
                }
                if (MethodUtils.isOverridden((PsiMethod)method)) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overridden");
                    return currentLevel;
                }
            }
            if (member instanceof PsiEnumConstant) {
                return currentLevel;
            }
            if (member instanceof PsiClass && (member instanceof PsiAnonymousClass || member instanceof PsiTypeParameter || member instanceof PsiSyntheticClass || PsiUtil.isLocalClass((PsiClass)member))) {
                return currentLevel;
            }
            if (memberClass != null && (memberClass.isInterface() || memberClass.isEnum() || memberClass.isAnnotationType() || PsiUtil.isLocalClass(memberClass) && member instanceof PsiClass)) {
                return currentLevel;
            }
            if (memberClass != null && member instanceof PsiMethod) {
                for (ImplicitSubclassProvider subclassProvider : ImplicitSubclassProvider.EP_NAME.getExtensions()) {
                    Map<PsiMethod, ImplicitSubclassProvider.OverridingInfo> methodsInfo;
                    ImplicitSubclassProvider.SubclassingInfo info2;
                    if (!subclassProvider.isApplicableTo(memberClass) || (info2 = subclassProvider.getSubclassingInfo(memberClass)) == null || (methodsInfo = info2.getMethodsInfo()) != null && !methodsInfo.containsKey(member)) continue;
                    return currentLevel;
                }
            }
            PsiFile memberFile = member.getContainingFile();
            Project project = memberFile.getProject();
            int minLevel = 1;
            boolean entryPoint = this.myDeadCodeInspection.isEntryPoint(member);
            if (entryPoint) {
                int level = AccessCanBeTightenedInspection.this.myVisibilityInspection.getMinVisibilityLevel(member);
                if (level <= 0) {
                    AccessCanBeTightenedInspection.log(member.getName() + " is entry point");
                    return currentLevel;
                }
                minLevel = level;
            }
            PsiPackage memberPackage = AccessCanBeTightenedInspection.getPackage(memberFile);
            AccessCanBeTightenedInspection.log(member.getName() + ": checking effective level for " + member);
            AtomicInteger maxLevel = new AtomicInteger(minLevel);
            AtomicBoolean foundUsage = new AtomicBoolean();
            boolean proceed = UnusedSymbolUtil.processUsages(project, memberFile, member, new EmptyProgressIndicator(), null, info -> {
                PsiElement element;
                if (member == null) {
                    MyVisitor.$$$reportNull$$$0(15);
                }
                if ((element = info.getElement()) == null) {
                    return true;
                }
                PsiFile psiFile = info.getFile();
                if (psiFile == null) {
                    return true;
                }
                return this.handleUsage(member, memberClass, memberFile, maxLevel, memberPackage, element, psiFile, foundUsage);
            });
            if (proceed && member instanceof PsiClass && LambdaUtil.isFunctionalClass((PsiClass)member)) {
                FunctionalExpressionSearch.search((PsiClass)member).forEach(functionalExpression -> {
                    if (member == null) {
                        MyVisitor.$$$reportNull$$$0(14);
                    }
                    PsiFile psiFile = functionalExpression.getContainingFile();
                    return this.handleUsage(member, memberClass, memberFile, maxLevel, memberPackage, (PsiElement)functionalExpression, psiFile, foundUsage);
                });
            }
            if (!foundUsage.get() && !entryPoint) {
                AccessCanBeTightenedInspection.log(member.getName() + " unused; ignore");
                return currentLevel;
            }
            int suggestedLevel = maxLevel.get();
            if (suggestedLevel == 1 && memberClass == null) {
                suggestedLevel = AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            String suggestedModifier = PsiUtil.getAccessModifier(suggestedLevel);
            AccessCanBeTightenedInspection.log(member.getName() + ": effective level is '" + suggestedModifier + "'");
            return suggestedLevel;
        }

        private boolean handleUsage(@NotNull PsiMember member, @Nullable PsiClass memberClass, @NotNull PsiFile memberFile, @NotNull AtomicInteger maxLevel, @Nullable PsiPackage memberPackage, @NotNull PsiElement element, @NotNull PsiFile psiFile, @NotNull AtomicBoolean foundUsage) {
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (memberFile == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (maxLevel == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (psiFile == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (foundUsage == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            foundUsage.set(true);
            if (!(psiFile instanceof PsiJavaFile)) {
                AccessCanBeTightenedInspection.log("     refd from " + psiFile.getName() + "; set to public");
                maxLevel.set(4);
                return false;
            }
            int level = this.getEffectiveLevel(element, psiFile, member, memberFile, memberClass, memberPackage);
            AccessCanBeTightenedInspection.log("    ref in file " + psiFile.getName() + "; level = " + PsiUtil.getAccessModifier(level) + "; (" + element + ")");
            maxLevel.getAndAccumulate(level, Math::max);
            return level != 4;
        }

        @PsiUtil.AccessLevel
        private int getEffectiveLevel(@NotNull PsiElement element, @NotNull PsiFile file, @NotNull PsiMember member, @NotNull PsiFile memberFile, PsiClass memberClass, PsiPackage memberPackage) {
            PsiElement resolvedQualifier;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if (file == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if (memberFile == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            PsiClass innerClass = PsiTreeUtil.getParentOfType(element, PsiClass.class);
            boolean isAbstractMember = member.hasModifierProperty("abstract");
            if (memberClass != null && PsiTreeUtil.isAncestor(innerClass, memberClass, false) || innerClass != null && PsiTreeUtil.isAncestor(memberClass, innerClass, false) && !innerClass.hasModifierProperty("static")) {
                if (AccessCanBeTightenedInspection.isInReferenceList(innerClass.getModifierList(), member) || AccessCanBeTightenedInspection.isInReferenceList(innerClass.getImplementsList(), member) || AccessCanBeTightenedInspection.isInReferenceList(innerClass.getExtendsList(), member)) {
                    return AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
                }
                return !isAbstractMember && (((AccessCanBeTightenedInspection)AccessCanBeTightenedInspection.this).myVisibilityInspection.SUGGEST_PRIVATE_FOR_INNERS || !AccessCanBeTightenedInspection.isInnerClass(memberClass)) && !this.calledOnInheritor(element, memberClass) ? 1 : AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            PsiExpression qualifier = AccessCanBeTightenedInspection.getQualifier(element);
            PsiElement psiElement = resolvedQualifier = qualifier instanceof PsiReference ? ((PsiReference)((Object)qualifier)).resolve() : null;
            if (resolvedQualifier instanceof PsiVariable) {
                resolvedQualifier = PsiUtil.resolveClassInClassTypeOnly(((PsiVariable)resolvedQualifier).getType());
            }
            PsiPackage qualifierPackage = resolvedQualifier == null ? null : AccessCanBeTightenedInspection.getPackage(resolvedQualifier);
            PsiPackage aPackage = AccessCanBeTightenedInspection.getPackage(file);
            if (AccessCanBeTightenedInspection.samePackages(memberPackage, aPackage) && (qualifierPackage == null || AccessCanBeTightenedInspection.samePackages(qualifierPackage, aPackage))) {
                return AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            if (qualifier != null) {
                return 4;
            }
            if (innerClass != null && memberClass != null && innerClass.isInheritor(memberClass, true)) {
                boolean isConstructor;
                PsiElement resolved = element instanceof PsiReference ? ((PsiReference)((Object)element)).resolve() : null;
                boolean bl = isConstructor = resolved instanceof PsiClass && element.getParent() instanceof PsiNewExpression || resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor();
                if (!isConstructor) {
                    return 3;
                }
            }
            return 4;
        }

        private boolean calledOnInheritor(@NotNull PsiElement element, PsiClass memberClass) {
            PsiExpression qualifier;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            if ((qualifier = AccessCanBeTightenedInspection.getQualifier(element)) == null) {
                return false;
            }
            PsiClass qClass = PsiUtil.resolveClassInClassTypeOnly(qualifier.getType());
            return qClass != null && qClass.isInheritor(memberClass, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 11: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 4: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxLevel";
                    break;
                }
                case 6: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foundUsage";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkMember";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suggestLevel";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleUsage";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEffectiveLevel";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calledOnInheritor";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$suggestLevel$2";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$suggestLevel$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

