/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.javaee.ExternalResourceListener;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.javaee.ResourceRegistrarImpl;
import com.intellij.javaee.StandardResourceEP;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.javaee.XMLCatalogManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalResourceManagerImpl", storages={@Storage(value="javaeeExternalResources.xml"), @Storage(value="other.xml", deprecated=true)})
public class ExternalResourceManagerExImpl
extends ExternalResourceManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ExternalResourceManagerExImpl.class);
    @NonNls
    public static final String J2EE_1_3 = "http://java.sun.com/dtd/";
    @NonNls
    public static final String J2EE_1_2 = "http://java.sun.com/j2ee/dtds/";
    @NonNls
    public static final String J2EE_NS = "http://java.sun.com/xml/ns/j2ee/";
    @NonNls
    public static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee/";
    private static final String CATALOG_PROPERTIES_ELEMENT = "CATALOG_PROPERTIES";
    private static final String XSD_1_1 = new Resource("/standardSchemas/XMLSchema-1_1/XMLSchema.xsd", ExternalResourceManagerExImpl.class, null).getResourceUrl();
    private final Map<String, Map<String, String>> myResources = new THashMap();
    private final Set<String> myResourceLocations = new THashSet();
    private final Set<String> myIgnoredResources = new TreeSet<String>();
    private final Set<String> myStandardIgnoredResources = new TreeSet<String>();
    private final NotNullLazyValue<Map<String, Map<String, Resource>>> myStandardResources = new AtomicNotNullLazyValue<Map<String, Map<String, Resource>>>(){

        @Override
        @NotNull
        protected Map<String, Map<String, Resource>> compute() {
            Map<String, Map<String, Resource>> map = ExternalResourceManagerExImpl.this.computeStdResources();
            if (map == null) {
                1.$$$reportNull$$$0(0);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ExternalResourceManagerExImpl$1", "compute"));
        }
    };
    private final CachedValueProvider<MultiMap<String, String>> myUrlByNamespaceProvider = () -> {
        MultiMap<String, String> result2 = new MultiMap<String, String>();
        Collection<Map<String, Resource>> values = this.myStandardResources.getValue().values();
        for (Map<String, Resource> map : values) {
            for (Map.Entry<String, Resource> entry : map.entrySet()) {
                String namespace;
                VirtualFile file;
                String url = entry.getValue().getResourceUrl();
                if (url == null || (file = VfsUtilCore.findRelativeFile(url, null)) == null || (namespace = XmlNamespaceIndex.computeNamespace(file)) == null) continue;
                result2.putValue(namespace, entry.getKey());
            }
        }
        return CachedValueProvider.Result.create(result2, this);
    };
    private String myDefaultHtmlDoctype = "HTML5";
    private ExternalResourceManagerEx.XMLSchemaVersion myXMLSchemaVersion = ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0;
    private String myCatalogPropertiesFile;
    private XMLCatalogManager myCatalogManager;
    private static final String HTML5_DOCTYPE_ELEMENT = "HTML5";
    private final List<ExternalResourceListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NonNls
    private static final String RESOURCE_ELEMENT = "resource";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String LOCATION_ATTR = "location";
    @NonNls
    private static final String IGNORED_RESOURCE_ELEMENT = "ignored-resource";
    @NonNls
    private static final String HTML_DEFAULT_DOCTYPE_ELEMENT = "default-html-doctype";
    @NonNls
    private static final String XML_SCHEMA_VERSION = "xml-schema-version";
    private static final String DEFAULT_VERSION = "";
    private static final NotNullLazyKey<ExternalResourceManagerExImpl, Project> INSTANCE_CACHE = ServiceManager.createLazyKey(ExternalResourceManagerExImpl.class);

    protected Map<String, Map<String, Resource>> computeStdResources() {
        ResourceRegistrarImpl registrar = new ResourceRegistrarImpl();
        for (StandardResourceProvider provider : StandardResourceProvider.EP_NAME.getExtensions()) {
            provider.registerResources(registrar);
        }
        for (StandardResourceEP extension : StandardResourceEP.EP_NAME.getExtensions()) {
            registrar.addStdResource(extension.url, extension.version, extension.resourcePath, null, extension.getLoaderForClass());
        }
        this.myStandardIgnoredResources.addAll(registrar.getIgnored());
        return registrar.getResources();
    }

    @Override
    public boolean isStandardResource(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return parent != null && parent.getName().equals("standardSchemas");
    }

    @Override
    public boolean isUserResource(VirtualFile file) {
        return this.myResourceLocations.contains(file.getUrl());
    }

    @Nullable
    static <T> Map<String, T> getMap(@NotNull Map<String, Map<String, T>> resources, @Nullable String version, boolean create) {
        Object map;
        if (resources == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(0);
        }
        if ((map = resources.get(version = StringUtil.notNullize(version, DEFAULT_VERSION))) == null) {
            if (create) {
                map = new THashMap();
                resources.put(version, (Map<String, T>)map);
            } else if (!version.equals(DEFAULT_VERSION)) {
                map = resources.get(DEFAULT_VERSION);
            }
        }
        return map;
    }

    @Override
    public String getResourceLocation(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(1);
        }
        return this.getResourceLocation(url, DEFAULT_VERSION);
    }

    @Override
    public String getResourceLocation(@NotNull @NonNls String url, @Nullable String version) {
        String result2;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(2);
        }
        if ((result2 = this.getUserResource(url, StringUtil.notNullize(version, DEFAULT_VERSION))) == null) {
            XMLCatalogManager manager = this.getCatalogManager();
            if (manager != null) {
                result2 = manager.resolve(url);
            }
            if (result2 == null && (result2 = this.getStdResource(url, version)) == null) {
                return url;
            }
        }
        return result2;
    }

    @Override
    @Nullable
    public String getUserResource(Project project, String url, String version) {
        String resource = ExternalResourceManagerExImpl.getProjectResources(project).getUserResource(url, version);
        return resource == null ? this.getUserResource(url, version) : resource;
    }

    @Override
    @Nullable
    public String getStdResource(@NotNull String url, @Nullable String version) {
        Map map;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(3);
        }
        if ((map = ExternalResourceManagerExImpl.getMap(this.myStandardResources.getValue(), version, false)) != null) {
            Resource resource = (Resource)map.get(url);
            return resource == null ? null : resource.getResourceUrl();
        }
        return null;
    }

    @Nullable
    private String getUserResource(@NotNull String url, @Nullable String version) {
        Map map;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(4);
        }
        return (map = ExternalResourceManagerExImpl.getMap(this.myResources, version, false)) != null ? (String)map.get(url) : null;
    }

    @Override
    public String getResourceLocation(@NotNull @NonNls String url, @NotNull Project project) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(6);
        }
        return this.getResourceLocation(url, null, project);
    }

    private String getResourceLocation(@NonNls String url, String version, @NotNull Project project) {
        ExternalResourceManagerExImpl projectResources;
        String location;
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(7);
        }
        if ((location = (projectResources = ExternalResourceManagerExImpl.getProjectResources(project)).getResourceLocation(url, version)) == null || location.equals(url)) {
            if (projectResources.myXMLSchemaVersion == ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1) {
                if ("http://www.w3.org/2001/XMLSchema".equals(url)) {
                    return XSD_1_1;
                }
                if ("http://www.w3.org/2001/XMLSchema.xsd".equals(url)) {
                    return XSD_1_1;
                }
            }
            return this.getResourceLocation(url, version);
        }
        return location;
    }

    @Override
    @Nullable
    public PsiFile getResourceLocation(@NotNull @NonNls String url, @NotNull PsiFile baseFile, String version) {
        XmlFile schema;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(8);
        }
        if (baseFile == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(9);
        }
        if ((schema = XmlSchemaProvider.findSchema(url, baseFile)) != null) {
            return schema;
        }
        String location = this.getResourceLocation(url, version, baseFile.getProject());
        return XmlUtil.findXmlFile(baseFile, location);
    }

    @Override
    public String[] getResourceUrls(FileType fileType, boolean includeStandard) {
        return this.getResourceUrls(fileType, DEFAULT_VERSION, includeStandard);
    }

    @Override
    public String[] getResourceUrls(@Nullable FileType fileType, @Nullable @NonNls String version, boolean includeStandard) {
        LinkedList<String> result2 = new LinkedList<String>();
        ExternalResourceManagerExImpl.addResourcesFromMap(result2, version, this.myResources);
        if (includeStandard) {
            ExternalResourceManagerExImpl.addResourcesFromMap(result2, version, this.myStandardResources.getValue());
        }
        return ArrayUtil.toStringArray(result2);
    }

    private static <T> void addResourcesFromMap(@NotNull List<String> result2, @Nullable String version, @NotNull Map<String, Map<String, T>> resourcesMap) {
        Map<String, T> resources;
        if (result2 == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(10);
        }
        if (resourcesMap == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(11);
        }
        if ((resources = ExternalResourceManagerExImpl.getMap(resourcesMap, version, false)) != null) {
            result2.addAll(resources.keySet());
        }
    }

    public static void addTestResource(final String url, String location, Disposable parentDisposable) {
        final ExternalResourceManagerExImpl instance = (ExternalResourceManagerExImpl)ExternalResourceManagerExImpl.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> instance.addResource(url, location));
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ApplicationManager.getApplication().runWriteAction(() -> instance.removeResource(url));
            }
        });
    }

    @Override
    public void addResource(@NotNull String url, String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(12);
        }
        this.addResource(url, DEFAULT_VERSION, location);
    }

    @Override
    public void addResource(@NotNull @NonNls String url, @NonNls String version, @NonNls String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.addSilently(url, version, location);
        this.fireExternalResourceChanged();
    }

    private void addSilently(@NotNull String url, @Nullable String version, String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(14);
        }
        Map map = ExternalResourceManagerExImpl.getMap(this.myResources, version, true);
        assert (map != null);
        map.put(url, location);
        this.myResourceLocations.add(location);
        this.incModificationCount();
    }

    @Override
    public void removeResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(15);
        }
        this.removeResource(url, DEFAULT_VERSION);
    }

    @Override
    public void removeResource(@NotNull String url, @Nullable String version) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Map map = ExternalResourceManagerExImpl.getMap(this.myResources, version, false);
        if (map != null) {
            String location = (String)map.remove(url);
            if (location != null) {
                this.myResourceLocations.remove(location);
            }
            this.incModificationCount();
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public void removeResource(String url, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(17);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).removeResource(url);
    }

    @Override
    public void addResource(@NonNls String url, @NonNls String location, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(18);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).addResource(url, location);
    }

    @Override
    public String[] getAvailableUrls() {
        THashSet urls = new THashSet();
        for (Map<String, String> map : this.myResources.values()) {
            urls.addAll(map.keySet());
        }
        return ArrayUtil.toStringArray((Collection<String>)urls);
    }

    @Override
    public String[] getAvailableUrls(Project project) {
        return ExternalResourceManagerExImpl.getProjectResources(project).getAvailableUrls();
    }

    @Override
    public void clearAllResources() {
        this.myResources.clear();
        this.myIgnoredResources.clear();
    }

    @Override
    public void clearAllResources(Project project) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.clearAllResources();
        ExternalResourceManagerExImpl.getProjectResources(project).clearAllResources();
        this.incModificationCount();
        this.fireExternalResourceChanged();
    }

    @Override
    public void addIgnoredResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.addIgnoredSilently(url)) {
            this.fireExternalResourceChanged();
        }
    }

    private boolean addIgnoredSilently(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(20);
        }
        if (this.myStandardIgnoredResources.contains(url)) {
            return false;
        }
        if (this.myIgnoredResources.add(url)) {
            this.incModificationCount();
            return true;
        }
        return false;
    }

    @Override
    public void removeIgnoredResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myIgnoredResources.remove(url)) {
            this.incModificationCount();
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public boolean isIgnoredResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(22);
        }
        if (this.myIgnoredResources.contains(url)) {
            return true;
        }
        this.myStandardResources.getValue();
        return this.myStandardIgnoredResources.contains(url) || ExternalResourceManagerExImpl.isImplicitNamespaceDescriptor(url);
    }

    private static boolean isImplicitNamespaceDescriptor(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(23);
        }
        for (ImplicitNamespaceDescriptorProvider provider : ImplicitNamespaceDescriptorProvider.EP_NAME.getExtensions()) {
            if (provider.getNamespaceDescriptor(null, url, null) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getIgnoredResources() {
        this.myStandardResources.getValue();
        if (this.myIgnoredResources.isEmpty()) {
            return ArrayUtil.toStringArray(this.myStandardIgnoredResources);
        }
        THashSet set = new THashSet(this.myIgnoredResources.size() + this.myStandardIgnoredResources.size());
        set.addAll(this.myIgnoredResources);
        set.addAll(this.myStandardIgnoredResources);
        return ArrayUtil.toStringArray((Collection<String>)set);
    }

    @Override
    public long getModificationCount(@NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(24);
        }
        return ExternalResourceManagerExImpl.getProjectResources(project).getModificationCount();
    }

    @Override
    @Nullable
    public Element getState() {
        Element e;
        Element element = new Element("state");
        TreeSet<String> urls = new TreeSet<String>();
        for (Map<String, String> map : this.myResources.values()) {
            urls.addAll(map.keySet());
        }
        for (String url : urls) {
            String location;
            if (url == null || (location = this.getResourceLocation(url)) == null) continue;
            Element e2 = new Element(RESOURCE_ELEMENT);
            e2.setAttribute(URL_ATTR, url);
            e2.setAttribute(LOCATION_ATTR, location.replace(File.separatorChar, '/'));
            element.addContent(e2);
        }
        this.myIgnoredResources.removeAll(this.myStandardIgnoredResources);
        for (String ignoredResource : this.myIgnoredResources) {
            Element e3 = new Element(IGNORED_RESOURCE_ELEMENT);
            e3.setAttribute(URL_ATTR, ignoredResource);
            element.addContent(e3);
        }
        if (this.myDefaultHtmlDoctype != null && !HTML5_DOCTYPE_ELEMENT.equals(this.myDefaultHtmlDoctype)) {
            e = new Element(HTML_DEFAULT_DOCTYPE_ELEMENT);
            e.setText(this.myDefaultHtmlDoctype);
            element.addContent(e);
        }
        if (this.myXMLSchemaVersion != ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0) {
            e = new Element(XML_SCHEMA_VERSION);
            e.setText(this.myXMLSchemaVersion.toString());
            element.addContent(e);
        }
        if (this.myCatalogPropertiesFile != null) {
            Element properties = new Element(CATALOG_PROPERTIES_ELEMENT);
            properties.setText(this.myCatalogPropertiesFile);
            element.addContent(properties);
        }
        ReplacePathToMacroMap macroReplacements = new ReplacePathToMacroMap();
        PathMacrosImpl.getInstanceEx().addMacroReplacements(macroReplacements);
        macroReplacements.substitute(element, SystemInfo.isFileSystemCaseSensitive);
        return element;
    }

    @Override
    public void loadState(Element state) {
        Element catalogElement;
        Element schemaElement;
        ExpandMacroToPathMap macroExpands = new ExpandMacroToPathMap();
        PathMacrosImpl.getInstanceEx().addMacroExpands(macroExpands);
        macroExpands.substitute(state, SystemInfo.isFileSystemCaseSensitive);
        this.incModificationCount();
        for (Element element : state.getChildren(RESOURCE_ELEMENT)) {
            String url = element.getAttributeValue(URL_ATTR);
            if (StringUtil.isEmpty(url)) continue;
            this.addSilently(url, DEFAULT_VERSION, element.getAttributeValue(LOCATION_ATTR).replace('/', File.separatorChar));
        }
        this.myIgnoredResources.clear();
        for (Element element : state.getChildren(IGNORED_RESOURCE_ELEMENT)) {
            this.addIgnoredSilently(element.getAttributeValue(URL_ATTR));
        }
        Element child = state.getChild(HTML_DEFAULT_DOCTYPE_ELEMENT);
        if (child != null) {
            String text2 = child.getText();
            if (FileUtil.toSystemIndependentName(text2).endsWith(".jar!/resources/html5-schema/html5.rnc")) {
                text2 = HTML5_DOCTYPE_ELEMENT;
            }
            this.myDefaultHtmlDoctype = text2;
        }
        if ((schemaElement = state.getChild(XML_SCHEMA_VERSION)) != null) {
            String text3 = schemaElement.getText();
            ExternalResourceManagerEx.XMLSchemaVersion xMLSchemaVersion = this.myXMLSchemaVersion = ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1.toString().equals(text3) ? ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1 : ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0;
        }
        if ((catalogElement = state.getChild(CATALOG_PROPERTIES_ELEMENT)) != null) {
            this.myCatalogPropertiesFile = catalogElement.getTextTrim();
        }
    }

    @Override
    public void addExternalResourceListener(ExternalResourceListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeExternalResourceListener(ExternalResourceListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireExternalResourceChanged() {
        for (ExternalResourceListener listener : this.myListeners) {
            listener.externalResourceChanged();
        }
        this.incModificationCount();
    }

    Collection<Map<String, Resource>> getStandardResources() {
        return this.myStandardResources.getValue().values();
    }

    private static ExternalResourceManagerExImpl getProjectResources(Project project) {
        return INSTANCE_CACHE.getValue(project);
    }

    @Override
    @NotNull
    public String getDefaultHtmlDoctype(@NotNull Project project) {
        String doctype;
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(25);
        }
        if ("http://www.w3.org/1999/xhtml".equals(doctype = ExternalResourceManagerExImpl.getProjectResources((Project)project).myDefaultHtmlDoctype)) {
            String string = XmlUtil.XHTML4_SCHEMA_LOCATION;
            if (string == null) {
                ExternalResourceManagerExImpl.$$$reportNull$$$0(26);
            }
            return string;
        }
        if (HTML5_DOCTYPE_ELEMENT.equals(doctype)) {
            String string = Html5SchemaProvider.getHtml5SchemaLocation();
            if (string == null) {
                ExternalResourceManagerExImpl.$$$reportNull$$$0(27);
            }
            return string;
        }
        String string = doctype;
        if (string == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    public void setDefaultHtmlDoctype(@NotNull String defaultHtmlDoctype, @NotNull Project project) {
        if (defaultHtmlDoctype == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(29);
        }
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(30);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).setDefaultHtmlDoctype(defaultHtmlDoctype);
    }

    @Override
    public ExternalResourceManagerEx.XMLSchemaVersion getXmlSchemaVersion(@NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(31);
        }
        return ExternalResourceManagerExImpl.getProjectResources((Project)project).myXMLSchemaVersion;
    }

    @Override
    public void setXmlSchemaVersion(ExternalResourceManagerEx.XMLSchemaVersion version, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(32);
        }
        ExternalResourceManagerExImpl.getProjectResources((Project)project).myXMLSchemaVersion = version;
        this.fireExternalResourceChanged();
    }

    @Override
    public String getCatalogPropertiesFile() {
        return this.myCatalogPropertiesFile;
    }

    @Override
    public void setCatalogPropertiesFile(String filePath) {
        this.myCatalogManager = null;
        this.myCatalogPropertiesFile = filePath;
        this.incModificationCount();
    }

    @Override
    public MultiMap<String, String> getUrlsByNamespace(Project project) {
        return CachedValuesManager.getManager(project).getCachedValue(project, this.myUrlByNamespaceProvider);
    }

    @Nullable
    private XMLCatalogManager getCatalogManager() {
        if (this.myCatalogManager == null && this.myCatalogPropertiesFile != null) {
            this.myCatalogManager = new XMLCatalogManager(this.myCatalogPropertiesFile);
        }
        return this.myCatalogManager;
    }

    private void setDefaultHtmlDoctype(String defaultHtmlDoctype) {
        this.incModificationCount();
        this.myDefaultHtmlDoctype = Html5SchemaProvider.getHtml5SchemaLocation().equals(defaultHtmlDoctype) ? HTML5_DOCTYPE_ELEMENT : defaultHtmlDoctype;
        this.fireExternalResourceChanged();
    }

    public static void registerResourceTemporarily(final String url, String location, Disposable disposable) {
        ApplicationManager.getApplication().runWriteAction(() -> ExternalResourceManagerExImpl.getInstance().addResource(url, location));
        Disposer.register(disposable, new Disposable(){

            @Override
            public void dispose() {
                ApplicationManager.getApplication().runWriteAction(() -> ExternalResourceManager.getInstance().removeResource(url));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTR;
                break;
            }
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcesMap";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ExternalResourceManagerExImpl";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHtmlDoctype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ExternalResourceManagerExImpl";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultHtmlDoctype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResourceLocation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStdResource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUserResource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addResourcesFromMap";
                break;
            }
            case 12: 
            case 13: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addResource";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addSilently";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeResource";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredResource";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredSilently";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeIgnoredResource";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredResource";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitNamespaceDescriptor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getModificationCount";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultHtmlDoctype";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultHtmlDoctype";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getXmlSchemaVersion";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setXmlSchemaVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Resource {
        private final String myFile;
        private final ClassLoader myClassLoader;
        private final Class myClass;
        private volatile String myResolvedResourcePath;

        Resource(String _file, Class _class, ClassLoader _classLoader) {
            this.myFile = _file;
            this.myClass = _class;
            this.myClassLoader = _classLoader;
        }

        Resource(String _file, Resource baseResource) {
            this(_file, baseResource.myClass, baseResource.myClassLoader);
        }

        String directoryName() {
            int i = this.myFile.lastIndexOf(47);
            return i > 0 ? this.myFile.substring(0, i) : this.myFile;
        }

        @Nullable
        String getResourceUrl() {
            URL resource;
            String resolvedResourcePath = this.myResolvedResourcePath;
            if (resolvedResourcePath != null) {
                return resolvedResourcePath;
            }
            URL uRL = resource = this.myClass == null ? this.myClassLoader.getResource(this.myFile) : this.myClass.getResource(this.myFile);
            if (resource == null) {
                String message = "Cannot find standard resource. filename:" + this.myFile + " class=" + this.myClass + ", classLoader:" + this.myClassLoader;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error(message);
                } else {
                    LOG.warn(message);
                }
                this.myResolvedResourcePath = null;
                return null;
            }
            String path = FileUtil.unquote(resource.toString());
            this.myResolvedResourcePath = path = path.replace('\\', '/');
            return path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            if (this.myClassLoader != resource.myClassLoader) {
                return false;
            }
            if (this.myClass != resource.myClass) {
                return false;
            }
            return !(this.myFile != null ? !this.myFile.equals(resource.myFile) : resource.myFile != null);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        public String toString() {
            return this.myFile + " for " + this.myClassLoader;
        }
    }
}

