/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.BufferedStringList;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.List2D;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.diff.Diff;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.highlighting.Util");
    private static final String DELIMITERS = " \n\r\t(){}[],./?`~!@#$%^&*-=+|\\;:'\"<>";
    public static final TIntHashSet DELIMITERS_SET = new TIntHashSet();

    @NotNull
    static String[] splitByWord(@NotNull String string) {
        if (string == null) {
            Util.$$$reportNull$$$0(0);
        }
        BufferedStringList stringList = new BufferedStringList();
        StringTokenizer tokenizer = new StringTokenizer(string, DELIMITERS, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 && DELIMITERS_SET.contains((int)token.charAt(0))) {
                char delimiter = token.charAt(0);
                if (delimiter == '\n') {
                    stringList.appendToLast(token);
                    stringList.flushLast();
                    continue;
                }
                if (Character.isWhitespace(delimiter)) {
                    stringList.appendToLast(token);
                    continue;
                }
            }
            stringList.add(token);
        }
        String[] stringArray = stringList.toArray();
        if (stringArray == null) {
            Util.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    static boolean isSpaceOnly(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            Util.$$$reportNull$$$0(2);
        }
        return Util.isSpaceOnly(fragment.getText1()) && Util.isSpaceOnly(fragment.getText2());
    }

    private static boolean isSpaceOnly(@Nullable DiffString string) {
        if (string == null) {
            return true;
        }
        return string.isEmptyOrSpaces();
    }

    @NotNull
    static DiffFragment[] splitByLines(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            Util.$$$reportNull$$$0(3);
        }
        DiffString[] lines1 = Util.splitByLines(fragment.getText1());
        DiffString[] lines2 = Util.splitByLines(fragment.getText2());
        if (lines1 != null && lines2 != null && lines1.length != lines2.length) {
            LOG.error("1:<" + fragment.getText1() + "> 2:<" + fragment.getText2() + ">");
        }
        int length = lines1 == null ? lines2.length : lines1.length;
        DiffFragment[] lines = new DiffFragment[length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = new DiffFragment(lines1 == null ? null : lines1[i], lines2 == null ? null : lines2[i]);
        }
        if (lines == null) {
            Util.$$$reportNull$$$0(4);
        }
        return lines;
    }

    @Nullable
    private static DiffString[] splitByLines(@Nullable DiffString string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf('\n') == -1) {
            return new DiffString[]{string};
        }
        return string.tokenize();
    }

    @NotNull
    public static DiffFragment[][] splitByUnchangedLines(@NotNull DiffFragment[] fragments) {
        if (fragments == null) {
            Util.$$$reportNull$$$0(5);
        }
        List2D result2 = new List2D();
        block0: for (int i = 0; i < fragments.length; ++i) {
            int length2;
            int length1;
            DiffFragment fragment = fragments[i];
            if (!fragment.isEqual()) {
                result2.add(fragment);
                continue;
            }
            DiffString text1 = fragment.getText1();
            DiffString text2 = fragment.getText2();
            assert (text1 != null);
            assert (text2 != null);
            if (StringUtil.endsWithChar(text1, '\n') && StringUtil.endsWithChar(text2, '\n')) {
                result2.add(fragment);
                result2.newRow();
                continue;
            }
            do {
                int newLine1 = text1.indexOf('\n');
                int newLine2 = text2.indexOf('\n');
                if (newLine1 == -1 || newLine2 == -1) {
                    result2.add(DiffFragment.unchanged(text1, text2));
                    continue block0;
                }
                result2.add(DiffFragment.unchanged(text1.substring(0, newLine1 + 1), text2.substring(0, newLine2 + 1)));
                result2.newRow();
                text1 = text1.substring(newLine1 + 1);
                text2 = text2.substring(newLine2 + 1);
                length1 = text1.length();
                length2 = text2.length();
            } while (length1 != 0 && length2 != 0);
            if (length1 == 0 && length2 == 0) continue;
            result2.add(DiffFragment.unchanged(text1, text2));
        }
        DiffFragment[][] diffFragmentArray = result2.toArray();
        if (diffFragmentArray == null) {
            Util.$$$reportNull$$$0(6);
        }
        return diffFragmentArray;
    }

    public static Diff.Change concatEquals(Diff.Change change, @NotNull Object[] left, @NotNull Object[] right) {
        MyChange startChange;
        if (left == null) {
            Util.$$$reportNull$$$0(7);
        }
        if (right == null) {
            Util.$$$reportNull$$$0(8);
        }
        MyChange lastChange = startChange = new MyChange(0, 0, 0, 0);
        while (change != null) {
            int shift;
            if (change.inserted > 0 && change.deleted > 0) {
                lastChange = lastChange.copyNext(change);
            } else if (change.inserted > 0) {
                shift = Util.calcShift(right, lastChange.getEnd2(), change.line1, change.inserted);
                lastChange = lastChange.copyNext(change, shift);
            } else if (change.deleted > 0) {
                shift = Util.calcShift(left, lastChange.getEnd1(), change.line0, change.deleted);
                lastChange = lastChange.copyNext(change, shift);
            } else {
                LOG.assertTrue(false);
            }
            change = change.link;
        }
        return Util.concatSingleSide(startChange.link);
    }

    private static Diff.Change concatSingleSide(Diff.Change change) {
        MyChange startChange;
        MyChange lastChange = startChange = new MyChange(0, 0, 0, 0);
        MyChange prevChange = null;
        while (change != null) {
            if (prevChange == null || change.inserted > 0 && change.deleted > 0) {
                prevChange = lastChange;
                lastChange = lastChange.copyNext(change);
            } else {
                MyChange newChange = null;
                if (change.deleted == 0 && lastChange.deleted == 0 && change.line1 == lastChange.getEnd2()) {
                    newChange = new MyChange(lastChange.line0, lastChange.line1, 0, lastChange.inserted + change.inserted);
                } else if (change.inserted == 0 && lastChange.inserted == 0 && change.line0 == lastChange.getEnd1()) {
                    newChange = new MyChange(lastChange.line0, lastChange.line1, lastChange.deleted + change.deleted, 0);
                }
                if (newChange != null) {
                    prevChange.setNext(newChange);
                    lastChange = newChange;
                } else {
                    prevChange = lastChange;
                    lastChange = lastChange.copyNext(change);
                }
            }
            change = change.link;
        }
        return startChange.link;
    }

    static int calcShift(@NotNull Object[] list, int limit, int start, int length) {
        if (list == null) {
            Util.$$$reportNull$$$0(9);
        }
        int shift = start - limit;
        for (int i = 0; i < shift; ++i) {
            if (list[limit + i].equals(list[start + length - shift + i])) continue;
            return 0;
        }
        return -shift;
    }

    @NotNull
    public static DiffFragment unite(@NotNull DiffFragment fragment1, @NotNull DiffFragment fragment2) {
        if (fragment1 == null) {
            Util.$$$reportNull$$$0(10);
        }
        if (fragment2 == null) {
            Util.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(Util.isSameType(fragment1, fragment2));
        if (!fragment1.isOneSide()) {
            DiffString unitedText1 = DiffString.concatenateNullable(fragment1.getText1(), fragment2.getText1());
            DiffString unitedText2 = DiffString.concatenateNullable(fragment1.getText2(), fragment2.getText2());
            LOG.assertTrue(fragment1.isEqual() == fragment2.isEqual());
            DiffFragment diffFragment = fragment1.isEqual() ? DiffFragment.unchanged(unitedText1, unitedText2) : new DiffFragment(unitedText1, unitedText2);
            if (diffFragment == null) {
                Util.$$$reportNull$$$0(12);
            }
            return diffFragment;
        }
        FragmentSide side = FragmentSide.chooseSide(fragment1);
        DiffFragment diffFragment = side.createFragment(DiffString.concatenateNullable(side.getText(fragment1), side.getText(fragment2)), null, fragment1.isModified());
        if (diffFragment == null) {
            Util.$$$reportNull$$$0(13);
        }
        return diffFragment;
    }

    public static boolean isSameType(@NotNull DiffFragment fragment1, @NotNull DiffFragment fragment2) {
        if (fragment1 == null) {
            Util.$$$reportNull$$$0(14);
        }
        if (fragment2 == null) {
            Util.$$$reportNull$$$0(15);
        }
        if (fragment1.isEqual()) {
            return fragment2.isEqual();
        }
        if (fragment1.isChange()) {
            return fragment2.isChange();
        }
        if (fragment1.getText1() == null) {
            return fragment2.getText1() == null;
        }
        if (fragment1.getText2() == null) {
            return fragment2.getText2() == null;
        }
        LOG.assertTrue(false);
        return false;
    }

    @NotNull
    public static DiffString getText(@NotNull DiffFragment[] fragments, @NotNull FragmentSide side) {
        if (fragments == null) {
            Util.$$$reportNull$$$0(16);
        }
        if (side == null) {
            Util.$$$reportNull$$$0(17);
        }
        DiffString[] data = new DiffString[fragments.length];
        for (int i = 0; i < fragments.length; ++i) {
            DiffFragment fragment = fragments[i];
            data[i] = side.getText(fragment);
        }
        DiffString diffString = DiffString.concatenate(data);
        if (diffString == null) {
            Util.$$$reportNull$$$0(18);
        }
        return diffString;
    }

    @NotNull
    public static DiffFragment concatenate(@NotNull DiffFragment[] line) {
        if (line == null) {
            Util.$$$reportNull$$$0(19);
        }
        DiffFragment diffFragment = Util.concatenate(line, 0, line.length);
        if (diffFragment == null) {
            Util.$$$reportNull$$$0(20);
        }
        return diffFragment;
    }

    @NotNull
    public static DiffFragment concatenate(@NotNull DiffFragment[] line, int from, int to) {
        if (line == null) {
            Util.$$$reportNull$$$0(21);
        }
        DiffString[] data1 = new DiffString[to - from];
        DiffString[] data2 = new DiffString[to - from];
        boolean isEqual = true;
        for (int i = 0; i < to - from; ++i) {
            DiffFragment fragment = line[from + i];
            isEqual &= fragment.isEqual();
            data1[i] = fragment.getText1();
            data2[i] = fragment.getText2();
        }
        DiffString text1 = Util.notEmptyContent(DiffString.concatenate(data1));
        DiffString text2 = Util.notEmptyContent(DiffString.concatenate(data2));
        DiffFragment diffFragment = isEqual ? DiffFragment.unchanged(text1, text2) : new DiffFragment(text1, text2);
        if (diffFragment == null) {
            Util.$$$reportNull$$$0(22);
        }
        return diffFragment;
    }

    @Nullable
    private static DiffString notEmptyContent(@NotNull DiffString string) {
        if (string == null) {
            Util.$$$reportNull$$$0(23);
        }
        return string.length() > 0 ? string : null;
    }

    @NotNull
    public static DiffFragment[][] uniteFormattingOnly(@NotNull DiffFragment[][] lines) {
        if (lines == null) {
            Util.$$$reportNull$$$0(24);
        }
        List2D result2 = new List2D();
        for (int i = 0; i < lines.length; ++i) {
            DiffFragment[] line = lines[i];
            if (!Util.areEqual(line) && Util.areEqualOrFormatting(line)) {
                result2.addAll(line);
                continue;
            }
            result2.newRow();
            result2.addAll(line);
            result2.newRow();
        }
        DiffFragment[][] diffFragmentArray = result2.toArray();
        if (diffFragmentArray == null) {
            Util.$$$reportNull$$$0(25);
        }
        return diffFragmentArray;
    }

    private static boolean areEqualOrFormatting(@NotNull DiffFragment[] fragments) {
        if (fragments == null) {
            Util.$$$reportNull$$$0(26);
        }
        for (int i = 0; i < fragments.length; ++i) {
            DiffFragment fragment = fragments[i];
            if (fragment.isEqual()) continue;
            for (int side = 0; side < 2; ++side) {
                DiffString text2 = FragmentSide.fromIndex(side).getText(fragment);
                if (text2 == null || text2.isEmptyOrSpaces()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean areEqual(@NotNull DiffFragment[] fragments) {
        if (fragments == null) {
            Util.$$$reportNull$$$0(27);
        }
        for (int i = 0; i < fragments.length; ++i) {
            DiffFragment fragment = fragments[i];
            if (fragment.isEqual()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static DiffFragment[] cutFirst(@NotNull DiffFragment[] fragments) {
        DiffFragment fragment;
        int i;
        if (fragments == null) {
            Util.$$$reportNull$$$0(28);
        }
        fragments = Util.transformHeadInsert(fragments, FragmentSide.SIDE1);
        fragments = Util.transformHeadInsert(fragments, FragmentSide.SIDE2);
        int nullCount = 0;
        block0: for (int sideIndex = 0; sideIndex < 2; ++sideIndex) {
            FragmentSide side = FragmentSide.fromIndex(sideIndex);
            for (i = 0; i < fragments.length; ++i) {
                DiffString text2;
                fragment = fragments[i];
                if (fragment == null || (text2 = side.getText(fragment)) == null || text2.isEmpty()) continue;
                text2 = text2.length() > 1 ? text2.substring(1) : null;
                DiffString otherText = side.getOtherText(fragment);
                if (otherText == null && text2 == null) {
                    fragments[i] = null;
                    ++nullCount;
                    continue block0;
                }
                fragments[i] = side.createFragment(text2, otherText, fragment.isModified());
                continue block0;
            }
        }
        if (nullCount == 0) {
            if (fragments == null) {
                Util.$$$reportNull$$$0(29);
            }
            return fragments;
        }
        DiffFragment[] result2 = new DiffFragment[fragments.length - nullCount];
        int dstIndex = 0;
        for (i = 0; i < fragments.length; ++i) {
            fragment = fragments[i];
            if (fragment == null) continue;
            result2[dstIndex] = fragment;
            ++dstIndex;
        }
        if (result2 == null) {
            Util.$$$reportNull$$$0(30);
        }
        return result2;
    }

    @NotNull
    private static DiffFragment[] transformHeadInsert(@NotNull DiffFragment[] fragments, @NotNull FragmentSide side) {
        if (fragments == null) {
            Util.$$$reportNull$$$0(31);
        }
        if (side == null) {
            Util.$$$reportNull$$$0(32);
        }
        if (fragments.length >= 2) {
            DiffFragment first = fragments[0];
            DiffFragment second = fragments[1];
            if (first == null || second == null) {
                if (fragments == null) {
                    Util.$$$reportNull$$$0(33);
                }
                return fragments;
            }
            if (side.getText(first) != null) {
                if (fragments == null) {
                    Util.$$$reportNull$$$0(34);
                }
                return fragments;
            }
            DiffString rightText = side.getOtherText(first);
            DiffString secondText = side.getText(second);
            if (!Comparing.equal(side.getOtherText(second), secondText)) {
                if (fragments == null) {
                    Util.$$$reportNull$$$0(35);
                }
                return fragments;
            }
            if (secondText.charAt(0) == rightText.charAt(0)) {
                ArrayList<DiffFragment> result2 = new ArrayList<DiffFragment>();
                result2.add(side.createFragment(rightText.substring(0, 1), rightText.substring(0, 1), false));
                result2.add(side.createFragment(null, DiffString.concatenate(rightText.substring(1), secondText.substring(0, 1)), true));
                result2.add(side.createFragment(secondText.substring(1), secondText.substring(1), second.isModified()));
                result2.addAll(Arrays.asList(fragments).subList(2, fragments.length));
                DiffFragment[] diffFragmentArray = result2.toArray(new DiffFragment[result2.size()]);
                if (diffFragmentArray == null) {
                    Util.$$$reportNull$$$0(36);
                }
                return diffFragmentArray;
            }
        }
        if (fragments == null) {
            Util.$$$reportNull$$$0(37);
        }
        return fragments;
    }

    static {
        char[] delimiters = DELIMITERS.toCharArray();
        for (int i = 0; i < delimiters.length; ++i) {
            char delimiter = delimiters[i];
            DELIMITERS_SET.add((int)delimiter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/highlighting/Util";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 5: 
            case 16: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment1";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment2";
                break;
            }
            case 17: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/highlighting/Util";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByWord";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByUnchangedLines";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unite";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenate";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteFormattingOnly";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "cutFirst";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "transformHeadInsert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "splitByWord";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSpaceOnly";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "splitByUnchangedLines";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "concatEquals";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcShift";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unite";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSameType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "concatenate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notEmptyContent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "uniteFormattingOnly";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "areEqualOrFormatting";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "cutFirst";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "transformHeadInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyChange
    extends Diff.Change {
        public MyChange(int line0, int line1, int deleted, int inserted) {
            super(line0, line1, deleted, inserted, null);
        }

        public MyChange copyNext(@NotNull Diff.Change change) {
            if (change == null) {
                MyChange.$$$reportNull$$$0(0);
            }
            return this.copyNext(change, 0);
        }

        public MyChange copyNext(@NotNull Diff.Change change, int shift) {
            if (change == null) {
                MyChange.$$$reportNull$$$0(1);
            }
            MyChange result2 = new MyChange(change.line0 + shift, change.line1 + shift, change.deleted, change.inserted);
            this.setNext(result2);
            return result2;
        }

        public void setNext(MyChange change) {
            this.link = change;
        }

        public int getEnd1() {
            return this.line0 + this.deleted;
        }

        public int getEnd2() {
            return this.line1 + this.inserted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/diff/impl/highlighting/Util$MyChange", "copyNext"));
        }
    }
}

