/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.ExcludeFolderImpl;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.SourceFolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;

public class ContentEntryImpl
extends RootModelComponentBase
implements ContentEntry,
ClonableContentEntry,
Comparable<ContentEntryImpl> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.SimpleContentEntryImpl");
    @NotNull
    private final VirtualFilePointer myRoot;
    @NonNls
    public static final String ELEMENT_NAME = "content";
    private final Set<SourceFolder> mySourceFolders;
    private final Set<ExcludeFolder> myExcludeFolders;
    @NonNls
    public static final String URL_ATTRIBUTE = "url";
    private List<String> myExcludePatterns;

    ContentEntryImpl(@NotNull VirtualFile file, @NotNull RootModelImpl m) {
        if (file == null) {
            ContentEntryImpl.$$$reportNull$$$0(0);
        }
        if (m == null) {
            ContentEntryImpl.$$$reportNull$$$0(1);
        }
        this(file.getUrl(), m);
    }

    ContentEntryImpl(@NotNull String url, @NotNull RootModelImpl m) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(2);
        }
        if (m == null) {
            ContentEntryImpl.$$$reportNull$$$0(3);
        }
        super(m);
        this.mySourceFolders = new LinkedHashSet<SourceFolder>();
        this.myExcludeFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
        this.myRoot = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, m.getRootsChangedListener());
    }

    ContentEntryImpl(@NotNull Element e, @NotNull RootModelImpl m) throws InvalidDataException {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(4);
        }
        if (m == null) {
            ContentEntryImpl.$$$reportNull$$$0(5);
        }
        this(ContentEntryImpl.getUrlFrom(e), m);
        this.loadSourceFolders(e);
        this.loadExcludeFolders(e);
        this.loadExcludePatterns(e);
    }

    private void loadExcludePatterns(@NotNull Element e) {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(6);
        }
        for (Element element : e.getChildren("excludePattern")) {
            this.addExcludePattern(element.getAttributeValue("pattern"));
        }
    }

    private static String getUrlFrom(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(ELEMENT_NAME.equals(e.getName()));
        String url = e.getAttributeValue(URL_ATTRIBUTE);
        if (url == null) {
            throw new InvalidDataException();
        }
        return url;
    }

    private void loadSourceFolders(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(8);
        }
        for (Element child : e.getChildren("sourceFolder")) {
            this.addSourceFolder(new SourceFolderImpl(child, this));
        }
    }

    private void loadExcludeFolders(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            ContentEntryImpl.$$$reportNull$$$0(9);
        }
        for (Element child : e.getChildren("excludeFolder")) {
            ExcludeFolderImpl excludeFolder = new ExcludeFolderImpl(child, this);
            this.addExcludeFolder(excludeFolder);
        }
    }

    @Override
    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myRoot.getUrl();
        if (string == null) {
            ContentEntryImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public SourceFolder[] getSourceFolders() {
        SourceFolder[] sourceFolderArray = this.mySourceFolders.toArray(new SourceFolder[this.mySourceFolders.size()]);
        if (sourceFolderArray == null) {
            ContentEntryImpl.$$$reportNull$$$0(11);
        }
        return sourceFolderArray;
    }

    @Override
    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            ContentEntryImpl.$$$reportNull$$$0(12);
        }
        List<SourceFolder> list = this.getSourceFolders(Collections.singleton(rootType));
        if (list == null) {
            ContentEntryImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ContentEntryImpl.$$$reportNull$$$0(14);
        }
        SmartList<SourceFolder> folders = new SmartList<SourceFolder>();
        for (SourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add(folder);
        }
        SmartList<SourceFolder> smartList = folders;
        if (smartList == null) {
            ContentEntryImpl.$$$reportNull$$$0(15);
        }
        return smartList;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceFolderFiles() {
        assert (!this.isDisposed());
        SourceFolder[] sourceFolders = this.getSourceFolders();
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(sourceFolders.length);
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile file = sourceFolder.getFile();
            if (file == null) continue;
            result2.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ContentEntryImpl.$$$reportNull$$$0(16);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public ExcludeFolder[] getExcludeFolders() {
        ExcludeFolder[] excludeFolderArray = this.myExcludeFolders.toArray(new ExcludeFolder[this.myExcludeFolders.size()]);
        if (excludeFolderArray == null) {
            ContentEntryImpl.$$$reportNull$$$0(17);
        }
        return excludeFolderArray;
    }

    @Override
    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (ExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.getRootModel().getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.getRootModel())) {
                excluded.add(pointer.getUrl());
            }
        }
        ArrayList<String> arrayList = excluded;
        if (arrayList == null) {
            ContentEntryImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludeFolderFiles() {
        assert (!this.isDisposed());
        ArrayList result2 = new ArrayList();
        for (ExcludeFolder excludeFolder : this.getExcludeFolders()) {
            ContainerUtil.addIfNotNull(result2, excludeFolder.getFile());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.getRootModel().getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.getRootModel())) {
                ContainerUtil.addIfNotNull(result2, pointer.getFile());
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ContentEntryImpl.$$$reportNull$$$0(19);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource) {
        if (file == null) {
            ContentEntryImpl.$$$reportNull$$$0(20);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, isTestSource, "");
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(21);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource, @NotNull String packagePrefix) {
        if (file == null) {
            ContentEntryImpl.$$$reportNull$$$0(22);
        }
        if (packagePrefix == null) {
            ContentEntryImpl.$$$reportNull$$$0(23);
        }
        JavaSourceRootType type = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        SourceFolder sourceFolder = this.addSourceFolder(file, type);
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(24);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (file == null) {
            ContentEntryImpl.$$$reportNull$$$0(25);
        }
        if (type == null) {
            ContentEntryImpl.$$$reportNull$$$0(26);
        }
        if (properties == null) {
            ContentEntryImpl.$$$reportNull$$$0(27);
        }
        this.assertCanAddFolder(file);
        SourceFolder sourceFolder = this.addSourceFolder(new SourceFolderImpl(file, JpsElementFactory.getInstance().createModuleSourceRoot(file.getUrl(), type, properties), this));
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(28);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type) {
        if (file == null) {
            ContentEntryImpl.$$$reportNull$$$0(29);
        }
        if (type == null) {
            ContentEntryImpl.$$$reportNull$$$0(30);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(31);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(32);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(33);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(34);
        }
        if (type == null) {
            ContentEntryImpl.$$$reportNull$$$0(35);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(36);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(37);
        }
        if (type == null) {
            ContentEntryImpl.$$$reportNull$$$0(38);
        }
        if (properties == null) {
            ContentEntryImpl.$$$reportNull$$$0(39);
        }
        this.assertFolderUnderMe(url);
        JpsModuleSourceRoot sourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(url, type, properties);
        SourceFolder sourceFolder = this.addSourceFolder(new SourceFolderImpl(sourceRoot, this));
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(40);
        }
        return sourceFolder;
    }

    @NotNull
    private SourceFolder addSourceFolder(@NotNull SourceFolderImpl f) {
        if (f == null) {
            ContentEntryImpl.$$$reportNull$$$0(41);
        }
        this.mySourceFolders.add(f);
        Disposer.register(this, f);
        SourceFolderImpl sourceFolderImpl = f;
        if (sourceFolderImpl == null) {
            ContentEntryImpl.$$$reportNull$$$0(42);
        }
        return sourceFolderImpl;
    }

    @Override
    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(43);
        }
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(sourceFolder, this.mySourceFolders);
        this.doRemove(sourceFolder);
    }

    private void doRemove(SourceFolder sourceFolder) {
        this.mySourceFolders.remove(sourceFolder);
        Disposer.dispose((Disposable)((Object)sourceFolder));
    }

    @Override
    public void clearSourceFolders() {
        assert (!this.isDisposed());
        this.getRootModel().assertWritable();
        for (SourceFolder folder : this.mySourceFolders) {
            Disposer.dispose((Disposable)((Object)folder));
        }
        this.mySourceFolders.clear();
    }

    @Override
    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file) {
        if (file == null) {
            ContentEntryImpl.$$$reportNull$$$0(44);
        }
        assert (!this.isDisposed());
        this.assertCanAddFolder(file);
        return this.addExcludeFolder(new ExcludeFolderImpl(file, this));
    }

    @Override
    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(45);
        }
        assert (!this.isDisposed());
        this.assertCanAddFolder(url);
        return this.addExcludeFolder(new ExcludeFolderImpl(url, this));
    }

    private void assertCanAddFolder(@NotNull VirtualFile file) {
        if (file == null) {
            ContentEntryImpl.$$$reportNull$$$0(46);
        }
        this.assertCanAddFolder(file.getUrl());
    }

    private void assertCanAddFolder(@NotNull String url) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(47);
        }
        this.getRootModel().assertWritable();
        this.assertFolderUnderMe(url);
    }

    @Override
    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        if (excludeFolder == null) {
            ContentEntryImpl.$$$reportNull$$$0(48);
        }
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(excludeFolder, this.myExcludeFolders);
        this.myExcludeFolders.remove(excludeFolder);
        Disposer.dispose((Disposable)((Object)excludeFolder));
    }

    @Override
    public boolean removeExcludeFolder(@NotNull String url) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(49);
        }
        for (ExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            Disposer.dispose((Disposable)((Object)folder));
            return true;
        }
        return false;
    }

    @Override
    public void clearExcludeFolders() {
        assert (!this.isDisposed());
        this.getRootModel().assertWritable();
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            Disposer.dispose((Disposable)((Object)excludeFolder));
        }
        this.myExcludeFolders.clear();
    }

    @Override
    @NotNull
    public List<String> getExcludePatterns() {
        List<String> list = this.myExcludePatterns != null ? Collections.unmodifiableList(this.myExcludePatterns) : Collections.emptyList();
        if (list == null) {
            ContentEntryImpl.$$$reportNull$$$0(50);
        }
        return list;
    }

    @Override
    public void addExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            ContentEntryImpl.$$$reportNull$$$0(51);
        }
        if (this.myExcludePatterns == null) {
            this.myExcludePatterns = new SmartList<String>();
        }
        this.myExcludePatterns.add(pattern);
    }

    @Override
    public void removeExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            ContentEntryImpl.$$$reportNull$$$0(52);
        }
        if (this.myExcludePatterns != null) {
            this.myExcludePatterns.remove(pattern);
            if (this.myExcludePatterns.isEmpty()) {
                this.myExcludePatterns = null;
            }
        }
    }

    @Override
    public void setExcludePatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            ContentEntryImpl.$$$reportNull$$$0(53);
        }
        if (patterns.isEmpty()) {
            this.myExcludePatterns = null;
        } else {
            if (this.myExcludePatterns == null) {
                this.myExcludePatterns = new SmartList<String>();
            } else {
                this.myExcludePatterns.clear();
            }
            this.myExcludePatterns.addAll(patterns);
        }
    }

    private ExcludeFolder addExcludeFolder(ExcludeFolder f) {
        Disposer.register(this, (Disposable)((Object)f));
        this.myExcludeFolders.add(f);
        return f;
    }

    private <T extends ContentFolder> void assertCanRemoveFrom(T f, @NotNull Set<T> ff) {
        if (ff == null) {
            ContentEntryImpl.$$$reportNull$$$0(54);
        }
        this.getRootModel().assertWritable();
        LOG.assertTrue(ff.contains(f));
    }

    private void assertFolderUnderMe(@NotNull String url) {
        if (url == null) {
            ContentEntryImpl.$$$reportNull$$$0(55);
        }
        String path = VfsUtilCore.urlToPath(url);
        String rootPath = VfsUtilCore.urlToPath(this.getUrl());
        if (!FileUtil.isAncestor(rootPath, path, false)) {
            LOG.error("The file '" + path + "' is not under content entry root '" + rootPath + "'");
        }
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    @NotNull
    public ContentEntry cloneEntry(@NotNull RootModelImpl rootModel) {
        ContentFolder folder;
        if (rootModel == null) {
            ContentEntryImpl.$$$reportNull$$$0(56);
        }
        assert (!this.isDisposed());
        ContentEntryImpl cloned = new ContentEntryImpl(this.myRoot.getUrl(), rootModel);
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)((Object)sourceFolder)).cloneFolder(cloned);
            cloned.addSourceFolder((SourceFolderImpl)folder);
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)((Object)excludeFolder)).cloneFolder(cloned);
            cloned.addExcludeFolder((ExcludeFolder)folder);
        }
        for (String pattern : this.getExcludePatterns()) {
            cloned.addExcludePattern(pattern);
        }
        ContentEntryImpl contentEntryImpl = cloned;
        if (contentEntryImpl == null) {
            ContentEntryImpl.$$$reportNull$$$0(57);
        }
        return contentEntryImpl;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ContentEntryImpl.$$$reportNull$$$0(58);
        }
        assert (!this.isDisposed());
        LOG.assertTrue(ELEMENT_NAME.equals(element.getName()));
        element.setAttribute(URL_ATTRIBUTE, this.myRoot.getUrl());
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof SourceFolderImpl)) continue;
            JpsModuleRootModelSerializer.saveSourceRoot(element, sourceFolder.getUrl(), sourceFolder.getJpsElement().asTyped());
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ExcludeFolderImpl)) continue;
            Element subElement = new Element("excludeFolder");
            ((ExcludeFolderImpl)excludeFolder).writeExternal(subElement);
            element.addContent(subElement);
        }
        for (String pattern : this.getExcludePatterns()) {
            element.addContent(new Element("excludePattern").setAttribute("pattern", pattern));
        }
    }

    @Override
    public int compareTo(@NotNull ContentEntryImpl other) {
        int i;
        if (other == null) {
            ContentEntryImpl.$$$reportNull$$$0(59);
        }
        if ((i = this.getUrl().compareTo(other.getUrl())) != 0) {
            return i;
        }
        i = ArrayUtil.lexicographicCompare(this.getSourceFolders(), other.getSourceFolders());
        if (i != 0) {
            return i;
        }
        i = ArrayUtil.lexicographicCompare(this.getExcludeFolders(), other.getExcludeFolders());
        if (i != 0) {
            return i;
        }
        return ContainerUtil.compareLexicographically(this.getExcludePatterns(), other.getExcludePatterns());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 42: 
            case 50: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 42: 
            case 50: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 2: 
            case 32: 
            case 34: 
            case 37: 
            case 45: 
            case 47: 
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTRIBUTE;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 42: 
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ContentEntryImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 26: 
            case 30: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeFolder";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ff";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ContentEntryImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolderFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolders";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolderUrls";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolderFiles";
                break;
            }
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceFolder";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludePatterns";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadExcludePatterns";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUrlFrom";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadSourceFolders";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadExcludeFolders";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 42: 
            case 50: 
            case 57: {
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolders";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFolder";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addExcludeFolder";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "assertCanAddFolder";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludeFolder";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addExcludePattern";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludePattern";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setExcludePatterns";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "assertCanRemoveFrom";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assertFolderUnderMe";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "cloneEntry";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 42: 
            case 50: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ContentFolderComparator
    implements Comparator<ContentFolder> {
        public static final ContentFolderComparator INSTANCE = new ContentFolderComparator();

        private ContentFolderComparator() {
        }

        @Override
        public int compare(@NotNull ContentFolder o1, @NotNull ContentFolder o2) {
            if (o1 == null) {
                ContentFolderComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                ContentFolderComparator.$$$reportNull$$$0(1);
            }
            return o1.getUrl().compareTo(o2.getUrl());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/impl/ContentEntryImpl$ContentFolderComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

