/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiDirectoryImpl
extends PsiElementBase
implements PsiDirectory,
Queryable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.PsiDirectoryImpl");
    private final PsiManagerImpl myManager;
    private final VirtualFile myFile;

    public PsiDirectoryImpl(PsiManagerImpl manager, @NotNull VirtualFile file) {
        if (file == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
        this.myFile = file;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && !this.getProject().isDisposed();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(2);
        }
        return language;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(4);
        }
        this.checkSetName(name);
        try {
            this.myFile.rename(this.myManager, name);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        PsiDirectoryImpl psiDirectoryImpl = this;
        if (psiDirectoryImpl == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(5);
        }
        return psiDirectoryImpl;
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            throw new IncorrectOperationException(VfsBundle.message("cannot.rename.root.directory", this.myFile.getPath()));
        }
        VirtualFile child = parentFile.findChild(name);
        if (child != null && !child.equals(this.myFile)) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", child.getPresentableUrl()));
        }
    }

    @Override
    public PsiDirectory getParentDirectory() {
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of dir " + this.myFile + ", dir.valid=" + this.myFile.isValid());
            return null;
        }
        return this.myManager.findDirectory(parentFile);
    }

    @Override
    @NotNull
    public PsiDirectory[] getSubdirectories() {
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile file : files) {
            PsiDirectory dir = this.myManager.findDirectory(file);
            if (dir == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
        if (psiDirectoryArray == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(6);
        }
        return psiDirectoryArray;
    }

    @Override
    @NotNull
    public PsiFile[] getFiles() {
        if (!this.myFile.isValid()) {
            throw new InvalidVirtualFileAccessException(this.myFile);
        }
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile = this.myManager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(psiFiles);
        if (psiFileArray == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(7);
        }
        return psiFileArray;
    }

    @Override
    public PsiDirectory findSubdirectory(@NotNull String name) {
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        return this.myManager.findDirectory(childVFile);
    }

    @Override
    public PsiFile findFile(@NotNull String name) {
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        if (!childVFile.isValid()) {
            LOG.error("Invalid file: " + childVFile + " in dir " + this.myFile + ", dir.valid=" + this.myFile.isValid());
            return null;
        }
        return this.myManager.findFile(childVFile);
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        this.checkValid();
        for (VirtualFile vFile : this.myFile.getChildren()) {
            PsiFileSystemItem item;
            ProgressManager.checkCanceled();
            boolean isDir = vFile.isDirectory();
            if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(vFile.getName(), isDir)) continue;
            PsiFileSystemItem psiFileSystemItem = item = isDir ? this.myManager.findDirectory(vFile) : this.myManager.findFile(vFile);
            if (item == null || processor.execute(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        this.checkValid();
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList children = new ArrayList(files.length);
        this.processChildren(element -> {
            children.add(element);
            return true;
        });
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(children);
        if (psiElementArray == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(10);
        }
        return psiElementArray;
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
    }

    @Override
    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(11);
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        if (text2 == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    public final boolean isWritable() {
        return this.myFile.isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !(this.myFile.getFileSystem() instanceof NonPhysicalFileSystem) && !this.myFile.getFileSystem().getProtocol().equals("temp");
    }

    @Override
    public PsiElement copy() {
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public PsiDirectory createSubdirectory(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory psiDirectory;
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(14);
        }
        this.checkCreateSubdirectory(name);
        try {
            VirtualFile file = this.getVirtualFile().createChildDirectory(this.myManager, name);
            PsiDirectory directory = this.myManager.findDirectory(file);
            if (directory == null) {
                throw new IncorrectOperationException("Cannot find directory in '" + file.getPresentableUrl() + "'");
            }
            psiDirectory = directory;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiDirectory == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(15);
        }
        return psiDirectory;
    }

    @Override
    public void checkCreateSubdirectory(@NotNull String name) throws IncorrectOperationException {
        VirtualFile existingFile;
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(16);
        }
        if ((existingFile = this.getVirtualFile().findChild(name)) != null) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", existingFile.getPresentableUrl()));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull String name) throws IncorrectOperationException {
        PsiFile psiFile;
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(17);
        }
        this.checkCreateFile(name);
        try {
            VirtualFile vFile = this.getVirtualFile().createChildData(this.myManager, name);
            PsiFile psiFile2 = this.myManager.findFile(vFile);
            assert (psiFile2 != null) : vFile.getPath();
            psiFile = psiFile2;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiFile == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(18);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PsiFile copyFileFrom(@NotNull String newName, @NotNull PsiFile originalFile) throws IncorrectOperationException {
        PsiFile psiFile;
        if (newName == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(19);
        }
        if (originalFile == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(20);
        }
        this.checkCreateFile(newName);
        Document document = PsiDocumentManager.getInstance(this.getProject()).getDocument(originalFile);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        VirtualFile parent = this.getVirtualFile();
        try {
            VirtualFile copyVFile;
            VirtualFile vFile = originalFile.getVirtualFile();
            if (vFile == null) {
                throw new IncorrectOperationException("Cannot copy non-physical file: " + originalFile);
            }
            if (parent.getFileSystem() == vFile.getFileSystem()) {
                copyVFile = vFile.copy(this, parent, newName);
            } else if (vFile instanceof LightVirtualFile) {
                copyVFile = parent.createChildData(this, newName);
                copyVFile.setBinaryContent(originalFile.getText().getBytes(copyVFile.getCharset()));
            } else {
                copyVFile = VfsUtilCore.copyFile(this, vFile, parent, newName);
            }
            DumbService.getInstance(this.getProject()).completeJustSubmittedTasks();
            PsiFile copyPsi = this.myManager.findFile(copyVFile);
            if (copyPsi == null) {
                throw new IncorrectOperationException("Could not find file " + copyVFile + " after copying " + vFile);
            }
            PsiDirectoryImpl.updateAddedFile(copyPsi);
            psiFile = copyPsi;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
        if (psiFile == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(21);
        }
        return psiFile;
    }

    private static void updateAddedFile(@NotNull PsiFile copyPsi) throws IncorrectOperationException {
        UpdateAddedFileProcessor processor;
        if (copyPsi == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(22);
        }
        if ((processor = UpdateAddedFileProcessor.forElement(copyPsi)) != null) {
            TreeElement tree = (TreeElement)SourceTreeToPsiMap.psiElementToTree(copyPsi);
            if (tree != null) {
                ChangeUtil.encodeInformation(tree);
            }
            processor.update(copyPsi, null);
            if (tree != null) {
                ChangeUtil.decodeInformation(tree);
            }
        }
    }

    @Override
    public void checkCreateFile(@NotNull String name) throws IncorrectOperationException {
        VirtualFile existingFile;
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(23);
        }
        if ((existingFile = this.getVirtualFile().findChild(name)) != null) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", existingFile.getPresentableUrl()));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(24);
        }
        this.checkAdd(element);
        if (element instanceof PsiFile) {
            PsiFile originalFile = (PsiFile)element;
            try {
                VirtualFile newVFile;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(this.myManager.getProject());
                if (originalFile instanceof PsiFileImpl) {
                    newVFile = this.myFile.createChildData(this.myManager, originalFile.getName());
                    String text2 = originalFile.getText();
                    PsiFile psiFile = this.getManager().findFile(newVFile);
                    Document document = psiFile == null ? null : psiDocumentManager.getDocument(psiFile);
                    FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                    if (document != null) {
                        document.setText(text2);
                        fileDocumentManager.saveDocument(document);
                    } else {
                        String lineSeparator = fileDocumentManager.getLineSeparator(newVFile, this.getProject());
                        if (!lineSeparator.equals("\n")) {
                            text2 = StringUtil.convertLineSeparators(text2, lineSeparator);
                        }
                        LoadTextUtil.write(this.getProject(), newVFile, this.myManager, text2, -1L);
                    }
                } else {
                    byte[] storedContents = ((PsiBinaryFileImpl)originalFile).getStoredContents();
                    if (storedContents != null) {
                        newVFile = this.myFile.createChildData(this.myManager, originalFile.getName());
                        newVFile.setBinaryContent(storedContents);
                    } else {
                        newVFile = VfsUtilCore.copyFile(null, originalFile.getVirtualFile(), this.myFile);
                    }
                }
                psiDocumentManager.commitAllDocuments();
                PsiFile newFile = this.myManager.findFile(newVFile);
                if (newFile == null) {
                    throw new IncorrectOperationException("Could not find file " + newVFile);
                }
                PsiDirectoryImpl.updateAddedFile(newFile);
                return newFile;
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e);
            }
        }
        throw new IncorrectOperationException(element + " (" + element.getClass() + ")");
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(25);
        }
        CheckUtil.checkWritable(this);
        if (element instanceof PsiDirectory) {
            String name = ((PsiDirectory)element).getName();
            this.checkName(name, this.getSubdirectories(), "dir.already.exists.error");
        } else if (element instanceof PsiFile) {
            String name = ((PsiFile)element).getName();
            this.checkName(name, this.getFiles(), "file.already.exists.error");
        } else {
            throw new IncorrectOperationException(element.getClass().getName());
        }
    }

    private void checkName(String name, PsiFileSystemItem[] items, String key) {
        boolean caseSensitive = this.getVirtualFile().getFileSystem().isCaseSensitive();
        for (PsiFileSystemItem item : items) {
            if (!Comparing.strEqual(item.getName(), name, caseSensitive)) continue;
            throw new IncorrectOperationException(VfsBundle.message(key, item.getVirtualFile().getPresentableUrl()));
        }
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(26);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(27);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        try {
            this.myFile.delete(this.myManager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkDelete(this.myFile);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(28);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(29);
        }
        visitor.visitDirectory(this);
    }

    @Override
    public String toString() {
        return "PsiDirectory:" + this.myFile.getPresentableUrl();
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().navigateToDirectory(this, requestFocus);
    }

    @Override
    protected Icon getElementIcon(int flags) {
        return PlatformIcons.DIRECTORY_CLOSED_ICON;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(30);
        }
        info.put("fileName", this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiDirectoryImpl directory = (PsiDirectoryImpl)o;
        if (!this.myManager.equals(directory.myManager)) {
            return false;
        }
        return this.myFile.equals(directory.myFile);
    }

    public int hashCode() {
        int result2 = this.myManager.hashCode();
        result2 = 31 * result2 + this.myFile.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/PsiDirectoryImpl";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyPsi";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/PsiDirectoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubdirectories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubdirectory";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSubdirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSubdirectory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkCreateSubdirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyFileFrom";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateAddedFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkCreateFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

