/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    @Nullable
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(@Nullable Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public abstract int compare(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            GlobalSearchScope.$$$reportNull$$$0(0);
        }
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(VirtualFile file) {
        return this.contains(file);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    public boolean isSearchOutsideRootModel() {
        return false;
    }

    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return Collections.emptySet();
    }

    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(1);
        }
        if (scope == this) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        if (scope instanceof IntersectionScope && ((IntersectionScope)scope).containsScope(this)) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        IntersectionScope intersectionScope = new IntersectionScope(this, scope, null);
        if (intersectionScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(4);
        }
        return intersectionScope;
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(5);
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localScope2 = (LocalSearchScope)scope2;
            SearchScope searchScope = this.intersectWith(localScope2);
            if (searchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(6);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = this.intersectWith((GlobalSearchScope)scope2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        if (localScope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(8);
        }
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result2.add(element2);
        }
        SearchScope searchScope = result2.isEmpty() ? EMPTY_SCOPE : new LocalSearchScope(result2.toArray(new PsiElement[result2.size()]), null, localScope2.isIgnoreInjectedPsi());
        if (searchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(9);
        }
        return searchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(10);
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = this.uniteWith((GlobalSearchScope)scope);
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.union((LocalSearchScope)scope);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope union(final @NotNull LocalSearchScope scope) {
        PsiElement[] localScopeElements;
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(13);
        }
        if ((localScopeElements = scope.getScope()).length == 0) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(14);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = new GlobalSearchScope(localScopeElements[0].getProject()){

            @Override
            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return GlobalSearchScope.this.contains(file) || scope.isInScope(file);
            }

            @Override
            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(3);
                }
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchOutsideRootModel() {
                return GlobalSearchScope.this.isSearchOutsideRootModel();
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            @Override
            public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
                return GlobalSearchScope.this.getUnloadedModulesBelongingToScope();
            }

            @NonNls
            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this + ", " + scope + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compare";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(16);
        }
        if (scope == this) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(17);
            }
            return globalSearchScope;
        }
        UnionScope unionScope = new UnionScope(this, scope);
        if (unionScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(18);
        }
        return unionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(@NotNull GlobalSearchScope[] scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(19);
        }
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            GlobalSearchScope globalSearchScope = scopes[0];
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(20);
            }
            return globalSearchScope;
        }
        UnionScope unionScope = new UnionScope(scopes);
        if (unionScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(21);
        }
        return unionScope;
    }

    @NotNull
    public static GlobalSearchScope allScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(22);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(23);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope projectScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(24);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(25);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope everythingScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(26);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getEverythingScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(28);
        }
        NotScope notScope = new NotScope(scope);
        if (notScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(29);
        }
        return notScope;
    }

    @NotNull
    public static GlobalSearchScope moduleScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(30);
        }
        GlobalSearchScope globalSearchScope = module.getModuleScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(31);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(32);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(33);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(34);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(35);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(36);
        }
        GlobalSearchScope globalSearchScope = module.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(37);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(38);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, true);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(39);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(40);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(41);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(42);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(43);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(44);
        }
        GlobalSearchScope globalSearchScope = module.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(45);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GlobalSearchScope.$$$reportNull$$$0(46);
        }
        FileScope fileScope = new FileScope(psiFile.getProject(), psiFile.getVirtualFile());
        if (fileScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(47);
        }
        return fileScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, VirtualFile virtualFile) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(48);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(project, virtualFile, null);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(49);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile, final @Nullable String displayName) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(50);
        }
        FileScope fileScope = new FileScope(project, virtualFile){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = displayName == null ? super.getDisplayName() : displayName;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$2", "getDisplayName"));
            }
        };
        if (fileScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(51);
        }
        return fileScope;
    }

    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(52);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(53);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, files, null);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(54);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope filesWithoutLibrariesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(55);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(56);
        }
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(57);
            }
            return globalSearchScope;
        }
        FilesScope filesScope = new FilesScope(project, files, false, false);
        if (filesScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(58);
        }
        return filesScope;
    }

    @NotNull
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(59);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(60);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope(project, files, false);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(61);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files, boolean searchOutsideRootModel) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(62);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(63);
        }
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(64);
            }
            return globalSearchScope;
        }
        FilesScope filesScope = new FilesScope(project, files, true, searchOutsideRootModel);
        if (filesScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(65);
        }
        return filesScope;
    }

    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files, final @Nullable String displayName) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(66);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(67);
        }
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(68);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = files.size() == 1 ? GlobalSearchScope.fileScope(project, files.iterator().next(), displayName) : new FilesScope(project, files){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = displayName == null ? super.getDisplayName() : displayName;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$3", "getDisplayName"));
            }
        };
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(69);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(70);
        }
        if (fileTypes == null) {
            GlobalSearchScope.$$$reportNull$$$0(71);
        }
        if (scope == EMPTY_SCOPE) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(72);
            }
            return globalSearchScope;
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        FileTypeRestrictionScope fileTypeRestrictionScope = new FileTypeRestrictionScope(scope, fileTypes);
        if (fileTypeRestrictionScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(73);
        }
        return fileTypeRestrictionScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 72: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 72: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 16: 
            case 28: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localScope2";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 53: 
            case 56: 
            case 60: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "allScope";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "projectScope";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "everythingScope";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "notScope";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleScope";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithLibrariesScope";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesScope";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleRuntimeScope";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependentsScope";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleTestsWithDependentsScope";
                break;
            }
            case 47: 
            case 49: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "fileScope";
                break;
            }
            case 54: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "filesScope";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithoutLibrariesScope";
                break;
            }
            case 61: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithLibrariesScope";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 72: 
            case 73: {
                break;
            }
            case 10: 
            case 13: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "allScope";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "projectScope";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "everythingScope";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "notScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "moduleScope";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithLibrariesScope";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesScope";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "moduleRuntimeScope";
                break;
            }
            case 38: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependentsScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "moduleTestsWithDependentsScope";
                break;
            }
            case 46: 
            case 48: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fileScope";
                break;
            }
            case 52: 
            case 53: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "filesScope";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "filesWithoutLibrariesScope";
                break;
            }
            case 59: 
            case 60: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "filesWithLibrariesScope";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 72: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FilesScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final Collection<VirtualFile> myFiles;
        private final boolean mySearchOutsideRootModel;
        private volatile Boolean myHasFilesOutOfProjectRoots;

        public FilesScope(@Nullable Project project, @NotNull Collection<VirtualFile> files) {
            if (files == null) {
                FilesScope.$$$reportNull$$$0(0);
            }
            this(project, files, null, false);
        }

        private FilesScope(@Nullable Project project, @NotNull Collection<VirtualFile> files, @Nullable Boolean hasFilesOutOfProjectRoots, boolean searchOutsideRootModel) {
            if (files == null) {
                FilesScope.$$$reportNull$$$0(1);
            }
            super(project);
            this.myFiles = files;
            this.mySearchOutsideRootModel = searchOutsideRootModel;
            this.myHasFilesOutOfProjectRoots = hasFilesOutOfProjectRoots;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                FilesScope.$$$reportNull$$$0(2);
            }
            return this.myFiles.contains(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                FilesScope.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                FilesScope.$$$reportNull$$$0(4);
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FilesScope.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.hasFilesOutOfProjectRoots();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof FilesScope && this.myFiles.equals(((FilesScope)o).myFiles);
        }

        @Override
        public int hashCode() {
            return this.myFiles.hashCode();
        }

        private boolean hasFilesOutOfProjectRoots() {
            Boolean result2 = this.myHasFilesOutOfProjectRoots;
            if (result2 == null) {
                Project project = this.getProject();
                this.myHasFilesOutOfProjectRoots = result2 = Boolean.valueOf(project != null && !project.isDefault() && this.myFiles.stream().anyMatch(file -> FileIndexFacade.getInstance(project).getModuleForFile((VirtualFile)file) == null));
            }
            return result2;
        }

        public String toString() {
            ArrayList<VirtualFile> files = this.myFiles.size() <= 20 ? new ArrayList<VirtualFile>(this.myFiles) : new ArrayList<VirtualFile>(this.myFiles).subList(0, 20);
            return "Files: (" + files + "); search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            Iterator<VirtualFile> iterator = this.myFiles.iterator();
            if (iterator == null) {
                FilesScope.$$$reportNull$$$0(6);
            }
            return iterator;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.mySearchOutsideRootModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FileScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final VirtualFile myVirtualFile;
        private final Module myModule;
        private final boolean mySearchOutsideContent;

        private FileScope(@NotNull Project project, @Nullable VirtualFile virtualFile) {
            if (project == null) {
                FileScope.$$$reportNull$$$0(0);
            }
            super(project);
            this.myVirtualFile = virtualFile;
            FileIndexFacade facade = FileIndexFacade.getInstance(project);
            this.myModule = virtualFile == null || project.isDefault() ? null : facade.getModuleForFile(virtualFile);
            this.mySearchOutsideContent = virtualFile != null && this.myModule == null && !facade.isInLibraryClasses(virtualFile) && !facade.isInLibrarySource(virtualFile);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                FileScope.$$$reportNull$$$0(1);
            }
            return Comparing.equal(this.myVirtualFile, file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                FileScope.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                FileScope.$$$reportNull$$$0(3);
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FileScope.$$$reportNull$$$0(4);
            }
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }

        public String toString() {
            return "File :" + this.myVirtualFile;
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            Iterator<VirtualFile> iterator = Collections.singletonList(this.myVirtualFile).iterator();
            if (iterator == null) {
                FileScope.$$$reportNull$$$0(5);
            }
            return iterator;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.mySearchOutsideContent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$FileScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$FileScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                EmptyScope.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                EmptyScope.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                EmptyScope.$$$reportNull$$$0(2);
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                EmptyScope.$$$reportNull$$$0(3);
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                EmptyScope.$$$reportNull$$$0(4);
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                EmptyScope.$$$reportNull$$$0(5);
            }
            return emptyScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                EmptyScope.$$$reportNull$$$0(6);
            }
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                EmptyScope.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }

        public String toString() {
            return "EMPTY";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, @NotNull FileType[] fileTypes) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(0);
            }
            if (fileTypes == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(1);
            }
            super(scope);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(2);
            }
            if (!super.contains(file)) {
                return false;
            }
            FileType fileType = file.getFileType();
            for (FileType otherFileType : this.myFileTypes) {
                if (!fileType.equals(otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(3);
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    FileTypeRestrictionScope fileTypeRestrictionScope = new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(new FileType[intersection.size()]));
                    if (fileTypeRestrictionScope == null) {
                        FileTypeRestrictionScope.$$$reportNull$$$0(4);
                    }
                    return fileTypeRestrictionScope;
                }
            }
            GlobalSearchScope globalSearchScope = super.intersectWith(scope);
            if (globalSearchScope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(6);
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    FileTypeRestrictionScope fileTypeRestrictionScope = new FileTypeRestrictionScope(this.myBaseScope, ArrayUtil.mergeArrays(this.myFileTypes, restrict.myFileTypes));
                    if (fileTypeRestrictionScope == null) {
                        FileTypeRestrictionScope.$$$reportNull$$$0(7);
                    }
                    return fileTypeRestrictionScope;
                }
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.myFileTypes);
            return result2;
        }

        @Override
        public String toString() {
            return "(restricted by file types: " + Arrays.asList(this.myFileTypes) + " in " + this.myBaseScope + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope[] myScopes;
        private final int myNestingLevel;

        private UnionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2) {
            if (scope1 == null) {
                UnionScope.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                UnionScope.$$$reportNull$$$0(1);
            }
            this(new GlobalSearchScope[]{scope1, scope2});
        }

        private UnionScope(@NotNull GlobalSearchScope[] scopes) {
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(2);
            }
            super(ContainerUtil.getFirstItem(ContainerUtil.mapNotNull(scopes, GlobalSearchScope::getProject), null));
            if (scopes.length <= 1) {
                throw new IllegalArgumentException("Too few scopes: " + Arrays.asList(scopes));
            }
            this.myScopes = scopes;
            final int[] nested = new int[]{0};
            ContainerUtil.process(scopes, new Processor<GlobalSearchScope>(){

                @Override
                public boolean process(GlobalSearchScope scope) {
                    nested[0] = Math.max(nested[0], scope instanceof UnionScope ? ((UnionScope)scope).myNestingLevel : 0);
                    return true;
                }
            });
            this.myNestingLevel = 1 + nested[0];
            if (this.myNestingLevel > 1000) {
                throw new IllegalStateException("Too many scopes combined: " + this.myNestingLevel + StringUtil.last(this.toString(), 500, true));
            }
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = PsiBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
            if (string == null) {
                UnionScope.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                UnionScope.$$$reportNull$$$0(4);
            }
            return ContainerUtil.find(this.myScopes, scope -> {
                if (file == null) {
                    UnionScope.$$$reportNull$$$0(16);
                }
                return scope.contains(file);
            }) != null;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return ContainerUtil.find(this.myScopes, GlobalSearchScope::isSearchOutsideRootModel) != null;
        }

        @Override
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            LinkedHashSet<UnloadedModuleDescription> result2 = new LinkedHashSet<UnloadedModuleDescription>();
            for (GlobalSearchScope scope : this.myScopes) {
                result2.addAll(scope.getUnloadedModulesBelongingToScope());
            }
            return result2;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                UnionScope.$$$reportNull$$$0(5);
            }
            if (file2 == null) {
                UnionScope.$$$reportNull$$$0(6);
            }
            int[] result2 = new int[]{0};
            ContainerUtil.process(this.myScopes, scope -> {
                int res1;
                if (file1 == null) {
                    UnionScope.$$$reportNull$$$0(14);
                }
                if (file2 == null) {
                    UnionScope.$$$reportNull$$$0(15);
                }
                int n = res1 = scope.contains(file1) && scope.contains(file2) ? scope.compare(file1, file2) : 0;
                if (result2[0] == 0) {
                    result2[0] = res1;
                    return true;
                }
                if (result2[0] > 0 != res1 > 0) {
                    result2[0] = 0;
                    return false;
                }
                return true;
            });
            return result2[0];
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module) {
            if (module == null) {
                UnionScope.$$$reportNull$$$0(7);
            }
            return ContainerUtil.find(this.myScopes, scope -> {
                if (module == null) {
                    UnionScope.$$$reportNull$$$0(13);
                }
                return scope.isSearchInModuleContent(module);
            }) != null;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module, boolean testSources) {
            if (module == null) {
                UnionScope.$$$reportNull$$$0(8);
            }
            return ContainerUtil.find(this.myScopes, scope -> {
                if (module == null) {
                    UnionScope.$$$reportNull$$$0(12);
                }
                return scope.isSearchInModuleContent(module, testSources);
            }) != null;
        }

        @Override
        public boolean isSearchInLibraries() {
            return ContainerUtil.find(this.myScopes, GlobalSearchScope::isSearchInLibraries) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o;
            return new HashSet<GlobalSearchScope>(Arrays.asList(this.myScopes)).equals(new HashSet<GlobalSearchScope>(Arrays.asList(that.myScopes)));
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.myScopes);
        }

        @NonNls
        public String toString() {
            return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), ",") + ")";
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                UnionScope.$$$reportNull$$$0(9);
            }
            if (scope instanceof UnionScope) {
                GlobalSearchScope[] newScopes = ArrayUtil.mergeArrays(this.myScopes, ((UnionScope)scope).myScopes);
                UnionScope unionScope = new UnionScope(newScopes);
                if (unionScope == null) {
                    UnionScope.$$$reportNull$$$0(10);
                }
                return unionScope;
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                UnionScope.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopes";
                    break;
                }
                case 3: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$UnionScope";
                    break;
                }
                case 4: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 6: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 7: 
                case 8: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$UnionScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 10: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$isSearchInModuleContent$3";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$isSearchInModuleContent$2";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$compare$1";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$contains$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        private IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            if (scope1 == null) {
                IntersectionScope.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                IntersectionScope.$$$reportNull$$$0(1);
            }
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                IntersectionScope.$$$reportNull$$$0(2);
            }
            IntersectionScope intersectionScope = this.containsScope(scope) ? this : new IntersectionScope(this, scope, null);
            if (intersectionScope == null) {
                IntersectionScope.$$$reportNull$$$0(3);
            }
            return intersectionScope;
        }

        private boolean containsScope(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                IntersectionScope.$$$reportNull$$$0(4);
            }
            if (this.myScope1.equals(scope) || this.myScope2.equals(scope) || this.equals(scope)) {
                return true;
            }
            if (this.myScope1 instanceof IntersectionScope && ((IntersectionScope)this.myScope1).containsScope(scope)) {
                return true;
            }
            return this.myScope2 instanceof IntersectionScope && ((IntersectionScope)this.myScope2).containsScope(scope);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                String string = PsiBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
                if (string == null) {
                    IntersectionScope.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = this.myDisplayName;
            if (string == null) {
                IntersectionScope.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                IntersectionScope.$$$reportNull$$$0(7);
            }
            return this.myScope1.contains(file) && this.myScope2.contains(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                IntersectionScope.$$$reportNull$$$0(8);
            }
            if (file2 == null) {
                IntersectionScope.$$$reportNull$$$0(9);
            }
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                IntersectionScope.$$$reportNull$$$0(10);
            }
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                IntersectionScope.$$$reportNull$$$0(11);
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.myScope1.isSearchOutsideRootModel() && this.myScope2.isSearchOutsideRootModel();
        }

        @Override
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return ContainerUtil.intersection(this.myScope1.getUnloadedModulesBelongingToScope(), this.myScope2.getUnloadedModulesBelongingToScope());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int hashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope2";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$IntersectionScope";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$IntersectionScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "containsScope";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NotScope
    extends DelegatingGlobalSearchScope {
        private NotScope(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                NotScope.$$$reportNull$$$0(0);
            }
            super(scope);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                NotScope.$$$reportNull$$$0(1);
            }
            return !this.myBaseScope.contains(file);
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                NotScope.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                NotScope.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return true;
        }

        @Override
        public String toString() {
            return "NOT: " + this.myBaseScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$NotScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

