/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = new Comparator<MessageBusImpl>(){

        @Override
        public int compare(MessageBusImpl bus1, MessageBusImpl bus2) {
            return ContainerUtil.compareLexicographically((List)bus1.myOrderRef.get(), (List)bus2.myOrderRef.get());
        }
    };
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue;
    private final AtomicReference<List<Integer>> myOrderRef;
    private final ConcurrentMap<Topic, Object> mySyncPublishers;
    private final ConcurrentMap<Topic, Object> myAsyncPublishers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscriberCache;
    private final Deque<MessageBusImpl> myChildBuses;
    private final ConcurrentMap<List<Integer>, Boolean> myChildOrders;
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final String myOwner;
    private boolean myDisposed;
    private final Disposable myConnectionDisposable;

    public MessageBusImpl(@NotNull Object owner, @NotNull MessageBus parentBus) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(0);
        }
        if (parentBus == null) {
            MessageBusImpl.$$$reportNull$$$0(1);
        }
        this(owner);
        this.myParentBus = (MessageBusImpl)parentBus;
        this.myParentBus.onChildBusCreated(this);
        LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
        LOG.assertTrue(this.myOrderRef.get() != null);
    }

    private MessageBusImpl(Object owner) {
        this.myMessageQueue = MessageBusImpl.createThreadLocalQueue();
        this.myOrderRef = new AtomicReference(Collections.emptyList());
        this.mySyncPublishers = ContainerUtil.newConcurrentMap();
        this.myAsyncPublishers = ContainerUtil.newConcurrentMap();
        this.mySubscribers = ContainerUtil.newConcurrentMap();
        this.mySubscriberCache = ContainerUtil.newConcurrentMap();
        this.myChildBuses = new LinkedBlockingDeque<MessageBusImpl>();
        this.myChildOrders = ContainerUtil.newConcurrentMap();
        this.myOwner = owner + " of " + owner.getClass();
        this.myConnectionDisposable = Disposer.newDisposable(this.myOwner);
    }

    @Override
    public MessageBus getParent() {
        return this.myParentBus;
    }

    @NotNull
    private RootBus getRootBus() {
        RootBus rootBus = this.myParentBus != null ? this.myParentBus.getRootBus() : this.asRoot();
        if (rootBus == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        return rootBus;
    }

    private MessageBusImpl rootBus() {
        return this.getRootBus();
    }

    private RootBus asRoot() {
        if (this instanceof RootBus) {
            return (RootBus)this;
        }
        throw new AssertionError((Object)("Accessing disposed message bus " + this));
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    private void onChildBusCreated(MessageBusImpl childBus) {
        LOG.assertTrue(childBus.myParentBus == this);
        ArrayList<Integer> childOrder = new ArrayList<Integer>(this.myOrderRef.get().size() + 1);
        childOrder.addAll((Collection)this.myOrderRef.get());
        childOrder.add(1);
        do {
            int lastChildIndex;
            MessageBusImpl lastChild;
            if ((lastChild = this.myChildBuses.peekLast()) == null) {
                lastChildIndex = 0;
            } else {
                List<Integer> lastChildOrder = lastChild.myOrderRef.get();
                lastChildIndex = lastChildOrder.get(lastChildOrder.size() - 1);
            }
            if (lastChildIndex == Integer.MAX_VALUE) {
                LOG.error("Too many child buses");
            }
            childOrder.set(childOrder.size() - 1, lastChildIndex + 1);
        } while (this.myChildOrders.putIfAbsent(childOrder, Boolean.TRUE) != null);
        childBus.myOrderRef.set(childOrder);
        this.myChildBuses.add(childBus);
        this.rootBus().clearSubscriberCache();
    }

    private void onChildBusDisposed(MessageBusImpl childBus) {
        boolean removed = this.myChildBuses.remove(childBus);
        this.myChildOrders.remove(childBus.myOrderRef.get());
        Map map = (Map)this.getRootBus().myWaitingBuses.get();
        if (map != null) {
            map.remove(childBus);
        }
        this.rootBus().clearSubscriberCache();
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        MessageBusConnection messageBusConnection = this.connect(this.myConnectionDisposable);
        if (messageBusConnection == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        return messageBusConnection;
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        this.checkNotDisposed();
        Object publisher = this.mySyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.mySyncPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        return (L)v;
    }

    @Override
    @NotNull
    public <L> L asyncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        this.checkNotDisposed();
        Object publisher = this.myAsyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.postMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.myAsyncPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        return (L)v;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        this.myDisposed = true;
        for (MessageBusImpl childBus : this.myChildBuses) {
            Disposer.dispose(childBus);
        }
        Disposer.dispose(this.myConnectionDisposable);
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.asRoot().myWaitingBuses.remove();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        if (!this.isDispatchingAnything()) {
            return false;
        }
        for (MessageBusConnectionImpl connection : this.getTopicSubscribers(topic)) {
            if (!connection.containsMessage(topic)) continue;
            return true;
        }
        return false;
    }

    private boolean isDispatchingAnything() {
        SortedMap waitingBuses = (SortedMap)this.getRootBus().myWaitingBuses.get();
        return waitingBuses != null && !waitingBuses.isEmpty();
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(Topic topic, List<MessageBusConnectionImpl> result2) {
        Topic.BroadcastDirection direction;
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            result2.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result2);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result2);
        }
    }

    private void postMessage(Message message) {
        this.checkNotDisposed();
        List<MessageBusConnectionImpl> topicSubscribers = this.getTopicSubscribers(message.getTopic());
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message);
            }
        }
    }

    @NotNull
    private List<MessageBusConnectionImpl> getTopicSubscribers(Topic topic) {
        SmartList<MessageBusConnectionImpl> topicSubscribers = (SmartList<MessageBusConnectionImpl>)this.mySubscriberCache.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = new SmartList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
        }
        SmartList<MessageBusConnectionImpl> smartList = topicSubscribers;
        if (smartList == null) {
            MessageBusImpl.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count;
        int newCount;
        ThreadLocal ref = this.getRootBus().myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map == null) {
            map = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map);
        }
        if ((newCount = (count = (countObject = (Integer)map.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map.put(this, newCount);
        } else if (newCount == 0) {
            map.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(Message message) {
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            List<MessageBusImpl> buses;
            final Map map = (Map)this.asRoot().myWaitingBuses.get();
            if (map != null && !(buses = ContainerUtil.filter(map.keySet(), new Condition<MessageBusImpl>(){

                @Override
                public boolean value(MessageBusImpl bus) {
                    return MessageBusImpl.ensureAlive(map, bus);
                }
            })).isEmpty()) {
                MessageBusImpl.pumpWaitingBuses(buses);
            }
        }
    }

    private static void pumpWaitingBuses(List<MessageBusImpl> buses) {
        List<Throwable> exceptions = null;
        for (MessageBusImpl bus : buses) {
            if (bus.myDisposed) continue;
            exceptions = MessageBusImpl.appendExceptions(exceptions, bus.doPumpMessages());
        }
        MessageBusImpl.rethrowExceptions(exceptions);
    }

    private static List<Throwable> appendExceptions(List<Throwable> exceptions, List<Throwable> busExceptions) {
        if (!busExceptions.isEmpty()) {
            if (exceptions == null) {
                exceptions = new SmartList<Throwable>();
            }
            exceptions.addAll(busExceptions);
        }
        return exceptions;
    }

    private static void rethrowExceptions(List<Throwable> exceptions) {
        if (exceptions == null) {
            return;
        }
        ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
        if (pce != null) {
            throw pce;
        }
        CompoundRuntimeException.throwIfNotEmpty(exceptions);
    }

    private static boolean ensureAlive(Map<MessageBusImpl, Integer> map, MessageBusImpl bus) {
        if (bus.myDisposed) {
            map.remove(bus);
            LOG.error("Accessing disposed message bus " + bus);
            return false;
        }
        return true;
    }

    private List<Throwable> doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        SmartList<Throwable> exceptions = null;
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            try {
                job.connection.deliverMessage(job.message);
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(e);
            }
        }
        return exceptions == null ? Collections.emptyList() : exceptions;
    }

    void notifyOnSubscription(@NotNull MessageBusConnectionImpl connection, @NotNull Topic<?> topic) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(12);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(13);
        }
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.rootBus().clearSubscriberCache();
    }

    private void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.rootBus().clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal threadLocal = new ThreadLocal<Queue<T>>(){

            @Override
            protected Queue<T> initialValue() {
                return new ConcurrentLinkedQueue();
            }
        };
        if (threadLocal == null) {
            MessageBusImpl.$$$reportNull$$$0(14);
        }
        return threadLocal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootBus";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncPublisher";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopicSubscribers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createThreadLocalQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "asyncPublisher";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses;

        public RootBus(@NotNull Object owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.myWaitingBuses = new ThreadLocal();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        public DeliveryJob(MessageBusConnectionImpl connection, Message message) {
            this.connection = connection;
            this.message = message;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection + "; message: " + this.message + " }";
        }
    }
}

