/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WideSelectionTreeUI
extends BasicTreeUI {
    public static final String TREE_TABLE_TREE_KEY = "TreeTableTree";
    @NonNls
    public static final String SOURCE_LIST_CLIENT_PROPERTY = "mac.ui.source.list";
    @NonNls
    public static final String STRIPED_CLIENT_PROPERTY = "mac.ui.striped";
    private static final Border LIST_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListBackgroundPainter");
    private static final Border LIST_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListSelectionBackgroundPainter");
    private static final Border LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListFocusedSelectionBackgroundPainter");
    @NotNull
    private final Condition<Integer> myWideSelectionCondition;
    private boolean myWideSelection;
    private boolean myOldRepaintAllRowValue;
    private boolean myForceDontPaintLines;
    private boolean mySkinny;

    public WideSelectionTreeUI() {
        this(true, Conditions.alwaysTrue());
    }

    public WideSelectionTreeUI(boolean wideSelection, @NotNull Condition<Integer> wideSelectionCondition) {
        if (wideSelectionCondition == null) {
            WideSelectionTreeUI.$$$reportNull$$$0(0);
        }
        this.myForceDontPaintLines = false;
        this.mySkinny = false;
        this.myWideSelection = wideSelection;
        this.myWideSelectionCondition = wideSelectionCondition;
    }

    @Override
    public int getRightChildIndent() {
        return this.isCustomIndent() ? this.getCustomIndent() : super.getRightChildIndent();
    }

    public boolean isCustomIndent() {
        return this.getCustomIndent() > 0;
    }

    protected int getCustomIndent() {
        return JBUI.scale(Registry.intValue("ide.ui.tree.indent"));
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseEventAdapter<MouseListener>(super.createMouseListener()){

            @Override
            public void mouseDragged(MouseEvent event) {
                JTree tree = (JTree)event.getSource();
                Object property2 = tree.getClientProperty("DnD Source");
                if (property2 == null) {
                    super.mouseDragged(event);
                }
            }

            @Override
            @NotNull
            protected MouseEvent convert(@NotNull MouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!event.isConsumed() && SwingUtilities.isLeftMouseButton(event)) {
                    Rectangle bounds;
                    TreePath path;
                    int x = event.getX();
                    int y = event.getY();
                    JTree tree = (JTree)event.getSource();
                    if (tree.isEnabled() && (path = WideSelectionTreeUI.this.getClosestPathForLocation(tree, x, y)) != null && !WideSelectionTreeUI.this.isLocationInExpandControl(path, x, y) && (bounds = WideSelectionTreeUI.this.getPathBounds(tree, path)) != null && bounds.y <= y && y <= bounds.y + bounds.height && (x = Math.max(bounds.x, Math.min(x, bounds.x + bounds.width - 1))) != event.getX()) {
                        event = 1.convert(event, tree, x, y);
                    }
                }
                MouseEvent mouseEvent = event;
                if (mouseEvent == null) {
                    1.$$$reportNull$$$0(1);
                }
                return mouseEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/ui/tree/WideSelectionTreeUI$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/ui/tree/WideSelectionTreeUI$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convert";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convert";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected void completeUIInstall() {
        super.completeUIInstall();
        this.myOldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
        UIManager.put("Tree.repaintWholeRow", true);
        this.tree.setShowsRootHandles(true);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        UIManager.put("Tree.repaintWholeRow", this.myOldRepaintAllRowValue);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (Boolean.TRUE.equals(this.tree.getClientProperty("MacTreeUi.actionsInstalled"))) {
            return;
        }
        this.tree.putClientProperty("MacTreeUi.actionsInstalled", Boolean.TRUE);
        InputMap inputMap = this.tree.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("pressed LEFT"), "collapse_or_move_up");
        inputMap.put(KeyStroke.getKeyStroke("pressed RIGHT"), "expand");
        ActionMap actionMap = this.tree.getActionMap();
        final Action expandAction = actionMap.get("expand");
        if (expandAction != null) {
            actionMap.put("expand", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selectionPath;
                    JTree tree;
                    int selectionRow;
                    Object source = e.getSource();
                    if (source instanceof JTree && (selectionRow = (tree = (JTree)source).getLeadSelectionRow()) != -1 && (selectionPath = tree.getPathForRow(selectionRow)) != null) {
                        boolean leaf = tree.getModel().isLeaf(selectionPath.getLastPathComponent());
                        int toSelect = -1;
                        int toScroll = -1;
                        if ((!leaf && tree.isExpanded(selectionRow) || leaf) && selectionRow + 1 < tree.getRowCount()) {
                            toScroll = toSelect = selectionRow + 1;
                        }
                        if (toSelect != -1) {
                            tree.setSelectionInterval(toSelect, toSelect);
                        }
                        if (toScroll != -1) {
                            tree.scrollRowToVisible(toScroll);
                        }
                        if (toSelect != -1 || toScroll != -1) {
                            return;
                        }
                    }
                    expandAction.actionPerformed(e);
                }
            });
        }
        actionMap.put("collapse_or_move_up", new TreeUIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JTree) {
                    JTree tree = (JTree)source;
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    TreePath selectionPath = tree.getPathForRow(selectionRow);
                    if (selectionPath == null) {
                        return;
                    }
                    if (tree.getModel().isLeaf(selectionPath.getLastPathComponent()) || tree.isCollapsed(selectionRow)) {
                        TreePath parentPath = tree.getPathForRow(selectionRow).getParentPath();
                        if (parentPath != null && (parentPath.getParentPath() != null || tree.isRootVisible())) {
                            int parentRow = tree.getRowForPath(parentPath);
                            tree.scrollRowToVisible(parentRow);
                            tree.setSelectionInterval(parentRow, parentRow);
                        }
                    } else {
                        tree.collapseRow(selectionRow);
                    }
                }
            }
        });
    }

    public void setForceDontPaintLines() {
        this.myForceDontPaintLines = true;
    }

    @Override
    protected int getRowX(int row, int depth) {
        if (this.isCustomIndent()) {
            int off = this.tree.isRootVisible() ? 8 : 0;
            return 8 * depth + 8 + off;
        }
        return super.getRowX(row, depth);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.shouldPaintLines()) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    private boolean shouldPaintLines() {
        if (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            return false;
        }
        return this.myForceDontPaintLines || !"None".equals(this.tree.getClientProperty("JTree.lineStyle"));
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent e) {
        return UIUtil.isToggleListSelectionEvent(e);
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.shouldPaintLines()) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.shouldPaintLines()) {
            super.paintVerticalLine(g, c, x, top, bottom);
        }
    }

    @Override
    protected Color getHashColor() {
        return super.getHashColor();
    }

    public boolean isWideSelection() {
        return this.myWideSelection;
    }

    public static boolean isWideSelection(@NotNull JTree tree) {
        TreeUI ui;
        if (tree == null) {
            WideSelectionTreeUI.$$$reportNull$$$0(1);
        }
        return (ui = tree.getUI()) instanceof WideSelectionTreeUI && ((WideSelectionTreeUI)ui).isWideSelection();
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int xOffset;
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        int n = xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        if (path != null && this.myWideSelection) {
            boolean selected = this.tree.isPathSelected(path);
            Graphics2D rowGraphics = (Graphics2D)g.create();
            rowGraphics.setClip(clipBounds);
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            Color background = this.tree.getBackground();
            if (row % 2 == 0 && Boolean.TRUE.equals(this.tree.getClientProperty(STRIPED_CLIENT_PROPERTY))) {
                background = UIUtil.getDecoratedRowColor();
            }
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                if (selected) {
                    if (this.tree.hasFocus()) {
                        LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    } else {
                        LIST_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    }
                } else if (this.myWideSelectionCondition.value(row)) {
                    rowGraphics.setColor(background);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            } else if (selected && (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
                Color bg = WideSelectionTreeUI.getSelectionBackground(this.tree, true);
                if (this.myWideSelectionCondition.value(row)) {
                    rowGraphics.setColor(bg);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            }
            if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                this.paintExpandControl(rowGraphics, bounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
            super.paintRow(rowGraphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            rowGraphics.dispose();
        } else {
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.myWideSelection && !UIUtil.isUnderAquaBasedLookAndFeel() && !UIUtil.isUnderDarcula() && !UIUtil.isUnderIntelliJLaF()) {
            this.paintSelectedRows(g, (JTree)c);
        }
        if (this.myWideSelection) {
            int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
            int xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
            Rectangle bounds = g.getClipBounds();
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                Graphics2D backgroundGraphics = (Graphics2D)g.create();
                backgroundGraphics.setClip(xOffset, bounds.y, containerWidth, bounds.height);
                LIST_BACKGROUND_PAINTER.paintBorder(this.tree, backgroundGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                backgroundGraphics.dispose();
            }
        }
        super.paint(g, c);
    }

    protected void paintSelectedRows(Graphics g, JTree tr) {
        Rectangle rect = tr.getVisibleRect();
        int firstVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y);
        int lastVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y + rect.height);
        for (int row = firstVisibleRow; row <= lastVisibleRow; ++row) {
            if (!tr.getSelectionModel().isRowSelected(row) || !this.myWideSelectionCondition.value(row)) continue;
            Rectangle bounds = tr.getRowBounds(row);
            Color color = WideSelectionTreeUI.getSelectionBackground(tr, false);
            if (color == null) continue;
            g.setColor(color);
            g.fillRect(0, bounds.y, tr.getWidth(), bounds.height);
        }
    }

    @Override
    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                if (c instanceof JComponent && WideSelectionTreeUI.this.myWideSelection && c.isOpaque()) {
                    ((JComponent)c).setOpaque(false);
                }
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
        if (!this.isLeaf(row)) {
            this.setExpandedIcon(UIUtil.getTreeNodeIcon(true, isPathSelected, this.tree.hasFocus()));
            this.setCollapsedIcon(UIUtil.getTreeNodeIcon(false, isPathSelected, this.tree.hasFocus()));
        }
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    @Nullable
    private static Color getSelectionBackground(@NotNull JTree tree, boolean checkProperty) {
        Object property2;
        if (tree == null) {
            WideSelectionTreeUI.$$$reportNull$$$0(2);
        }
        if ((property2 = tree.getClientProperty(TREE_TABLE_TREE_KEY)) instanceof JTable) {
            return ((JTable)property2).getSelectionBackground();
        }
        boolean selection = tree.hasFocus();
        if (!selection && checkProperty) {
            selection = Boolean.TRUE.equals(property2);
        }
        return UIUtil.getTreeSelectionBackground(selection);
    }

    public void invalidateNodeSizes() {
        this.treeState.invalidateSizes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wideSelectionCondition";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/tree/WideSelectionTreeUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWideSelection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class TreeUIAction
    extends AbstractAction
    implements UIResource {
        private TreeUIAction() {
        }
    }
}

