/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class NonShortCircuitBooleanInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("NonShortCircuitBooleanExpression" == null) {
            NonShortCircuitBooleanInspection.$$$reportNull$$$0(0);
        }
        return "NonShortCircuitBooleanExpression";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            NonShortCircuitBooleanInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            NonShortCircuitBooleanInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NonShortCircuitBooleanFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonShortCircuitBooleanVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NonShortCircuitBooleanVisitor
    extends BaseInspectionVisitor {
        private NonShortCircuitBooleanVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.AND) && !tokenType.equals(JavaTokenType.OR)) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.BOOLEAN)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class NonShortCircuitBooleanFix
    extends InspectionGadgetsFix {
        private NonShortCircuitBooleanFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.replace.quickfix", new Object[0]);
            if (string == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiPolyadicExpression expression = (PsiPolyadicExpression)descriptor.getPsiElement();
            IElementType tokenType = expression.getOperationTokenType();
            String operandText = NonShortCircuitBooleanFix.getShortCircuitOperand(tokenType);
            PsiExpression[] operands = expression.getOperands();
            StringBuilder newExpression = new StringBuilder();
            CommentTracker commentTracker = new CommentTracker();
            for (PsiExpression operand : operands) {
                if (newExpression.length() != 0) {
                    newExpression.append(operandText);
                }
                newExpression.append(commentTracker.markUnchanged(operand).getText());
            }
            PsiReplacementUtil.replaceExpression(expression, newExpression.toString(), commentTracker);
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (tokenType.equals(JavaTokenType.AND)) {
                return "&&";
            }
            return "||";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanFix", "getFamilyName"));
        }
    }
}

