/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneReturnsClassTypeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.returns.class.type.display.name", new Object[0]);
        if (string == null) {
            CloneReturnsClassTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.returns.class.type.problem.descriptor", infos[0]);
        if (string == null) {
            CloneReturnsClassTypeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String className = (String)infos[0];
        boolean buildFix = (Boolean)infos[1];
        if (!buildFix) {
            return null;
        }
        return new CloneReturnsClassTypeFix(className);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneReturnsClassTypeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/cloneable/CloneReturnsClassTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CloneReturnsClassTypeVisitor
    extends BaseInspectionVisitor {
        private CloneReturnsClassTypeVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            if (!CloneUtils.isClone(method) || !PsiUtil.isLanguageLevel5OrHigher(method)) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType returnType = typeElement.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(returnType);
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || containingClass.equals(aClass)) {
                return;
            }
            if (!CloneUtils.isCloneable(containingClass)) {
                if (JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass).isConvertibleFrom(returnType)) {
                    return;
                }
                this.registerError((PsiElement)typeElement, containingClass.getName(), Boolean.FALSE);
            } else {
                this.registerError((PsiElement)typeElement, containingClass.getName(), Boolean.TRUE);
            }
        }
    }

    private static class CloneReturnsClassTypeFix
    extends InspectionGadgetsFix {
        final String myClassName;

        public CloneReturnsClassTypeFix(String className) {
            this.myClassName = className;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("clone.returns.class.type.quickfix", this.myClassName);
            if (string == null) {
                CloneReturnsClassTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("clone.returns.class.type.family.quickfix", new Object[0]);
            if (string == null) {
                CloneReturnsClassTypeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeElement)) {
                return;
            }
            final PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(this.myClassName, element);
            final PsiType newType = newTypeElement.getType();
            parent.accept(new JavaRecursiveElementVisitor(){

                @Override
                public void visitReturnStatement(PsiReturnStatement statement) {
                    super.visitReturnStatement(statement);
                    Object owner = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiClass.class, PsiLambdaExpression.class, PsiMethod.class);
                    if (owner != parent) {
                        return;
                    }
                    PsiExpression returnValue = PsiUtil.deparenthesizeExpression(statement.getReturnValue());
                    if (returnValue == null || newType.equals(returnValue.getType())) {
                        return;
                    }
                    CommentTracker commentTracker = new CommentTracker();
                    PsiReplacementUtil.replaceStatement(statement, "return (" + myClassName + ')' + commentTracker.markUnchanged(returnValue).getText() + ';', commentTracker);
                }
            });
            element.replace(newTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/cloneable/CloneReturnsClassTypeInspection$CloneReturnsClassTypeFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

