/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ForLoopReplaceableByWhileInspection
extends BaseInspection {
    public boolean m_ignoreLoopsWithoutConditions = false;
    public boolean m_ignoreLoopsWithBody = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.display.name", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("ForLoopReplaceableByWhile" == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(1);
        }
        return "ForLoopReplaceableByWhile";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.problem.descriptor", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("for.loop.replaceable.by.while.ignore.option", new Object[0]), "m_ignoreLoopsWithoutConditions");
        panel.addCheckbox("Ignore non-empty for loops", "m_ignoreLoopsWithBody");
        return panel;
    }

    @Override
    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(3);
        }
        this.defaultWriteSettings(node, "m_ignoreLoopsWithBody");
        this.writeBooleanOption(node, "m_ignoreLoopsWithBody", true);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceForByWhileFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopReplaceableByWhileVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ForLoopReplaceableByWhileVisitor
    extends BaseInspectionVisitor {
        private ForLoopReplaceableByWhileVisitor() {
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement) {
            ProblemHighlightType highlightType;
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            if (PsiUtilCore.hasErrorElementChild(statement)) {
                return;
            }
            if (!ForLoopReplaceableByWhileInspection.this.m_ignoreLoopsWithBody) {
                this.registerStatementError(statement, new Object[0]);
                return;
            }
            if (this.highlightLoop(statement)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                highlightType = ProblemHighlightType.INFORMATION;
            }
            this.registerError(statement.getFirstChild(), highlightType, new Object[0]);
        }

        private boolean highlightLoop(@NotNull PsiForStatement statement) {
            PsiStatement initialization;
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(1);
            }
            if ((initialization = statement.getInitialization()) != null && !(initialization instanceof PsiEmptyStatement)) {
                return false;
            }
            PsiStatement update = statement.getUpdate();
            if (update != null && !(update instanceof PsiEmptyStatement)) {
                return false;
            }
            if (ForLoopReplaceableByWhileInspection.this.m_ignoreLoopsWithoutConditions) {
                PsiExpression condition = statement.getCondition();
                if (condition == null) {
                    return false;
                }
                String conditionText = condition.getText();
                if ("true".equals(conditionText)) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ForLoopReplaceableByWhileVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightLoop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceForByWhileFix
    extends InspectionGadgetsFix {
        private ReplaceForByWhileFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiCodeBlock loopBody;
            PsiBlockStatement blockStatement;
            PsiElement element = descriptor.getPsiElement();
            PsiForStatement forStatement = (PsiForStatement)element.getParent();
            assert (forStatement != null);
            CommentTracker commentTracker = new CommentTracker();
            PsiStatement initialization = forStatement.getInitialization();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(element.getProject());
            PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", element);
            PsiExpression forCondition = forStatement.getCondition();
            PsiExpression whileCondition = whileStatement.getCondition();
            if (forCondition != null) {
                assert (whileCondition != null);
                commentTracker.replace((PsiElement)whileCondition, commentTracker.markUnchanged(forCondition));
            }
            if ((blockStatement = (PsiBlockStatement)whileStatement.getBody()) == null) {
                return;
            }
            PsiStatement forStatementBody = forStatement.getBody();
            if (forStatementBody instanceof PsiBlockStatement) {
                PsiBlockStatement newWhileBody = (PsiBlockStatement)blockStatement.replace(commentTracker.markUnchanged(forStatementBody));
                loopBody = newWhileBody.getCodeBlock();
            } else {
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                if (forStatementBody != null && !(forStatementBody instanceof PsiEmptyStatement)) {
                    codeBlock.add(commentTracker.markUnchanged(forStatementBody));
                }
                loopBody = codeBlock;
            }
            PsiStatement update = forStatement.getUpdate();
            if (update != null) {
                PsiStatement[] updateStatements;
                if (update instanceof PsiExpressionListStatement) {
                    PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)update;
                    PsiExpressionList expressionList = expressionListStatement.getExpressionList();
                    PsiExpression[] expressions = expressionList.getExpressions();
                    updateStatements = new PsiStatement[expressions.length];
                    for (int i = 0; i < expressions.length; ++i) {
                        updateStatements[i] = factory.createStatementFromText(commentTracker.markUnchanged(expressions[i]).getText() + ';', element);
                    }
                } else {
                    PsiStatement updateStatement = factory.createStatementFromText(commentTracker.markUnchanged(update).getText() + ';', element);
                    updateStatements = new PsiStatement[]{updateStatement};
                }
                Collection<PsiContinueStatement> continueStatements = PsiTreeUtil.findChildrenOfType(loopBody, PsiContinueStatement.class);
                for (PsiContinueStatement continueStatement : continueStatements) {
                    BlockUtils.addBefore(continueStatement, updateStatements);
                }
                for (PsiStatement updateStatement : updateStatements) {
                    loopBody.addBefore(updateStatement, loopBody.getLastChild());
                }
            }
            if (initialization == null || initialization instanceof PsiEmptyStatement) {
                commentTracker.replaceAndRestoreComments((PsiElement)forStatement, whileStatement);
            } else {
                initialization = (PsiStatement)commentTracker.markUnchanged(initialization).copy();
                PsiStatement newStatement = (PsiStatement)commentTracker.replaceAndRestoreComments((PsiElement)forStatement, whileStatement);
                BlockUtils.addBefore(newStatement, initialization);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ReplaceForByWhileFix", "getFamilyName"));
        }
    }
}

