/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NegatedConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negated.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            NegatedConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.conditional.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            NegatedConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedConditionalExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NegatedConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private NegatedConditionalExpressionVisitor() {
        }

        @Override
        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            if (!JavaTokenType.EXCL.equals(expression.getOperationTokenType())) {
                return;
            }
            PsiExpression operand = ParenthesesUtils.stripParentheses(expression.getOperand());
            if (!(operand instanceof PsiConditionalExpression)) {
                return;
            }
            this.registerError((PsiElement)expression.getOperationSign(), new Object[0]);
        }
    }

    private static class NegatedConditionalExpressionFix
    extends InspectionGadgetsFix {
        private NegatedConditionalExpressionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.conditional.expression.quickfix", new Object[0]);
            if (string == null) {
                NegatedConditionalExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            PsiExpression operand = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            if (!(operand instanceof PsiConditionalExpression)) {
                return;
            }
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)operand;
            StringBuilder newExpression = new StringBuilder();
            PsiExpression condition = conditionalExpression.getCondition();
            CommentTracker tracker = new CommentTracker();
            newExpression.append(tracker.markUnchanged(condition).getText()).append('?');
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            if (thenExpression != null) {
                newExpression.append(BoolUtils.getNegatedExpressionText(thenExpression, tracker));
            }
            newExpression.append(':');
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            if (elseExpression != null) {
                newExpression.append(BoolUtils.getNegatedExpressionText(elseExpression, tracker));
            }
            PsiReplacementUtil.replaceExpression(prefixExpression, newExpression.toString(), tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection$NegatedConditionalExpressionFix", "getFamilyName"));
        }
    }
}

