/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class NegatedEqualityExpressionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negated.equality.expression.display.name", new Object[0]);
        if (string == null) {
            NegatedEqualityExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.equality.expression.problem.descriptor", infos[0]);
        if (string == null) {
            NegatedEqualityExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedEqualityExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/NegatedEqualityExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NegatedEqualsVisitor
    extends BaseInspectionVisitor {
        private NegatedEqualsVisitor() {
        }

        @Override
        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            if (!JavaTokenType.EXCL.equals(expression.getOperationTokenType())) {
                return;
            }
            PsiExpression operand = ParenthesesUtils.stripParentheses(expression.getOperand());
            if (!(operand instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                this.registerError((PsiElement)expression.getOperationSign(), "==");
            } else if (JavaTokenType.NE.equals(tokenType)) {
                this.registerError((PsiElement)expression.getOperationSign(), "!=");
            }
        }
    }

    private static class NegatedEqualityExpressionFix
    extends InspectionGadgetsFix {
        private NegatedEqualityExpressionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.equality.expression.quickfix", new Object[0]);
            if (string == null) {
                NegatedEqualityExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                return;
            }
            PsiExpression operand = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            if (!(operand instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            CommentTracker commentTracker = new CommentTracker();
            StringBuilder text2 = new StringBuilder(commentTracker.markUnchanged(binaryExpression.getLOperand()).getText());
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                text2.append("!=");
            } else if (JavaTokenType.NE.equals(tokenType)) {
                text2.append("==");
            } else {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs != null) {
                text2.append(commentTracker.markUnchanged(rhs).getText());
            }
            PsiReplacementUtil.replaceExpression(prefixExpression, text2.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedEqualityExpressionInspection$NegatedEqualityExpressionFix", "getFamilyName"));
        }
    }
}

