/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualArrayCopyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("manual.array.copy.display.name", new Object[0]);
        if (string == null) {
            ManualArrayCopyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("manual.array.copy.problem.descriptor", new Object[0]);
        if (string == null) {
            ManualArrayCopyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ManualArrayCopyVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean decrement = (Boolean)infos[0];
        return new ManualArrayCopyFix(decrement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/ManualArrayCopyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ManualArrayCopyVisitor
    extends BaseInspectionVisitor {
        private ManualArrayCopyVisitor() {
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement) {
            boolean decrement;
            if (statement == null) {
                ManualArrayCopyVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            PsiStatement initialization = statement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return;
            }
            PsiStatement update = statement.getUpdate();
            if (VariableAccessUtils.variableIsIncremented(variable, update)) {
                decrement = false;
            } else if (VariableAccessUtils.variableIsDecremented(variable, update)) {
                decrement = true;
            } else {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (decrement ? !ExpressionUtils.isVariableGreaterThanComparison(condition, variable) : !ExpressionUtils.isVariableLessThanComparison(condition, variable)) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (!ManualArrayCopyVisitor.bodyIsArrayCopy(body, variable, null)) {
                return;
            }
            this.registerStatementError(statement, decrement);
        }

        private static boolean bodyIsArrayCopy(PsiStatement body, PsiVariable variable, @Nullable PsiVariable variable2) {
            if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement exp = (PsiExpressionStatement)body;
                PsiExpression expression = exp.getExpression();
                return ManualArrayCopyVisitor.expressionIsArrayCopy(expression, variable, variable2);
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1) {
                    return ManualArrayCopyVisitor.bodyIsArrayCopy(statements[0], variable, variable2);
                }
                if (statements.length == 2) {
                    PsiStatement statement = statements[0];
                    if (!(statement instanceof PsiDeclarationStatement)) {
                        return false;
                    }
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    if (declaredElements.length != 1) {
                        return false;
                    }
                    PsiElement declaredElement = declaredElements[0];
                    if (!(declaredElement instanceof PsiVariable)) {
                        return false;
                    }
                    PsiVariable localVariable = (PsiVariable)declaredElement;
                    PsiExpression initializer = localVariable.getInitializer();
                    if (!ExpressionUtils.isOffsetArrayAccess(initializer, variable)) {
                        return false;
                    }
                    return ManualArrayCopyVisitor.bodyIsArrayCopy(statements[1], variable, localVariable);
                }
            }
            return false;
        }

        private static boolean expressionIsArrayCopy(@Nullable PsiExpression expression, @NotNull PsiVariable variable, @Nullable PsiVariable variable2) {
            PsiExpression strippedRhs;
            PsiExpression strippedLhs;
            PsiExpression strippedExpression;
            if (variable == null) {
                ManualArrayCopyVisitor.$$$reportNull$$$0(1);
            }
            if ((strippedExpression = ParenthesesUtils.stripParentheses(expression)) == null) {
                return false;
            }
            if (!(strippedExpression instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)strippedExpression;
            IElementType tokenType = assignment.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQ)) {
                return false;
            }
            PsiExpression lhs = assignment.getLExpression();
            if (SideEffectChecker.mayHaveSideEffects(lhs)) {
                return false;
            }
            if (!ExpressionUtils.isOffsetArrayAccess(lhs, variable)) {
                return false;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (rhs == null) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects(rhs)) {
                return false;
            }
            if (!ManualArrayCopyVisitor.areExpressionsCopyable(lhs, rhs)) {
                return false;
            }
            PsiType type = lhs.getType();
            if (type instanceof PsiPrimitiveType && !ManualArrayCopyVisitor.areExpressionsCopyable(strippedLhs = ParenthesesUtils.stripParentheses(lhs), strippedRhs = ParenthesesUtils.stripParentheses(rhs))) {
                return false;
            }
            if (variable2 == null) {
                return ExpressionUtils.isOffsetArrayAccess(rhs, variable);
            }
            return VariableAccessUtils.evaluatesToVariable(rhs, variable2);
        }

        private static boolean areExpressionsCopyable(@Nullable PsiExpression lhs, @Nullable PsiExpression rhs) {
            if (lhs == null || rhs == null) {
                return false;
            }
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return false;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return false;
            }
            return !(lhsType instanceof PsiPrimitiveType ? !lhsType.equals(rhsType) : !lhsType.isAssignableFrom(rhsType) || rhsType instanceof PsiPrimitiveType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expressionIsArrayCopy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ManualArrayCopyFix
    extends InspectionGadgetsFix {
        private final boolean decrement;

        public ManualArrayCopyFix(boolean decrement) {
            this.decrement = decrement;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("manual.array.copy.replace.quickfix", new Object[0]);
            if (string == null) {
                ManualArrayCopyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            CommentTracker commentTracker;
            PsiElement forElement = descriptor.getPsiElement();
            PsiForStatement forStatement = (PsiForStatement)forElement.getParent();
            String newExpression = this.buildSystemArrayCopyText(forStatement, commentTracker = new CommentTracker());
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceStatement(forStatement, newExpression, commentTracker);
        }

        @Nullable
        private String buildSystemArrayCopyText(PsiForStatement forStatement, CommentTracker commentTracker) throws IncorrectOperationException {
            PsiExpression condition = forStatement.getCondition();
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(condition);
            if (binaryExpression == null) {
                return null;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            PsiExpression limit = this.decrement ^ JavaTokenType.LT.equals(tokenType) || JavaTokenType.LE.equals(tokenType) ? binaryExpression.getROperand() : binaryExpression.getLOperand();
            if (limit == null) {
                return null;
            }
            PsiStatement initialization = forStatement.getInitialization();
            if (initialization == null) {
                return null;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            String lengthText = this.decrement ? ManualArrayCopyFix.buildLengthText(initializer, limit, JavaTokenType.LE.equals(tokenType) || JavaTokenType.GE.equals(tokenType), commentTracker) : ManualArrayCopyFix.buildLengthText(limit, initializer, JavaTokenType.LE.equals(tokenType) || JavaTokenType.GE.equals(tokenType), commentTracker);
            if (lengthText == null) {
                return null;
            }
            PsiArrayAccessExpression lhs = ManualArrayCopyFix.getLhsArrayAccessExpression(forStatement);
            if (lhs == null) {
                return null;
            }
            PsiExpression lArray = lhs.getArrayExpression();
            String toArrayText = commentTracker.markUnchanged(lArray).getText();
            PsiArrayAccessExpression rhs = ManualArrayCopyFix.getRhsArrayAccessExpression(forStatement);
            if (rhs == null) {
                return null;
            }
            PsiExpression rArray = rhs.getArrayExpression();
            String fromArrayText = commentTracker.markUnchanged(rArray).getText();
            PsiExpression rhsIndexExpression = rhs.getIndexExpression();
            PsiExpression strippedRhsIndexExpression = ParenthesesUtils.stripParentheses(rhsIndexExpression);
            PsiExpression limitExpression = this.decrement ? limit : initializer;
            String fromOffsetText = ManualArrayCopyFix.buildOffsetText(strippedRhsIndexExpression, variable, limitExpression, this.decrement && (JavaTokenType.LT.equals(tokenType) || JavaTokenType.GT.equals(tokenType)), commentTracker);
            PsiExpression lhsIndexExpression = lhs.getIndexExpression();
            PsiExpression strippedLhsIndexExpression = ParenthesesUtils.stripParentheses(lhsIndexExpression);
            String toOffsetText = ManualArrayCopyFix.buildOffsetText(strippedLhsIndexExpression, variable, limitExpression, this.decrement && (JavaTokenType.LT.equals(tokenType) || JavaTokenType.GT.equals(tokenType)), commentTracker);
            StringBuilder buffer = new StringBuilder(60);
            buffer.append("System.arraycopy(");
            buffer.append(fromArrayText);
            buffer.append(", ");
            buffer.append(fromOffsetText);
            buffer.append(", ");
            buffer.append(toArrayText);
            buffer.append(", ");
            buffer.append(toOffsetText);
            buffer.append(", ");
            buffer.append(lengthText);
            buffer.append(");");
            return buffer.toString();
        }

        @Nullable
        private static PsiArrayAccessExpression getLhsArrayAccessExpression(PsiForStatement forStatement) {
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 2) {
                    body = statements[1];
                    continue;
                }
                if (statements.length == 1) {
                    body = statements[0];
                    continue;
                }
                return null;
            }
            if (!(body instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiExpression lhs = assignmentExpression.getLExpression();
            PsiExpression deparenthesizedExpression = ParenthesesUtils.stripParentheses(lhs);
            if (!(deparenthesizedExpression instanceof PsiArrayAccessExpression)) {
                return null;
            }
            return (PsiArrayAccessExpression)deparenthesizedExpression;
        }

        @Nullable
        private static PsiArrayAccessExpression getRhsArrayAccessExpression(PsiForStatement forStatement) {
            PsiExpression arrayAccessExpression;
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1 || statements.length == 2) {
                    body = statements[0];
                    continue;
                }
                return null;
            }
            if (body instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)body;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                if (declaredElements.length != 1) {
                    return null;
                }
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                arrayAccessExpression = variable.getInitializer();
            } else if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiAssignmentExpression)) {
                    return null;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                arrayAccessExpression = assignmentExpression.getRExpression();
            } else {
                return null;
            }
            PsiExpression unparenthesizedExpression = ParenthesesUtils.stripParentheses(arrayAccessExpression);
            if (!(unparenthesizedExpression instanceof PsiArrayAccessExpression)) {
                return null;
            }
            return (PsiArrayAccessExpression)unparenthesizedExpression;
        }

        @NonNls
        @Nullable
        private static String buildLengthText(PsiExpression max, PsiExpression min, boolean plusOne, CommentTracker commentTracker) {
            if ((max = ParenthesesUtils.stripParentheses(max)) == null) {
                return null;
            }
            if ((min = ParenthesesUtils.stripParentheses(min)) == null) {
                return ManualArrayCopyFix.buildExpressionText(max, plusOne, false, commentTracker);
            }
            Object minConstant = ExpressionUtils.computeConstantExpression(min);
            if (minConstant instanceof Number) {
                Object maxConstant;
                Number minNumber = (Number)minConstant;
                int minValue = plusOne ? minNumber.intValue() - 1 : minNumber.intValue();
                if (minValue == 0) {
                    return ManualArrayCopyFix.buildExpressionText(max, false, false, commentTracker);
                }
                if (max instanceof PsiLiteralExpression && (maxConstant = ExpressionUtils.computeConstantExpression(max)) instanceof Number) {
                    Number number = (Number)maxConstant;
                    return String.valueOf(number.intValue() - minValue);
                }
                String maxText = ManualArrayCopyFix.buildExpressionText(max, false, false, commentTracker);
                if (minValue > 0) {
                    return maxText + '-' + minValue;
                }
                return maxText + '+' + -minValue;
            }
            int precedence = ParenthesesUtils.getPrecedence(min);
            String minText = precedence >= 6 ? '(' + commentTracker.markUnchanged(min).getText() + ')' : commentTracker.markUnchanged(min).getText();
            String maxText = ManualArrayCopyFix.buildExpressionText(max, plusOne, false, commentTracker);
            return maxText + '-' + minText;
        }

        private static String buildExpressionText(PsiExpression expression, boolean plusOne, boolean parenthesize, CommentTracker commentTracker) {
            int precedence;
            PsiLiteralExpression literalExpression;
            Object value;
            if (!plusOne) {
                int precedence2 = ParenthesesUtils.getPrecedence(expression);
                if (precedence2 > 6) {
                    return '(' + commentTracker.markUnchanged(expression).getText() + ')';
                }
                if (parenthesize && precedence2 >= 6) {
                    return '(' + commentTracker.markUnchanged(expression).getText() + ')';
                }
                return commentTracker.markUnchanged(expression).getText();
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiExpression rhs;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (tokenType == JavaTokenType.MINUS && ExpressionUtils.isOne(rhs = binaryExpression.getROperand())) {
                    return commentTracker.markUnchanged(binaryExpression.getLOperand()).getText();
                }
            } else if (expression instanceof PsiLiteralExpression && (value = (literalExpression = (PsiLiteralExpression)expression).getValue()) instanceof Integer) {
                Integer integer = (Integer)value;
                return String.valueOf(integer + 1);
            }
            String result2 = (precedence = ParenthesesUtils.getPrecedence(expression)) > 6 ? '(' + ManualArrayCopyFix.getText(expression, commentTracker) + ")+1" : ManualArrayCopyFix.getText(expression, commentTracker) + "+1";
            if (parenthesize) {
                return '(' + result2 + ')';
            }
            return result2;
        }

        private static String getText(PsiExpression expression, CommentTracker commentTracker) {
            return commentTracker.markUnchanged(expression).getText();
        }

        @NonNls
        @Nullable
        private static String buildOffsetText(PsiExpression expression, PsiLocalVariable variable, PsiExpression limitExpression, boolean plusOne, CommentTracker commentTracker) throws IncorrectOperationException {
            String variableName;
            if (expression == null) {
                return null;
            }
            String expressionText = ManualArrayCopyFix.getText(expression, commentTracker);
            if (expressionText.equals(variableName = variable.getName())) {
                PsiExpression initialValue = ParenthesesUtils.stripParentheses(limitExpression);
                if (initialValue == null) {
                    return null;
                }
                return ManualArrayCopyFix.buildExpressionText(initialValue, plusOne, false, commentTracker);
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                String rhsText = ManualArrayCopyFix.buildOffsetText(rhs, variable, limitExpression, plusOne, commentTracker);
                PsiJavaToken sign = binaryExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                if (ExpressionUtils.isZero(lhs)) {
                    if (tokenType.equals(JavaTokenType.MINUS)) {
                        return '-' + rhsText;
                    }
                    return rhsText;
                }
                if (plusOne && tokenType.equals(JavaTokenType.MINUS) && ExpressionUtils.isOne(rhs)) {
                    return ManualArrayCopyFix.buildOffsetText(lhs, variable, limitExpression, false, commentTracker);
                }
                String lhsText = ManualArrayCopyFix.buildOffsetText(lhs, variable, limitExpression, plusOne, commentTracker);
                if (ExpressionUtils.isZero(rhs)) {
                    return lhsText;
                }
                return ManualArrayCopyFix.collapseConstant(lhsText + sign.getText() + rhsText, variable);
            }
            return ManualArrayCopyFix.collapseConstant(ManualArrayCopyFix.getText(expression, commentTracker), variable);
        }

        private static String collapseConstant(@NonNls String expressionText, PsiElement context) throws IncorrectOperationException {
            Project project = context.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiExpression fromOffsetExpression = factory.createExpressionFromText(expressionText, context);
            Object fromOffsetConstant = ExpressionUtils.computeConstantExpression(fromOffsetExpression);
            if (fromOffsetConstant != null) {
                return fromOffsetConstant.toString();
            }
            return expressionText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyFix", "getFamilyName"));
        }
    }
}

