/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantOnRHSOfComparisonInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ConstantOnRightSideOfComparison" == null) {
            ConstantOnRHSOfComparisonInspection.$$$reportNull$$$0(0);
        }
        return "ConstantOnRightSideOfComparison";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.on.rhs.of.comparison.display.name", new Object[0]);
        if (string == null) {
            ConstantOnRHSOfComparisonInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.on.rhs.of.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantOnRHSOfComparisonInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantOnRHSOfComparisonVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SwapComparisonFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ConstantOnRHSOfComparisonInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantOnRHSOfComparisonVisitor
    extends BaseInspectionVisitor {
        private ConstantOnRHSOfComparisonVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                ConstantOnRHSOfComparisonVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (!ConstantOnRHSOfComparisonVisitor.isConstantExpression(rhs) || ConstantOnRHSOfComparisonVisitor.isConstantExpression(lhs)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean isConstantExpression(PsiExpression expression) {
            return ExpressionUtils.isNullLiteral(expression) || PsiUtil.isConstantExpression(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ConstantOnRHSOfComparisonInspection$ConstantOnRHSOfComparisonVisitor", "visitBinaryExpression"));
        }
    }

    private static class SwapComparisonFix
    extends InspectionGadgetsFix {
        private SwapComparisonFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("flip.comparison.quickfix", new Object[0]);
            if (string == null) {
                SwapComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiBinaryExpression expression = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            String flippedComparison = ComparisonUtils.getFlippedComparison(expression.getOperationTokenType());
            if (flippedComparison == null) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            CommentTracker commentTracker = new CommentTracker();
            String rhsText = commentTracker.markUnchanged(rhs).getText();
            String lhsText = commentTracker.markUnchanged(lhs).getText();
            PsiReplacementUtil.replaceExpression(expression, rhsText + ' ' + flippedComparison + ' ' + lhsText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ConstantOnRHSOfComparisonInspection$SwapComparisonFix", "getFamilyName"));
        }
    }
}

