/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EqualsCalledOnEnumConstantInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.called.on.enum.constant.display.name", new Object[0]);
        if (string == null) {
            EqualsCalledOnEnumConstantInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.called.on.enum.constant.problem.descriptor", new Object[0]);
        if (string == null) {
            EqualsCalledOnEnumConstantInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement element = (PsiElement)infos[0];
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            return null;
        }
        return new EqualsCalledOnEnumValueFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsCalledOnEnumValueVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EqualsCalledOnEnumValueVisitor
    extends BaseInspectionVisitor {
        private EqualsCalledOnEnumValueVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                EqualsCalledOnEnumValueVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isEqualsCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || !TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Enum")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 0) {
                PsiType comparedTypeErasure = TypeConversionUtil.erasure(qualifier.getType());
                PsiType comparisonTypeErasure = TypeConversionUtil.erasure(arguments[0].getType());
                if (comparedTypeErasure == null || comparisonTypeErasure == null || !TypeConversionUtil.areTypesConvertible(comparedTypeErasure, comparisonTypeErasure)) {
                    return;
                }
            }
            this.registerMethodCallError(expression, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection$EqualsCalledOnEnumValueVisitor", "visitMethodCallExpression"));
        }
    }

    private static class EqualsCalledOnEnumValueFix
    extends InspectionGadgetsFix {
        private EqualsCalledOnEnumValueFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("equals.called.on.enum.constant.quickfix", new Object[0]);
            if (string == null) {
                EqualsCalledOnEnumValueFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            boolean not;
            PsiPrefixExpression prefixExpression;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent == null) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 1) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiElement greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiPrefixExpression) {
                prefixExpression = (PsiPrefixExpression)greatGrandParent;
                IElementType tokenType = prefixExpression.getOperationTokenType();
                not = JavaTokenType.EXCL == tokenType;
            } else {
                prefixExpression = null;
                not = false;
            }
            CommentTracker commentTracker = new CommentTracker();
            newExpression.append(commentTracker.markUnchanged(qualifier).getText());
            if (not) {
                newExpression.append("!=");
            } else {
                newExpression.append("==");
            }
            if (arguments.length == 1) {
                newExpression.append(commentTracker.markUnchanged(arguments[0]).getText());
            }
            if (not) {
                PsiReplacementUtil.replaceExpression(prefixExpression, newExpression.toString(), commentTracker);
            } else {
                PsiReplacementUtil.replaceExpression(methodCallExpression, newExpression.toString(), commentTracker);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection$EqualsCalledOnEnumValueFix", "getFamilyName"));
        }
    }
}

