/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAtomicOperationOnVolatileFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.atomic.operation.on.volatile.field.display.name", new Object[0]);
        if (string == null) {
            NonAtomicOperationOnVolatileFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.atomic.operation.on.volatile.field.problem.descriptor", new Object[0]);
        if (string == null) {
            NonAtomicOperationOnVolatileFieldInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonAtomicOperationOnVolatileFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NonAtomicOperationOnVolatileFieldVisitor
    extends BaseInspectionVisitor {
        private NonAtomicOperationOnVolatileFieldVisitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                NonAtomicOperationOnVolatileFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression);
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getRExpression());
            if (rhs == null) {
                return;
            }
            final PsiExpression lhs = expression.getLExpression();
            final PsiField volatileField = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileField(lhs);
            if (volatileField == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSEQ) || tokenType.equals(JavaTokenType.MINUSEQ) || tokenType.equals(JavaTokenType.ASTERISKEQ) || tokenType.equals(JavaTokenType.DIVEQ) || tokenType.equals(JavaTokenType.ANDEQ) || tokenType.equals(JavaTokenType.OREQ) || tokenType.equals(JavaTokenType.XOREQ) || tokenType.equals(JavaTokenType.PERCEQ) || tokenType.equals(JavaTokenType.LTLTEQ) || tokenType.equals(JavaTokenType.GTGTEQ) || tokenType.equals(JavaTokenType.GTGTGTEQ)) {
                this.registerError((PsiElement)lhs, new Object[0]);
                return;
            }
            if (this.isOnTheFly() && !volatileField.hasModifierProperty("private")) {
                return;
            }
            rhs.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression reference) {
                    if (reference.isReferenceTo(volatileField) && ExpressionUtil.isEffectivelyUnqualified(reference)) {
                        this.stopWalking();
                        PsiElement referenceNameElement = ((PsiJavaCodeReferenceElement)((Object)lhs)).getReferenceNameElement();
                        if (referenceNameElement != null) {
                            this.registerError(referenceNameElement, new Object[0]);
                        }
                        return;
                    }
                    super.visitReferenceExpression(reference);
                }
            });
        }

        @Override
        public void visitUnaryExpression(PsiUnaryExpression expression) {
            super.visitUnaryExpression(expression);
            if (!PsiUtil.isIncrementDecrementOperation(expression)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiField volatileField = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileField(operand);
            if (volatileField == null) {
                return;
            }
            this.registerError((PsiElement)operand, new Object[0]);
        }

        @Nullable
        private static PsiField findNonSynchronizedVolatileField(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression;
            if (!ExpressionUtil.isEffectivelyUnqualified(reference)) {
                return null;
            }
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("volatile")) {
                return null;
            }
            if (SynchronizationUtil.isInSynchronizedContext(reference)) {
                return null;
            }
            return field;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection$NonAtomicOperationOnVolatileFieldVisitor", "visitAssignmentExpression"));
        }
    }
}

