/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmbiguousMethodCallInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("ambiguous.method.call.display.name", new Object[0]);
        if (string == null) {
            AmbiguousMethodCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        PsiClass outerClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("ambiguous.method.call.problem.descriptor", superClass.getName(), outerClass.getName());
        if (string == null) {
            AmbiguousMethodCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AmbiguousMethodCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AmbiguousMethodCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/AmbiguousMethodCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AmbiguousMethodCallVisitor
    extends BaseInspectionVisitor {
        private AmbiguousMethodCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(expression);
            if (containingClass == null) {
                return;
            }
            PsiMethod targetMethod = expression.resolveMethod();
            if (targetMethod == null) {
                return;
            }
            PsiClass methodClass = targetMethod.getContainingClass();
            if (methodClass == null || !containingClass.isInheritor(methodClass, true)) {
                return;
            }
            containingClass = ClassUtils.getContainingClass(containingClass);
            boolean staticAccess = false;
            while (containingClass != null) {
                PsiMethod[] methods = containingClass.findMethodsBySignature(targetMethod, false);
                if (!(methods.length <= 0 || methodClass.equals(containingClass) || (staticAccess |= containingClass.hasModifierProperty("static")) && !Arrays.stream(methods).anyMatch(m -> m.hasModifierProperty("static")))) {
                    this.registerMethodCallError(expression, methodClass, containingClass);
                    return;
                }
                containingClass = ClassUtils.getContainingClass(containingClass);
            }
        }
    }

    private static class AmbiguousMethodCallFix
    extends InspectionGadgetsFix {
        private AmbiguousMethodCallFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("ambiguous.method.call.quickfix", new Object[0]);
            if (string == null) {
                AmbiguousMethodCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent.getParent();
            String newExpressionText = "super." + methodCallExpression.getText();
            PsiReplacementUtil.replaceExpression(methodCallExpression, newExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousMethodCallInspection$AmbiguousMethodCallFix", "getFamilyName"));
        }
    }
}

