/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.treeHash.AbstractTreeHasher;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreeHashingUtils;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeHasherBase
extends AbstractTreeHasher {
    private final FragmentsCollector myCallback;
    private final int myDiscardCost;
    private final DuplicatesProfile myProfile;

    TreeHasherBase(@Nullable FragmentsCollector callback, @NotNull DuplicatesProfile profile2, int discardCost, boolean forIndexing) {
        if (profile2 == null) {
            TreeHasherBase.$$$reportNull$$$0(0);
        }
        super(callback, forIndexing);
        this.myCallback = callback;
        this.myDiscardCost = discardCost;
        this.myProfile = profile2;
    }

    @Override
    protected int getDiscardCost(PsiElement root) {
        if (this.myDiscardCost >= 0) {
            return this.myDiscardCost;
        }
        return this.myProfile.getDuplocatorState(this.myProfile.getLanguage(root)).getDiscardCost();
    }

    @Override
    protected TreeHashResult hash(@NotNull PsiElement root, PsiFragment upper, @NotNull NodeSpecificHasher hasher) {
        if (root == null) {
            TreeHasherBase.$$$reportNull$$$0(1);
        }
        if (hasher == null) {
            TreeHasherBase.$$$reportNull$$$0(2);
        }
        TreeHashResult result2 = this.computeHash(root, upper, hasher);
        int discardCost = this.getDiscardCost(root);
        if (result2.getCost() < discardCost) {
            return new TreeHashResult(0, result2.getCost(), result2.getFragment());
        }
        return result2;
    }

    private TreeHashResult computeHash(PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        List<PsiElement> children;
        EquivalenceDescriptor descriptor;
        EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(root);
        if (descriptorProvider != null && (descriptor = descriptorProvider.buildDescriptor(root)) != null) {
            return this.computeHash(root, upper, descriptor, hasher);
        }
        if (root instanceof PsiFile && (children = hasher.getNodeChildren(root)).size() <= 20) {
            return this.hashCodeBlock(children, upper, hasher, true);
        }
        NodeSpecificHasherBase ssrNodeSpecificHasher = (NodeSpecificHasherBase)hasher;
        if (TreeHasherBase.shouldBeAnonymized(root, ssrNodeSpecificHasher)) {
            return this.computeElementHash(root, upper, hasher);
        }
        if (this.myForIndexing) {
            return this.computeElementHash(root, upper, hasher);
        }
        PsiElement element = DuplocatorUtil.getOnlyChild(root, ssrNodeSpecificHasher.getNodeFilter());
        if (element != root) {
            TreeHashResult result2 = this.hash(element, upper, hasher);
            int cost = hasher.getNodeCost(root);
            return new TreeHashResult(result2.getHash(), result2.getCost() + cost, result2.getFragment());
        }
        return this.computeElementHash(element, upper, hasher);
    }

    @Override
    public boolean shouldAnonymize(PsiElement root, NodeSpecificHasher hasher) {
        return TreeHasherBase.shouldBeAnonymized(root, (NodeSpecificHasherBase)hasher);
    }

    @Override
    protected TreeHashResult computeElementHash(@NotNull PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        if (root == null) {
            TreeHasherBase.$$$reportNull$$$0(3);
        }
        if (this.myForIndexing) {
            return TreeHashingUtils.computeElementHashForIndexing(this, this.myCallBack, root, upper, hasher);
        }
        List<PsiElement> children = hasher.getNodeChildren(root);
        int size = children.size();
        int[] childHashes = new int[size];
        int[] childCosts = new int[size];
        TreePsiFragment fragment = this.buildFragment(hasher, root, this.getCost(root));
        if (upper != null) {
            fragment.setParent(upper);
        }
        if (size == 0 && !(root instanceof LeafElement)) {
            return new TreeHashResult(0, hasher.getNodeCost(root), fragment);
        }
        for (int i = 0; i < size; ++i) {
            TreeHashResult res = this.hash(children.get(i), fragment, hasher);
            childHashes[i] = res.getHash();
            childCosts[i] = res.getCost();
        }
        int c = hasher.getNodeCost(root) + AbstractTreeHasher.vector(childCosts);
        int h1 = hasher.getNodeHash(root);
        int discardCost = this.getDiscardCost(root);
        for (int i = 0; i < size; ++i) {
            if (childCosts[i] > discardCost || !this.ignoreChildHash(children.get(i))) continue;
            childHashes[i] = 0;
        }
        int h = h1 + AbstractTreeHasher.vector(childHashes);
        if (TreeHasherBase.shouldBeAnonymized(root, (NodeSpecificHasherBase)hasher)) {
            h = 0;
        }
        if (this.myCallBack != null) {
            this.myCallBack.add(h, c, fragment);
        }
        return new TreeHashResult(h, c, fragment);
    }

    @Override
    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher, boolean forceHash) {
        if (!this.myForIndexing) {
            return super.hashCodeBlock(statements, upper, hasher, forceHash);
        }
        return TreeHashingUtils.hashCodeBlockForIndexing(this, this.myCallBack, statements, upper, hasher);
    }

    private TreeHashResult computeHash(PsiElement element, PsiFragment parent, EquivalenceDescriptor descriptor, NodeSpecificHasher hasher) {
        Couple<Integer> childHashResult;
        NodeSpecificHasherBase ssrHasher = (NodeSpecificHasherBase)hasher;
        PsiElement element2 = DuplocatorUtil.skipNodeIfNeccessary(element, descriptor, ssrHasher.getNodeFilter());
        boolean canSkip = element2 != element;
        TreePsiFragment fragment = this.buildFragment(hasher, element, 0);
        if (parent != null) {
            fragment.setParent(parent);
        }
        int hash = canSkip ? 0 : hasher.getNodeHash(element);
        int cost = hasher.getNodeCost(element);
        for (SingleChildDescriptor singleChildDescriptor : descriptor.getSingleChildDescriptors()) {
            childHashResult = this.computeHash(singleChildDescriptor, (PsiFragment)fragment, hasher);
            hash = hash * 31 + (Integer)childHashResult.first;
            cost += ((Integer)childHashResult.second).intValue();
        }
        for (MultiChildDescriptor multiChildDescriptor : descriptor.getMultiChildDescriptors()) {
            childHashResult = this.computeHash(multiChildDescriptor, (PsiFragment)fragment, hasher);
            hash = hash * 31 + (Integer)childHashResult.first;
            cost += ((Integer)childHashResult.second).intValue();
        }
        for (Object object : descriptor.getConstants()) {
            int constantHash = object != null ? object.hashCode() : 0;
            hash = hash * 31 + constantHash;
        }
        for (PsiElement[] psiElementArray : descriptor.getCodeBlocks()) {
            List<PsiElement> filteredBlock = TreeHasherBase.filter(psiElementArray, ssrHasher);
            TreeHashResult childHashResult2 = this.hashCodeBlock(filteredBlock, fragment, hasher);
            hash = hash * 31 + childHashResult2.getHash();
            cost += childHashResult2.getCost();
        }
        if (this.myCallback != null) {
            this.myCallback.add(hash, cost, fragment);
        }
        return new TreeHashResult(hash, cost, fragment);
    }

    public static List<PsiElement> filter(PsiElement[] elements, NodeSpecificHasherBase hasher) {
        ArrayList<PsiElement> filteredElements = new ArrayList<PsiElement>();
        for (PsiElement element : elements) {
            if (hasher.getNodeFilter().accepts(element)) continue;
            filteredElements.add(element);
        }
        return filteredElements;
    }

    @NotNull
    private Couple<Integer> computeHash(SingleChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement element = childDescriptor.getElement();
        if (element == null) {
            Couple<Integer> couple = Couple.of(0, 0);
            if (couple == null) {
                TreeHasherBase.$$$reportNull$$$0(4);
            }
            return couple;
        }
        Couple<Integer> result2 = this.doComputeHash(childDescriptor, parentFragment, nodeSpecificHasher);
        DuplicatesProfileBase duplicatesProfile = ((NodeSpecificHasherBase)nodeSpecificHasher).getDuplicatesProfile();
        PsiElementRole role = duplicatesProfile.getRole(element);
        if (role != null && !duplicatesProfile.getDuplocatorState(duplicatesProfile.getLanguage(element)).distinguishRole(role)) {
            Couple<Object> couple = Couple.of(0, result2.second);
            if (couple == null) {
                TreeHasherBase.$$$reportNull$$$0(5);
            }
            return couple;
        }
        Couple<Integer> couple = result2;
        if (couple == null) {
            TreeHasherBase.$$$reportNull$$$0(6);
        }
        return couple;
    }

    private static boolean shouldBeAnonymized(PsiElement element, NodeSpecificHasherBase nodeSpecificHasher) {
        DuplicatesProfileBase duplicatesProfile = nodeSpecificHasher.getDuplicatesProfile();
        PsiElementRole role = duplicatesProfile.getRole(element);
        return role != null && !duplicatesProfile.getDuplocatorState(duplicatesProfile.getLanguage(element)).distinguishRole(role);
    }

    @NotNull
    private Couple<Integer> doComputeHash(SingleChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement element = childDescriptor.getElement();
        switch (childDescriptor.getType()) {
            case OPTIONALLY_IN_PATTERN: 
            case DEFAULT: {
                TreeHashResult result2 = this.hash(element, parentFragment, nodeSpecificHasher);
                Couple<Integer> couple = Couple.of(result2.getHash(), result2.getCost());
                if (couple == null) {
                    TreeHasherBase.$$$reportNull$$$0(7);
                }
                return couple;
            }
            case CHILDREN_OPTIONALLY_IN_PATTERN: 
            case CHILDREN: {
                TreeHashResult[] childResults = this.computeHashesForChildren(element, parentFragment, nodeSpecificHasher);
                int[] hashes = TreeHasherBase.getHashes(childResults);
                int[] costs = TreeHasherBase.getCosts(childResults);
                int hash = AbstractTreeHasher.vector(hashes, 31);
                int cost = AbstractTreeHasher.vector(costs);
                Couple<Integer> couple = Couple.of(hash, cost);
                if (couple == null) {
                    TreeHasherBase.$$$reportNull$$$0(8);
                }
                return couple;
            }
            case CHILDREN_IN_ANY_ORDER: {
                TreeHashResult[] childResults = this.computeHashesForChildren(element, parentFragment, nodeSpecificHasher);
                int[] hashes = TreeHasherBase.getHashes(childResults);
                int[] costs = TreeHasherBase.getCosts(childResults);
                int hash = AbstractTreeHasher.vector(hashes);
                int cost = AbstractTreeHasher.vector(costs);
                Couple<Integer> couple = Couple.of(hash, cost);
                if (couple == null) {
                    TreeHasherBase.$$$reportNull$$$0(9);
                }
                return couple;
            }
        }
        Couple<Integer> couple = Couple.of(0, 0);
        if (couple == null) {
            TreeHasherBase.$$$reportNull$$$0(10);
        }
        return couple;
    }

    @NotNull
    private Couple<Integer> computeHash(MultiChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement[] elements = childDescriptor.getElements();
        if (elements == null) {
            Couple<Integer> couple = Couple.of(0, 0);
            if (couple == null) {
                TreeHasherBase.$$$reportNull$$$0(11);
            }
            return couple;
        }
        switch (childDescriptor.getType()) {
            case OPTIONALLY_IN_PATTERN: 
            case DEFAULT: {
                TreeHashResult[] childResults = this.computeHashes(elements, parentFragment, nodeSpecificHasher);
                int[] hashes = TreeHasherBase.getHashes(childResults);
                int[] costs = TreeHasherBase.getCosts(childResults);
                int hash = AbstractTreeHasher.vector(hashes, 31);
                int cost = AbstractTreeHasher.vector(costs);
                Couple<Integer> couple = Couple.of(hash, cost);
                if (couple == null) {
                    TreeHasherBase.$$$reportNull$$$0(12);
                }
                return couple;
            }
            case IN_ANY_ORDER: {
                TreeHashResult[] childResults = this.computeHashes(elements, parentFragment, nodeSpecificHasher);
                int[] hashes = TreeHasherBase.getHashes(childResults);
                int[] costs = TreeHasherBase.getCosts(childResults);
                int hash = AbstractTreeHasher.vector(hashes);
                int cost = AbstractTreeHasher.vector(costs);
                Couple<Integer> couple = Couple.of(hash, cost);
                if (couple == null) {
                    TreeHasherBase.$$$reportNull$$$0(13);
                }
                return couple;
            }
        }
        Couple<Integer> couple = Couple.of(0, 0);
        if (couple == null) {
            TreeHasherBase.$$$reportNull$$$0(14);
        }
        return couple;
    }

    @NotNull
    private TreeHashResult[] computeHashesForChildren(PsiElement element, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        ArrayList<TreeHashResult> result2 = new ArrayList<TreeHashResult>();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            TreeHashResult childResult = this.hash(element, parentFragment, nodeSpecificHasher);
            result2.add(childResult);
        }
        TreeHashResult[] treeHashResultArray = result2.toArray(new TreeHashResult[result2.size()]);
        if (treeHashResultArray == null) {
            TreeHasherBase.$$$reportNull$$$0(15);
        }
        return treeHashResultArray;
    }

    @NotNull
    private TreeHashResult[] computeHashes(PsiElement[] elements, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        TreeHashResult[] result2 = new TreeHashResult[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result2[i] = this.hash(elements[i], parentFragment, nodeSpecificHasher);
        }
        if (result2 == null) {
            TreeHasherBase.$$$reportNull$$$0(16);
        }
        return result2;
    }

    private static int[] getHashes(TreeHashResult[] results) {
        int[] hashes = new int[results.length];
        for (int i = 0; i < results.length; ++i) {
            hashes[i] = results[i].getHash();
        }
        return hashes;
    }

    private static int[] getCosts(TreeHashResult[] results) {
        int[] costs = new int[results.length];
        for (int i = 0; i < results.length; ++i) {
            costs[i] = results[i].getCost();
        }
        return costs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasher";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/treeHash/TreeHasherBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/treeHash/TreeHasherBase";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHash";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeHash";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHashesForChildren";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hash";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeElementHash";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

