/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());

    private LanguageUtil() {
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file) {
        Language language;
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(0);
        }
        if ((language = LanguageUtil.getFileLanguage(file)) == null) {
            return null;
        }
        return LanguageSubstitutors.INSTANCE.substituteLanguage(language, file, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        Language l = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
        return l != null ? l : LanguageUtil.getFileTypeLanguage(file.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@Nullable FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Nullable
    public static FileType getLanguageFileType(@Nullable Language language) {
        return language == null ? null : language.getAssociatedFileType();
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Language[] getLanguageDialects(@NotNull Language base) {
        if (base == null) {
            LanguageUtil.$$$reportNull$$$0(1);
        }
        List<Language> list = ContainerUtil.findAll(Language.getRegisteredLanguages(), language -> {
            if (base == null) {
                LanguageUtil.$$$reportNull$$$0(9);
            }
            return language.getBaseLanguage() == base;
        });
        Language[] languageArray = list.toArray(new Language[list.size()]);
        if (languageArray == null) {
            LanguageUtil.$$$reportNull$$$0(2);
        }
        return languageArray;
    }

    public static boolean isInTemplateLanguageFile(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(3);
        }
        if (language == Language.ANY) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    public static boolean isFileLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(4);
        }
        if (language instanceof DependentLanguage || language instanceof InjectableLanguage) {
            return false;
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            return false;
        }
        LanguageFileType type = language.getAssociatedFileType();
        if (type == null || StringUtil.isEmpty(type.getDefaultExtension())) {
            return false;
        }
        return StringUtil.isNotEmpty(type.getDefaultExtension());
    }

    @NotNull
    public static List<Language> getFileLanguages() {
        ArrayList<Language> result2 = ContainerUtil.newArrayList();
        for (Language language : Language.getRegisteredLanguages()) {
            if (!LanguageUtil.isFileLanguage(language)) continue;
            result2.add(language);
        }
        result2.sort(LANGUAGE_COMPARATOR);
        ArrayList<Language> arrayList = result2;
        if (arrayList == null) {
            LanguageUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        Language language;
        PsiFile containingFile;
        FileViewProvider provider;
        Set<Language> languages;
        if (element == null) {
            LanguageUtil.$$$reportNull$$$0(6);
        }
        if ((languages = (provider = (containingFile = element.getContainingFile()).getViewProvider()).getLanguages()).size() > 1 && languages.contains(language = containingFile.getLanguage())) {
            Language language2 = language;
            if (language2 == null) {
                LanguageUtil.$$$reportNull$$$0(7);
            }
            return language2;
        }
        Language language3 = provider.getBaseLanguage();
        if (language3 == null) {
            LanguageUtil.$$$reportNull$$$0(8);
        }
        return language3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/LanguageUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/LanguageUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageDialects";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileLanguages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForPsi";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialects";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInjectableLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRootLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLanguageDialects$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

