/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class Registry {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final ConcurrentMap<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private static final Registry ourInstance;

    @NotNull
    public static RegistryValue get(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        Registry registry = Registry.getInstance();
        RegistryValue value = (RegistryValue)registry.myValues.get(key);
        if (value == null) {
            value = ConcurrencyUtil.cacheOrGet(registry.myValues, key, new RegistryValue(registry, key));
        }
        RegistryValue registryValue = value;
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(1);
        }
        return registryValue;
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(2);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, boolean defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(3);
        }
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asInteger();
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, int defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static double doubleValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(6);
        }
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(7);
        }
        String string = Registry.get(key).asString();
        if (string == null) {
            Registry.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static Color getColor(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, Color defaultValue) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(9);
        }
        return Registry.get(key).asColor(defaultValue);
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(REGISTRY_BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            Registry.$$$reportNull$$$0(10);
        }
        return resourceBundle;
    }

    @NotNull
    public static Registry getInstance() {
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(11);
        }
        return registry;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (String eachKey : this.myUserProperties.keySet()) {
            Element entry = new Element("entry");
            entry.setAttribute("key", eachKey);
            entry.setAttribute("value", this.myUserProperties.get(eachKey));
            state.addContent(entry);
        }
        Element element = state;
        if (element == null) {
            Registry.$$$reportNull$$$0(12);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            Registry.$$$reportNull$$$0(13);
        }
        this.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value = eachEntry.getAttributeValue("value");
            if (key == null || value == null || !(registryValue = Registry.get(key)).isChangedFromDefault(value)) continue;
            this.myUserProperties.put(key, value);
            registryValue.resetCache();
        }
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map = this.myUserProperties;
        if (map == null) {
            Registry.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    public static List<RegistryValue> getAll() {
        ResourceBundle bundle = Registry.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<RegistryValue> result2 = new ArrayList<RegistryValue>();
        while (keys.hasMoreElements()) {
            String each = keys.nextElement();
            if (each.endsWith(".description") || each.endsWith(".restartRequired")) continue;
            result2.add(Registry.get(each));
        }
        ArrayList<RegistryValue> arrayList = result2;
        if (arrayList == null) {
            Registry.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>();
        old.putAll(this.myUserProperties);
        for (String each : old.keySet()) {
            try {
                Registry.get(each).resetToDefault();
            }
            catch (MissingResourceException e) {
                this.myValues.remove(each);
            }
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map) {
        if (map == null) {
            Registry.$$$reportNull$$$0(16);
        }
        for (String s : map.keySet()) {
            RegistryValue eachValue = Registry.get(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    static {
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundle";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

