/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters parameters, @NotNull Processor<PsiMethod> consumer) {
        VirtualFile[] files;
        if (parameters == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(1);
        }
        PsiMethod method = parameters.getMethod();
        Project project = ReadAction.compute(method::getProject);
        SearchScope searchScope = parameters.getScope();
        if (searchScope instanceof LocalSearchScope && JavaOverridingMethodsSearcher.isJavaOnlyScope(files = ((LocalSearchScope)searchScope).getVirtualFiles())) {
            return JavaOverridingMethodsSearcher.processLocalScope((LocalSearchScope)searchScope, method, project, consumer);
        }
        Iterable<PsiMethod> cached = HighlightingCaches.getInstance((Project)project).OVERRIDING_METHODS.get(method);
        if (cached == null) {
            cached = JavaOverridingMethodsSearcher.compute(method, project);
            if (ReadAction.compute(method::isPhysical).booleanValue()) {
                HighlightingCaches.getInstance((Project)project).OVERRIDING_METHODS.put(method, cached);
            }
        }
        for (PsiMethod subMethod : cached) {
            ProgressManager.checkCanceled();
            if (!ReadAction.compute(() -> PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)subMethod)).booleanValue() || consumer.process(subMethod) && parameters.isCheckDeep()) continue;
            return false;
        }
        return true;
    }

    static boolean isJavaOnlyScope(@NotNull VirtualFile[] files) {
        if (files == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(2);
        }
        return Arrays.stream(files).allMatch(file -> file.getFileType() == JavaFileType.INSTANCE);
    }

    private static boolean processLocalScope(@NotNull LocalSearchScope searchScope, final @NotNull PsiMethod method, final @NotNull Project project, final @NotNull Processor<PsiMethod> consumer) {
        if (searchScope == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(3);
        }
        if (method == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(6);
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final PsiClass methodContainingClass = ReadAction.compute(method::getContainingClass);
        if (methodContainingClass == null) {
            return true;
        }
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept(new JavaRecursiveElementVisitor(){

                            @Override
                            public void visitClass(PsiClass candidate) {
                                PsiMethod overridingMethod;
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                PsiMethod psiMethod = overridingMethod = candidate.isInheritor(methodContainingClass, true) ? JavaOverridingMethodsSearcher.findOverridingMethod(candidate, method, methodContainingClass) : null;
                                if (overridingMethod != null && !consumer.process(overridingMethod)) {
                                    success[0] = false;
                                } else {
                                    super.visitClass(candidate);
                                }
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    @NotNull
    private static Iterable<PsiMethod> compute(@NotNull PsiMethod method, @NotNull Project project) {
        if (method == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(8);
        }
        Application application = ApplicationManager.getApplication();
        PsiClass containingClass = application.runReadAction(method::getContainingClass);
        assert (containingClass != null);
        LinkedHashSet<PsiMethod> result2 = new LinkedHashSet<PsiMethod>();
        Processor<PsiClass> inheritorsProcessor = inheritor -> {
            PsiMethod found;
            if (method == null) {
                JavaOverridingMethodsSearcher.$$$reportNull$$$0(19);
            }
            if ((found = application.runReadAction(() -> {
                if (method == null) {
                    JavaOverridingMethodsSearcher.$$$reportNull$$$0(20);
                }
                return JavaOverridingMethodsSearcher.findOverridingMethod(inheritor, method, containingClass);
            })) != null) {
                result2.add(found);
            }
            return true;
        };
        GlobalSearchScope allScope = GlobalSearchScope.allScope(project);
        boolean success = ClassInheritorsSearch.search(containingClass, allScope, true).forEach(inheritorsProcessor);
        assert (success);
        LinkedHashSet<PsiMethod> linkedHashSet = result2;
        if (linkedHashSet == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @Nullable
    public static PsiMethod findOverridingMethod(@NotNull PsiClass inheritor, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        MethodSignature signature;
        PsiMethod derived;
        PsiClass superClass;
        PsiMethod found;
        String name;
        if (inheritor == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(10);
        }
        if (method == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(11);
        }
        if (methodContainingClass == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(12);
        }
        if (inheritor.findMethodsByName(name = method.getName(), false).length > 0 && (found = MethodSignatureUtil.findMethodBySuperSignature(inheritor, JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method), false)) != null && JavaOverridingMethodsSearcher.isAcceptable(found, inheritor, method, methodContainingClass)) {
            return found;
        }
        if (methodContainingClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(methodContainingClass, true) && superClass.findMethodsByName(name, true).length > 0 && (derived = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived(inheritor, superClass, signature = JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method), true)) != null && JavaOverridingMethodsSearcher.isAcceptable(derived, inheritor, method, methodContainingClass)) {
            return derived;
        }
        return null;
    }

    @NotNull
    private static MethodSignature getSuperSignature(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method) {
        PsiSubstitutor substitutor;
        if (parentClass == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(13);
        }
        MethodSignature methodSignature = method.getSignature((substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(parentClass, inheritor, PsiSubstitutor.EMPTY, null)) != null ? substitutor : PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(14);
        }
        return methodSignature;
    }

    private static boolean isAcceptable(@NotNull PsiMethod found, @NotNull PsiClass foundContainingClass, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        if (found == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(15);
        }
        if (foundContainingClass == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(16);
        }
        if (method == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(17);
        }
        if (methodContainingClass == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(18);
        }
        return !found.hasModifierProperty("static") && (!method.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance(found.getProject()).arePackagesTheSame(methodContainingClass, foundContainingClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritor";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContainingClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundContainingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isJavaOnlyScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processLocalScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 9: 
            case 14: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOverridingMethod";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuperSignature";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$compute$3";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

