/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.highlighter.JShellFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JShellLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiJShellFile;
import com.intellij.psi.PsiJShellHolderMethod;
import com.intellij.psi.PsiJShellRootClass;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiJavaFileBaseImpl;
import com.intellij.psi.impl.source.tree.JShellElementType;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JShellFileImpl
extends PsiJavaFileBaseImpl
implements PsiJShellFile {
    private static final Condition<PsiElement> EXECUTABLE_PREDICATE = elem -> elem != null && !(elem instanceof PsiWhiteSpace) && !(elem instanceof PsiEmptyStatement) && !(elem instanceof PsiComment);

    public JShellFileImpl(FileViewProvider viewProvider) {
        super(JShellElementType.FILE, JShellElementType.FILE, viewProvider);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JShellFileImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JShellFileImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JShellFileImpl.$$$reportNull$$$0(2);
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JShellLanguage jShellLanguage = JShellLanguage.INSTANCE;
        if (jShellLanguage == null) {
            JShellFileImpl.$$$reportNull$$$0(3);
        }
        return jShellLanguage;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JShellFileType jShellFileType = JShellFileType.INSTANCE;
        if (jShellFileType == null) {
            JShellFileImpl.$$$reportNull$$$0(4);
        }
        return jShellFileType;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isPhysical();
    }

    @Override
    public Collection<PsiElement> getExecutableSnippets() {
        SmartList<PsiElement> result2 = new SmartList<PsiElement>();
        JShellFileImpl.collectExecutableSnippets(this, result2);
        return result2;
    }

    private static void collectExecutableSnippets(PsiElement container, Collection<PsiElement> result2) {
        for (PsiElement child = container.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiJShellRootClass) {
                JShellFileImpl.collectExecutableSnippets(child, result2);
                continue;
            }
            if (!JShellFileImpl.isExecutable(child)) continue;
            result2.add(child);
        }
    }

    private static boolean isExecutable(PsiElement element) {
        if (element instanceof PsiJShellHolderMethod) {
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!EXECUTABLE_PREDICATE.value(child)) continue;
                return true;
            }
            return false;
        }
        return EXECUTABLE_PREDICATE.value(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/JShellFileImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/JShellFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

