/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldImpl
extends JavaStubPsiElement<PsiFieldStub>
implements PsiField,
PsiVariableEx,
Queryable {
    private volatile Reference<PsiType> myCachedType;

    public PsiFieldImpl(PsiFieldStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.FIELD);
    }

    protected PsiFieldImpl(PsiFieldStub stub, IStubElementType type) {
        super(stub, type);
    }

    public PsiFieldImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    private void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiFieldImpl clone = (PsiFieldImpl)super.clone();
        clone.dropCached();
        return clone;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiFieldImpl.$$$reportNull$$$0(0);
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            PsiFieldImpl.$$$reportNull$$$0(1);
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public String getName() {
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                PsiFieldImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            PsiFieldImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiFieldImpl.$$$reportNull$$$0(4);
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            PsiType type = SoftReference.dereference(this.myCachedType);
            if (type == null) {
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                type = JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createTypeFromText(typeText, this);
                type = JavaSharedImplUtil.applyAnnotations(type, this.getModifierList());
                this.myCachedType = new SoftReference<PsiType>(type);
            }
            PsiType psiType = type;
            if (psiType == null) {
                PsiFieldImpl.$$$reportNull$$$0(5);
            }
            return psiType;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        assert (typeElement != null) : Arrays.toString(this.getChildren());
        PsiType psiType = JavaSharedImplUtil.getType(typeElement, this.getNameIdentifier());
        if (psiType == null) {
            PsiFieldImpl.$$$reportNull$$$0(6);
        }
        return psiType;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField != this) {
            return firstField.getTypeElement();
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList selfModifierList = this.getSelfModifierList();
        if (selfModifierList != null) {
            PsiModifierList psiModifierList = selfModifierList;
            if (psiModifierList == null) {
                PsiFieldImpl.$$$reportNull$$$0(7);
            }
            return psiModifierList;
        }
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField == this) {
            if (!this.isValid()) {
                throw new PsiInvalidElementAccessException(this);
            }
            PsiField lastResort = this.findFirstFieldByTree();
            if (lastResort == this) {
                throw new IllegalStateException("Missing modifier list for sequence of fields: '" + this.getText() + "'");
            }
            firstField = lastResort;
        }
        PsiModifierList psiModifierList = firstField.getModifierList();
        if (psiModifierList == null) {
            PsiFieldImpl.$$$reportNull$$$0(8);
        }
        return psiModifierList;
    }

    @Nullable
    private PsiModifierList getSelfModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            PsiFieldImpl.$$$reportNull$$$0(9);
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    private PsiField findFirstFieldInDeclaration() {
        if (this.getSelfModifierList() != null) {
            return this;
        }
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            List<StubElement> siblings = stub.getParentStub().getChildrenStubs();
            int idx = siblings.indexOf(stub);
            assert (idx >= 0);
            for (int i = idx - 1; i >= 0 && siblings.get(i) instanceof PsiFieldStub; --i) {
                PsiFieldStub prevField = (PsiFieldStub)siblings.get(i);
                PsiFieldImpl prevFieldPsi = (PsiFieldImpl)prevField.getPsi();
                if (prevFieldPsi.getSelfModifierList() == null) continue;
                return prevFieldPsi;
            }
        }
        return this.findFirstFieldByTree();
    }

    private PsiField findFirstFieldByTree() {
        CompositeElement treeElement = this.getNode();
        ASTNode modifierList = treeElement.findChildByRole(8);
        if (modifierList == null) {
            ASTNode prevField;
            for (prevField = treeElement.getTreePrev(); prevField != null && prevField.getElementType() != JavaElementType.FIELD; prevField = prevField.getTreePrev()) {
            }
            if (prevField == null) {
                return this;
            }
            return ((PsiFieldImpl)SourceTreeToPsiMap.treeElementToPsi(prevField)).findFirstFieldInDeclaration();
        }
        return this;
    }

    @Override
    public PsiExpression getInitializer() {
        return (PsiExpression)this.getNode().findChildByRoleAsPsiElement(21);
    }

    public PsiExpression getDetachedInitializer() {
        PsiExpression initializer;
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub == null) {
            initializer = this.getInitializer();
        } else {
            String initializerText = stub.getInitializerText();
            if (StringUtil.isEmpty(initializerText) || ";INITIALIZER_NOT_STORED;".equals(initializerText) || ";INITIALIZER_TOO_LONG;".equals(initializerText)) {
                initializer = this.getInitializer();
            } else {
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
                initializer = parserFacade.createExpressionFromText(initializerText, this);
                ((LightVirtualFile)initializer.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            }
        }
        return initializer;
    }

    @Override
    public boolean hasInitializer() {
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            return stub.getInitializerText() != null;
        }
        return this.getInitializer() != null;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Nullable
    private Object _computeConstantValue(Set<PsiVariable> visitedVars) {
        PsiType type = this.getType();
        if (!(type instanceof PsiPrimitiveType) && !type.equalsToText("java.lang.String")) {
            return null;
        }
        PsiExpression initializer = this.getDetachedInitializer();
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, type, visitedVars);
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue(new HashSet<PsiVariable>(2));
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        return JavaResolveCache.getInstance(this.getProject()).computeConstantValueWithCaching(this, OurConstValueComputer.INSTANCE, visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        return PsiFieldImpl.isFieldDeprecated(this, (PsiFieldStub)this.getGreenStub());
    }

    static boolean isFieldDeprecated(@NotNull PsiField field, @Nullable PsiFieldStub stub) {
        if (field == null) {
            PsiFieldImpl.$$$reportNull$$$0(10);
        }
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(field);
        }
        return PsiImplUtil.isDeprecatedByDocTag(field) || PsiImplUtil.isDeprecatedByAnnotation(field);
    }

    @Override
    public PsiDocComment getDocComment() {
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        CompositeElement treeElement = this.getNode();
        if (this.getTypeElement() != null) {
            PsiElement element = treeElement.findChildByRoleAsPsiElement(7);
            return element instanceof PsiDocComment ? (PsiDocComment)element : null;
        }
        ASTNode prevField = treeElement.getTreePrev();
        while (prevField.getElementType() != JavaElementType.FIELD) {
            prevField = prevField.getTreePrev();
        }
        return ((PsiField)SourceTreeToPsiMap.treeElementToPsi(prevField)).getDocComment();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        ASTNode nextField;
        ASTNode comma;
        CheckUtil.checkWritable(this);
        PsiTypeElement type = this.getTypeElement();
        PsiModifierList modifierList = this.getModifierList();
        ASTNode field = SourceTreeToPsiMap.psiElementToTree(type.getParent());
        while ((comma = PsiImplUtil.skipWhitespaceAndComments(field.getTreeNext())) != null && comma.getElementType() == JavaTokenType.COMMA && (nextField = PsiImplUtil.skipWhitespaceAndComments(comma.getTreeNext())) != null && nextField.getElementType() == JavaElementType.FIELD) {
            LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, null, this.getManager());
            CodeEditUtil.addChild(field, semicolon, null);
            CodeEditUtil.removeChild(comma.getTreeParent(), comma);
            PsiElement typeClone = type.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(typeClone), nextField.getFirstChildNode());
            PsiElement modifierListClone = modifierList.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(modifierListClone), nextField.getFirstChildNode());
            field = nextField;
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiFieldImpl.$$$reportNull$$$0(11);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiFieldImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            PsiFieldImpl.$$$reportNull$$$0(13);
        }
        if (place == null) {
            PsiFieldImpl.$$$reportNull$$$0(14);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiField originalField;
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && (originalField = ((PsiClass)containingClass.getOriginalElement()).findFieldByName(this.getName(), false)) != null) {
            return originalField;
        }
        return this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            PsiFieldImpl.$$$reportNull$$$0(15);
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            PsiFieldImpl.$$$reportNull$$$0(16);
        }
        info.put("fieldName", this.getName());
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiFieldImpl";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiFieldImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFieldDeprecated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OurConstValueComputer
    implements JavaResolveCache.ConstValueComputer {
        private static final OurConstValueComputer INSTANCE = new OurConstValueComputer();

        private OurConstValueComputer() {
        }

        @Override
        public Object execute(@NotNull PsiVariable variable, Set<PsiVariable> visitedVars) {
            if (variable == null) {
                OurConstValueComputer.$$$reportNull$$$0(0);
            }
            return ((PsiFieldImpl)variable)._computeConstantValue(visitedVars);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/impl/source/PsiFieldImpl$OurConstValueComputer", "execute"));
        }
    }
}

