/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.DumbAwareSearchParameters;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("com.intellij.referencesSearch");
    private static final ReferencesSearch INSTANCE = new ReferencesSearch();

    private ReferencesSearch() {
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(0);
        }
        Query<PsiReference> query = ReferencesSearch.search(element, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(element)), false);
        if (query == null) {
            ReferencesSearch.$$$reportNull$$$0(1);
        }
        return query;
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            ReferencesSearch.$$$reportNull$$$0(3);
        }
        Query<PsiReference> query = ReferencesSearch.search(element, searchScope, false);
        if (query == null) {
            ReferencesSearch.$$$reportNull$$$0(4);
        }
        return query;
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            ReferencesSearch.$$$reportNull$$$0(6);
        }
        Query<PsiReference> query = ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope));
        if (query == null) {
            ReferencesSearch.$$$reportNull$$$0(7);
        }
        return query;
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            ReferencesSearch.$$$reportNull$$$0(8);
        }
        Query<PsiReference> result2 = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            Query<PsiReference> query = ReferencesSearch.uniqueResults(result2);
            if (query == null) {
                ReferencesSearch.$$$reportNull$$$0(9);
            }
            return query;
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        PsiElement element = parameters.getElementToSearch();
        Query<PsiReference> query = ReferencesSearch.uniqueResults(new MergeQuery<PsiReference>(result2, new SearchRequestQuery(PsiUtilCore.getProjectInReadAction(element), requests)));
        if (query == null) {
            ReferencesSearch.$$$reportNull$$$0(10);
        }
        return query;
    }

    @NotNull
    private static Query<PsiReference> uniqueResults(@NotNull Query<PsiReference> composite) {
        if (composite == null) {
            ReferencesSearch.$$$reportNull$$$0(11);
        }
        UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResultsQuery = new UniqueResultsQuery<PsiReference, ReferenceDescriptor>(composite, ContainerUtil.canonicalStrategy(), ReferenceDescriptor.MAPPER);
        if (uniqueResultsQuery == null) {
            ReferencesSearch.$$$reportNull$$$0(12);
        }
        return uniqueResultsQuery;
    }

    public static void searchOptimized(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope, @NotNull SearchRequestCollector collector, @NotNull Processor<PsiReference> processor) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(13);
        }
        if (searchScope == null) {
            ReferencesSearch.$$$reportNull$$$0(14);
        }
        if (collector == null) {
            ReferencesSearch.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            ReferencesSearch.$$$reportNull$$$0(16);
        }
        ReferencesSearch.searchOptimized(element, searchScope, ignoreAccessScope, collector, false, (psiReference, collector1) -> {
            if (processor == null) {
                ReferencesSearch.$$$reportNull$$$0(21);
            }
            return processor.process((PsiReference)psiReference);
        });
    }

    public static void searchOptimized(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope, @NotNull SearchRequestCollector collector, boolean inReadAction, @NotNull PairProcessor<PsiReference, SearchRequestCollector> processor) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            ReferencesSearch.$$$reportNull$$$0(18);
        }
        if (collector == null) {
            ReferencesSearch.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            ReferencesSearch.$$$reportNull$$$0(20);
        }
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        Query<PsiReference> query = ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope, nested));
        collector.searchQuery(new QuerySearchRequest(query, nested, inReadAction, processor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/ReferencesSearch";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/ReferencesSearch";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "uniqueResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "uniqueResults";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "searchOptimized";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchOptimized$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SearchParameters
    implements DumbAwareSearchParameters {
        private final PsiElement myElementToSearch;
        private final SearchScope myScope;
        private volatile SearchScope myEffectiveScope;
        private final boolean myIgnoreAccessScope;
        private final SearchRequestCollector myOptimizer;
        private final Project myProject;
        private final boolean isSharedOptimizer;

        public SearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope, boolean ignoreAccessScope, @Nullable SearchRequestCollector optimizer) {
            if (elementToSearch == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myElementToSearch = elementToSearch;
            this.myScope = scope;
            this.myIgnoreAccessScope = ignoreAccessScope;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer == null ? new SearchRequestCollector(new SearchSession()) : optimizer;
            this.myProject = PsiUtilCore.getProjectInReadAction(elementToSearch);
        }

        public SearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope, boolean ignoreAccessScope) {
            if (elementToSearch == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            this(elementToSearch, scope, ignoreAccessScope, null);
        }

        @Override
        public boolean isQueryValid() {
            return this.myElementToSearch.isValid();
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            return project;
        }

        @NotNull
        public PsiElement getElementToSearch() {
            PsiElement psiElement = this.myElementToSearch;
            if (psiElement == null) {
                SearchParameters.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated
        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(6);
            }
            return searchScope;
        }

        public boolean isIgnoreAccessScope() {
            return this.myIgnoreAccessScope;
        }

        @NotNull
        public SearchRequestCollector getOptimizer() {
            SearchRequestCollector searchRequestCollector = this.myOptimizer;
            if (searchRequestCollector == null) {
                SearchParameters.$$$reportNull$$$0(7);
            }
            return searchRequestCollector;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            if (this.myIgnoreAccessScope) {
                SearchScope searchScope = this.myScope;
                if (searchScope == null) {
                    SearchParameters.$$$reportNull$$$0(8);
                }
                return searchScope;
            }
            SearchScope scope = this.myEffectiveScope;
            if (scope == null) {
                SearchScope useScope = PsiSearchHelper.SERVICE.getInstance(this.myElementToSearch.getProject()).getUseScope(this.myElementToSearch);
                this.myEffectiveScope = scope = this.myScope.intersectWith(useScope);
            }
            SearchScope searchScope = scope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(9);
            }
            return searchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToSearch";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementToSearch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptimizer";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEffectiveSearchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

