/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class IntArrayList
implements Cloneable {
    private int[] myData;
    private int mySize;

    public IntArrayList(int initialCapacity) {
        this.myData = new int[initialCapacity];
    }

    public IntArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void fill(int fromIndex, int toIndex, int value) {
        if (toIndex > this.mySize) {
            this.ensureCapacity(toIndex);
            this.mySize = toIndex;
        }
        Arrays.fill(this.myData, fromIndex, toIndex, value);
    }

    public void add(@NotNull int[] values) {
        if (values == null) {
            IntArrayList.$$$reportNull$$$0(0);
        }
        int length = values.length;
        this.ensureCapacity(this.mySize + length);
        System.arraycopy(values, 0, this.myData, this.mySize, length);
        this.mySize += length;
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(int elem) {
        return this.indexOf(elem, 0, this.mySize);
    }

    public int indexOf(int elem, int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex || endIndex > this.mySize) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + "; endIndex: " + endIndex + "; mySize: " + this.mySize);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int elem) {
        for (int i = this.mySize - 1; i >= 0; --i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            IntArrayList v = (IntArrayList)super.clone();
            v.myData = this.toArray();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @NotNull
    public int[] toArray() {
        int[] nArray = this.toArray(0, this.mySize);
        if (nArray == null) {
            IntArrayList.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    @NotNull
    public int[] toArray(@NotNull int[] a) {
        if (a == null) {
            IntArrayList.$$$reportNull$$$0(2);
        }
        if (a.length < this.mySize) {
            a = new int[this.mySize];
        }
        System.arraycopy(this.myData, 0, a, 0, this.mySize);
        if (a == null) {
            IntArrayList.$$$reportNull$$$0(3);
        }
        return a;
    }

    @NotNull
    public int[] toArray(int startIndex, int length) {
        int[] result2 = new int[length];
        System.arraycopy(this.myData, startIndex, result2, 0, length);
        if (result2 == null) {
            IntArrayList.$$$reportNull$$$0(4);
        }
        return result2;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public int getQuick(int index) {
        return this.myData[index];
    }

    public int set(int index, int element) {
        this.checkRange(index);
        int oldValue = this.myData[index];
        this.myData[index] = element;
        return oldValue;
    }

    public void setQuick(int index, int element) {
        this.myData[index] = element;
    }

    public void add(int o) {
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = o;
    }

    public void add(int index, int element) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
        this.myData[index] = element;
        ++this.mySize;
    }

    public int remove(int index) {
        this.checkRange(index);
        int oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    public void copyRange(int fromIndex, int length, int toIndex) {
        if (length < 0 || fromIndex < 0 || fromIndex + length > this.mySize || toIndex < 0 || toIndex + length > this.mySize) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; length: " + length + "; toIndex: " + toIndex + "; mySize: " + this.mySize);
        }
        System.arraycopy(this.myData, fromIndex, this.myData, toIndex, length);
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/IntArrayList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/IntArrayList";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

