/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.classmetrics.CyclomaticComplexityVisitor;
import org.jetbrains.annotations.NotNull;

public class AnonymousClassComplexityInspectionBase
extends ClassMetricInspection {
    private static final int DEFAULT_COMPLEXITY_LIMIT = 3;

    @Override
    @NotNull
    public String getID() {
        if ("OverlyComplexAnonymousInnerClass" == null) {
            AnonymousClassComplexityInspectionBase.$$$reportNull$$$0(0);
        }
        return "OverlyComplexAnonymousInnerClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.complex.anonymous.inner.class.display.name", new Object[0]);
        if (string == null) {
            AnonymousClassComplexityInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 3;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("cyclomatic.complexity.limit.option", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer totalComplexity = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("overly.complex.anonymous.inner.class.problem.descriptor", totalComplexity);
        if (string == null) {
            AnonymousClassComplexityInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassComplexityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/AnonymousClassComplexityInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassComplexityVisitor
    extends BaseInspectionVisitor {
        private ClassComplexityVisitor() {
        }

        @Override
        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
            if (aClass == null) {
                ClassComplexityVisitor.$$$reportNull$$$0(0);
            }
            if (aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            int totalComplexity = this.calculateTotalComplexity(aClass);
            if (totalComplexity <= AnonymousClassComplexityInspectionBase.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, totalComplexity);
        }

        private int calculateTotalComplexity(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            int totalComplexity = this.calculateComplexityForMethods(methods);
            return totalComplexity += this.calculateInitializerComplexity(aClass);
        }

        private int calculateInitializerComplexity(PsiClass aClass) {
            PsiClassInitializer[] initializers;
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            int complexity = 0;
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                visitor.reset();
                initializer.accept(visitor);
                complexity += visitor.getComplexity();
            }
            return complexity;
        }

        private int calculateComplexityForMethods(PsiMethod[] methods) {
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            int complexity = 0;
            for (PsiMethod method : methods) {
                visitor.reset();
                method.accept(visitor);
                complexity += visitor.getComplexity();
            }
            return complexity;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/AnonymousClassComplexityInspectionBase$ClassComplexityVisitor", "visitAnonymousClass"));
        }
    }
}

