/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLabelOnContinueStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.label.on.continue.statement.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryLabelOnContinueStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.label.on.continue.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryLabelOnContinueStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryLabelOnContinueStatementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLabelOnContinueStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/UnnecessaryLabelOnContinueStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryLabelOnContinueStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLabelOnContinueStatementVisitor() {
        }

        @Override
        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            PsiIdentifier labelIdentifier;
            if (statement == null) {
                UnnecessaryLabelOnContinueStatementVisitor.$$$reportNull$$$0(0);
            }
            if ((labelIdentifier = statement.getLabelIdentifier()) == null) {
                return;
            }
            String labelText = labelIdentifier.getText();
            if (labelText == null || labelText.length() == 0) {
                return;
            }
            PsiStatement exitedStatement = statement.findContinuedStatement();
            if (exitedStatement == null) {
                return;
            }
            PsiStatement labelEnabledParent = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiForStatement.class, PsiDoWhileStatement.class, PsiForeachStatement.class, PsiWhileStatement.class, PsiSwitchStatement.class);
            if (labelEnabledParent == null) {
                return;
            }
            if (!exitedStatement.equals(labelEnabledParent)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryLabelOnContinueStatementInspection$UnnecessaryLabelOnContinueStatementVisitor", "visitContinueStatement"));
        }
    }

    private static class UnnecessaryLabelOnContinueStatementFix
    extends InspectionGadgetsFix {
        private UnnecessaryLabelOnContinueStatementFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.label.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryLabelOnContinueStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor.getPsiElement();
            PsiContinueStatement continueStatement = (PsiContinueStatement)continueKeywordElement.getParent();
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            labelIdentifier.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryLabelOnContinueStatementInspection$UnnecessaryLabelOnContinueStatementFix", "getFamilyName"));
        }
    }
}

