/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.JUnitRuleInspection;
import com.siyeh.ig.junit.MakePublicStaticFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitDatapointInspection
extends BaseInspection {
    public static final String DATAPOINT_FQN = "org.junit.experimental.theories.DataPoint";

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit.datapoint.display.name", new Object[0]);
        if (string == null) {
            JUnitDatapointInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            JUnitDatapointInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return infos.length > 1 ? new MakePublicStaticFix((String)infos[1], true) : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitMethod(PsiMethod method) {
                this.visitMember(method, "method");
            }

            @Override
            public void visitField(PsiField field) {
                this.visitMember(field, "field");
            }

            private <T extends PsiMember & PsiNameIdentifierOwner> void visitMember(T member, String memberDescription) {
                String errorMessage;
                boolean dataPointAnnotated = AnnotationUtil.isAnnotated(member, JUnitDatapointInspection.DATAPOINT_FQN, 0);
                if (dataPointAnnotated && (errorMessage = JUnitRuleInspection.getPublicStaticErrorMessage(member, false, true)) != null) {
                    PsiElement identifier = ((PsiNameIdentifierOwner)member).getNameIdentifier();
                    this.registerError(identifier != null ? identifier : member, InspectionGadgetsBundle.message("junit.datapoint.problem.descriptor", errorMessage, StringUtil.capitalize(memberDescription)), "Make " + memberDescription + " " + errorMessage, JUnitDatapointInspection.DATAPOINT_FQN);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/JUnitDatapointInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

