/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class BigDecimalEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("big.decimal.equals.display.name", new Object[0]);
        if (string == null) {
            BigDecimalEqualsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("big.decimal.equals.problem.descriptor", new Object[0]);
        if (string == null) {
            BigDecimalEqualsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new BigDecimalEqualsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/BigDecimalEqualsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class BigDecimalEqualsVisitor
    extends BaseInspectionVisitor {
        private BigDecimalEqualsVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                BigDecimalEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isEqualsCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression arg = arguments[0];
            if (!ExpressionUtils.hasType(arg, "java.math.BigDecimal")) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!ExpressionUtils.hasType(qualifier, "java.math.BigDecimal")) {
                return;
            }
            PsiElement context = expression.getParent();
            if (context instanceof PsiExpressionStatement) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/BigDecimalEqualsInspection$BigDecimalEqualsVisitor", "visitMethodCallExpression"));
        }
    }

    private static class BigDecimalEqualsFix
    extends InspectionGadgetsFix {
        private BigDecimalEqualsFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("big.decimal.equals.replace.quickfix", new Object[0]);
            if (string == null) {
                BigDecimalEqualsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            assert (expression != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression.getParent();
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String qualifierText = commentTracker.markUnchanged(qualifier).getText();
            assert (call != null);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            String argText = commentTracker.markUnchanged(args[0]).getText();
            PsiReplacementUtil.replaceExpression(call, qualifierText + ".compareTo(" + argText + ")==0", commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/BigDecimalEqualsInspection$BigDecimalEqualsFix", "getFamilyName"));
        }
    }
}

