/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ConstructionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionUtils {
    @NonNls
    private static final Set<String> s_allCollectionClassesAndInterfaces;
    @NonNls
    private static final Map<String, String> s_interfaceForCollection;

    private CollectionUtils() {
    }

    public static Set<String> getAllCollectionNames() {
        return s_allCollectionClassesAndInterfaces;
    }

    @Contract(value="null -> false")
    public static boolean isConcreteCollectionClass(@Nullable PsiType type) {
        return CollectionUtils.isConcreteCollectionClass(PsiUtil.resolveClassInClassTypeOnly(type));
    }

    @Contract(value="null -> false")
    public static boolean isConcreteCollectionClass(PsiClass aClass) {
        if (aClass == null || aClass.isEnum() || aClass.isInterface() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (!InheritanceUtil.isInheritor(aClass, "java.util.Collection") && !InheritanceUtil.isInheritor(aClass, "java.util.Map")) {
            return false;
        }
        String name = aClass.getQualifiedName();
        return name != null && name.startsWith("java.util.");
    }

    public static boolean isCollectionClassOrInterface(@Nullable PsiType type) {
        PsiClass resolved = PsiUtil.resolveClassInClassTypeOnly(type);
        if (resolved == null) {
            return false;
        }
        return InheritanceUtil.isInheritor(resolved, "java.util.Collection") || InheritanceUtil.isInheritor(resolved, "java.util.Map") || InheritanceUtil.isInheritor(resolved, "com.google.common.collect.Multimap") || InheritanceUtil.isInheritor(resolved, "com.google.common.collect.Table");
    }

    public static boolean isCollectionClassOrInterface(PsiClass aClass) {
        return CollectionUtils.isCollectionClassOrInterface(aClass, new HashSet<PsiClass>());
    }

    private static boolean isCollectionClassOrInterface(PsiClass aClass, Set<PsiClass> visitedClasses) {
        PsiClass[] supers;
        if (!visitedClasses.add(aClass)) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (s_allCollectionClassesAndInterfaces.contains(className)) {
            return true;
        }
        for (PsiClass aSuper : supers = aClass.getSupers()) {
            if (!CollectionUtils.isCollectionClassOrInterface(aSuper, visitedClasses)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeakCollectionClass(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        String typeText = type.getCanonicalText();
        return "java.util.WeakHashMap".equals(typeText);
    }

    public static boolean isConstantEmptyArray(@NotNull PsiField field) {
        if (field == null) {
            CollectionUtils.$$$reportNull$$$0(0);
        }
        if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final")) {
            return false;
        }
        return CollectionUtils.isEmptyArray(field);
    }

    public static boolean isEmptyArray(PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer;
            PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
            return initializers.length == 0;
        }
        return ConstructionUtils.isEmptyArrayInitializer(initializer);
    }

    public static String getInterfaceForClass(String name) {
        int parameterStart = name.indexOf(60);
        String baseName = parameterStart >= 0 ? name.substring(0, parameterStart).trim() : name;
        return s_interfaceForCollection.get(baseName);
    }

    static {
        s_interfaceForCollection = new HashMap<String, String>();
        HashSet<String> allCollectionClassesAndInterfaces = new HashSet<String>();
        allCollectionClassesAndInterfaces.add("java.util.AbstractCollection");
        allCollectionClassesAndInterfaces.add("java.util.AbstractList");
        allCollectionClassesAndInterfaces.add("java.util.AbstractMap");
        allCollectionClassesAndInterfaces.add("java.util.AbstractQueue");
        allCollectionClassesAndInterfaces.add("java.util.AbstractSequentialList");
        allCollectionClassesAndInterfaces.add("java.util.AbstractSet");
        allCollectionClassesAndInterfaces.add("java.util.ArrayList");
        allCollectionClassesAndInterfaces.add("java.util.ArrayDeque");
        allCollectionClassesAndInterfaces.add("java.util.Collection");
        allCollectionClassesAndInterfaces.add("java.util.Dictionary");
        allCollectionClassesAndInterfaces.add("java.util.EnumMap");
        allCollectionClassesAndInterfaces.add("java.util.HashMap");
        allCollectionClassesAndInterfaces.add("java.util.HashSet");
        allCollectionClassesAndInterfaces.add("java.util.Hashtable");
        allCollectionClassesAndInterfaces.add("java.util.IdentityHashMap");
        allCollectionClassesAndInterfaces.add("java.util.LinkedHashMap");
        allCollectionClassesAndInterfaces.add("java.util.LinkedHashSet");
        allCollectionClassesAndInterfaces.add("java.util.LinkedList");
        allCollectionClassesAndInterfaces.add("java.util.List");
        allCollectionClassesAndInterfaces.add("java.util.Map");
        allCollectionClassesAndInterfaces.add("java.util.PriorityQueue");
        allCollectionClassesAndInterfaces.add("java.util.Queue");
        allCollectionClassesAndInterfaces.add("java.util.Set");
        allCollectionClassesAndInterfaces.add("java.util.SortedMap");
        allCollectionClassesAndInterfaces.add("java.util.SortedSet");
        allCollectionClassesAndInterfaces.add("java.util.Stack");
        allCollectionClassesAndInterfaces.add("java.util.TreeMap");
        allCollectionClassesAndInterfaces.add("java.util.TreeSet");
        allCollectionClassesAndInterfaces.add("java.util.Vector");
        allCollectionClassesAndInterfaces.add("java.util.WeakHashMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ArrayBlockingQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.BlockingDeque");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.BlockingQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentHashMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentLinkedDeque");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentLinkedQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentNavigableMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentSkipListMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentSkipListSet");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.CopyOnWriteArrayList");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.CopyOnWriteArraySet");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.DelayQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.LinkedBlockingDeque");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.LinkedBlockingQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.LinkedTransferQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.PriorityBlockingQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.SynchronousQueue");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.ArrayList");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Collection");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.HashMap");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.HashSet");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Hashtable");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.LinkedList");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.List");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Map");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Set");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.SortedMap");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.SortedSet");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.TreeMap");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.TreeSet");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Vector");
        s_allCollectionClassesAndInterfaces = Collections.unmodifiableSet(allCollectionClassesAndInterfaces);
        s_interfaceForCollection.put("ArrayList", "List");
        s_interfaceForCollection.put("EnumMap", "Map");
        s_interfaceForCollection.put("EnumSet", "Set");
        s_interfaceForCollection.put("HashMap", "Map");
        s_interfaceForCollection.put("HashSet", "Set");
        s_interfaceForCollection.put("Hashtable", "Map");
        s_interfaceForCollection.put("IdentityHashMap", "Map");
        s_interfaceForCollection.put("LinkedHashMap", "Map");
        s_interfaceForCollection.put("LinkedHashSet", "Set");
        s_interfaceForCollection.put("LinkedList", "List");
        s_interfaceForCollection.put("PriorityQueue", "Queue");
        s_interfaceForCollection.put("TreeMap", "Map");
        s_interfaceForCollection.put("TreeSet", "SortedSet");
        s_interfaceForCollection.put("Vector", "List");
        s_interfaceForCollection.put("WeakHashMap", "Map");
        s_interfaceForCollection.put("java.util.ArrayList", "java.util.List");
        s_interfaceForCollection.put("java.util.EnumMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.EnumSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.HashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.HashSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.Hashtable", "java.util.Map");
        s_interfaceForCollection.put("java.util.IdentityHashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.LinkedHashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.LinkedHashSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.LinkedList", "java.util.List");
        s_interfaceForCollection.put("java.util.PriorityQueue", "java.util.Queue");
        s_interfaceForCollection.put("java.util.TreeMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.TreeSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.Vector", "java.util.List");
        s_interfaceForCollection.put("java.util.WeakHashMap", "java.util.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.HashSet", "com.sun.java.util.collections.Set");
        s_interfaceForCollection.put("com.sun.java.util.collections.TreeSet", "com.sun.java.util.collections.Set");
        s_interfaceForCollection.put("com.sun.java.util.collections.Vector", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.ArrayList", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.LinkedList", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.TreeMap", "com.sun.java.util.collections.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.HashMap", "com.sun.java.util.collections.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.Hashtable", "com.sun.java.util.collections.Map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/psiutils/CollectionUtils", "isConstantEmptyArray"));
    }
}

