/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class VariableAssignedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final Collection<PsiVariable> variables;
    private final boolean recurseIntoClasses;
    private final boolean checkUnaryExpressions;
    private boolean assigned;
    private PsiElement excludedElement;

    public VariableAssignedVisitor(@NotNull Collection<PsiVariable> variables, boolean recurseIntoClasses) {
        if (variables == null) {
            VariableAssignedVisitor.$$$reportNull$$$0(0);
        }
        this.assigned = false;
        this.excludedElement = null;
        this.variables = variables;
        this.checkUnaryExpressions = true;
        this.recurseIntoClasses = recurseIntoClasses;
    }

    public VariableAssignedVisitor(@NotNull PsiVariable variable, boolean recurseIntoClasses) {
        if (variable == null) {
            VariableAssignedVisitor.$$$reportNull$$$0(1);
        }
        this.assigned = false;
        this.excludedElement = null;
        this.variables = Collections.singleton(variable);
        PsiType type = variable.getType();
        this.checkUnaryExpressions = TypeConversionUtil.isNumericType(type);
        this.recurseIntoClasses = recurseIntoClasses;
    }

    public VariableAssignedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            VariableAssignedVisitor.$$$reportNull$$$0(2);
        }
        this(variable, true);
    }

    public void setExcludedElement(PsiElement excludedElement) {
        this.excludedElement = excludedElement;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            VariableAssignedVisitor.$$$reportNull$$$0(3);
        }
        if (this.assigned || element == this.excludedElement) {
            return;
        }
        super.visitElement(element);
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            VariableAssignedVisitor.$$$reportNull$$$0(4);
        }
        if (this.assigned) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        for (PsiVariable variable : this.variables) {
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable)) continue;
            this.assigned = true;
            break;
        }
    }

    @Override
    public void visitClass(PsiClass aClass) {
        if (!this.recurseIntoClasses || this.assigned) {
            return;
        }
        super.visitClass(aClass);
    }

    @Override
    public void visitUnaryExpression(@NotNull PsiUnaryExpression prefixExpression) {
        if (prefixExpression == null) {
            VariableAssignedVisitor.$$$reportNull$$$0(5);
        }
        if (this.assigned) {
            return;
        }
        super.visitUnaryExpression(prefixExpression);
        if (!this.checkUnaryExpressions) {
            return;
        }
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = prefixExpression.getOperand();
        for (PsiVariable variable : this.variables) {
            if (!VariableAccessUtils.evaluatesToVariable(operand, variable)) continue;
            this.assigned = true;
            break;
        }
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariableAssignedVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

