/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryQualifierForThisInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryQualifierForThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message(infos[0] instanceof PsiThisExpression ? "unnecessary.qualifier.for.this.problem.descriptor" : "unnecessary.qualifier.for.super.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryQualifierForThisInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryQualifierForThisVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryQualifierForThisFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryQualifierForThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryQualifierForThisVisitor() {
        }

        @Override
        public void visitThisExpression(@NotNull PsiThisExpression thisExpression) {
            if (thisExpression == null) {
                UnnecessaryQualifierForThisVisitor.$$$reportNull$$$0(0);
            }
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement referent = qualifier.resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(thisExpression);
            if (containingClass == null || !containingClass.equals(referent)) {
                return;
            }
            this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, thisExpression);
        }

        @Override
        public void visitSuperExpression(PsiSuperExpression expression) {
            super.visitSuperExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement resolve = qualifier.resolve();
            if (!(resolve instanceof PsiClass)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiReferenceExpression) {
                PsiElement gParent = parent.getParent();
                PsiReferenceExpression copy = gParent instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)gParent.copy()).getMethodExpression() : (PsiReferenceExpression)parent.copy();
                PsiExpression copyQualifierExpression = copy.getQualifierExpression();
                assert (copyQualifierExpression != null);
                PsiReplacementUtil.replaceExpression(copyQualifierExpression, "super");
                if (copy.resolve() == ((PsiReferenceExpression)parent).resolve()) {
                    this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, expression);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisExpression", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisVisitor", "visitThisExpression"));
        }
    }

    private static class UnnecessaryQualifierForThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryQualifierForThisFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryQualifierForThisFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement qualifier = descriptor.getPsiElement();
            PsiElement parent = qualifier.getParent();
            CommentTracker tracker = new CommentTracker();
            if (parent instanceof PsiThisExpression) {
                PsiReplacementUtil.replaceExpression((PsiThisExpression)parent, "this", tracker);
            } else if (parent instanceof PsiSuperExpression) {
                PsiReplacementUtil.replaceExpression((PsiSuperExpression)parent, "super", tracker);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisFix", "getFamilyName"));
        }
    }
}

