/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.JavaResolveCache");
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final AtomicReference<ConcurrentMap<PsiExpression, PsiType>> myCalculatedTypes = new AtomicReference();
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapPhysical = new AtomicReference();
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapNonPhysical = new AtomicReference();
    private static final Object NULL = Key.create("NULL");

    public static JavaResolveCache getInstance(Project project) {
        return INSTANCE_KEY.getValue(project);
    }

    public JavaResolveCache(@Nullable(value="can be null in com.intellij.core.JavaCoreApplicationEnvironment.JavaCoreApplicationEnvironment") MessageBus messageBus) {
        if (messageBus != null) {
            messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

                @Override
                public void beforePsiChanged(boolean isPhysical) {
                    JavaResolveCache.this.clearCaches(isPhysical);
                }
            });
        }
    }

    private void clearCaches(boolean isPhysical) {
        this.myCalculatedTypes.set(null);
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.set(null);
        }
        this.myVarToConstValueMapNonPhysical.set(null);
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<T, PsiType> f) {
        PsiType type;
        if (expr == null) {
            JavaResolveCache.$$$reportNull$$$0(0);
        }
        if (f == null) {
            JavaResolveCache.$$$reportNull$$$0(1);
        }
        boolean isOverloadCheck = MethodCandidateInfo.isOverloadCheck() || LambdaUtil.isLambdaParameterCheck();
        boolean polyExpression = PsiPolyExpressionUtil.isPolyExpression(expr);
        ConcurrentMap<PsiExpression, PsiType> map = this.myCalculatedTypes.get();
        if (map == null) {
            map = ConcurrencyUtil.cacheOrGet(this.myCalculatedTypes, ContainerUtil.createConcurrentWeakKeySoftValueMap());
        }
        PsiType psiType = type = isOverloadCheck && polyExpression ? null : (PsiType)map.get(expr);
        if (type == null) {
            RecursionGuard.StackStamp dStackStamp = PsiDiamondType.ourDiamondGuard.markStack();
            type = f.fun(expr);
            if (!dStackStamp.mayCacheNow()) {
                return type;
            }
            if (isOverloadCheck && polyExpression) {
                return type;
            }
            if (type == null) {
                type = TypeConversionUtil.NULL_TYPE;
            }
            map.put(expr, type);
            if (type instanceof PsiClassReferenceType) {
                PsiClassType.ClassResolveResult result = ((PsiClassReferenceType)type).resolveGenerics();
                PsiClass psiClass = result.getElement();
                PsiType psiType2 = type = psiClass == null ? type : new PsiImmediateClassType(psiClass, result.getSubstitutor(), ((PsiClassReferenceType)type).getLanguageLevel(), type.getAnnotationProvider());
            }
        }
        if (!type.isValid()) {
            if (expr.isValid()) {
                PsiJavaCodeReferenceElement refInside = type instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type).getReference() : null;
                String typeinfo = type + " (" + type.getClass() + ")" + (refInside == null ? "" : "; ref inside: " + refInside + " (" + refInside.getClass() + ") valid:" + refInside.isValid());
                LOG.error("Type is invalid: " + typeinfo + "; expr: '" + expr + "' (" + expr.getClass() + ") is valid");
            } else {
                LOG.error("Expression: '" + expr + "' is invalid, must not be used for getType()");
            }
        }
        return type == TypeConversionUtil.NULL_TYPE ? null : type;
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        Object cached;
        boolean physical;
        AtomicReference<Map<PsiVariable, Object>> ref;
        Map map;
        if (variable == null) {
            JavaResolveCache.$$$reportNull$$$0(2);
        }
        if (computer == null) {
            JavaResolveCache.$$$reportNull$$$0(3);
        }
        if ((map = (ref = (physical = variable.isPhysical()) ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical).get()) == null) {
            map = ConcurrencyUtil.cacheOrGet(ref, ContainerUtil.createConcurrentWeakMap());
        }
        if ((cached = map.get(variable)) == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result = computer.execute(variable, visitedVars);
        map.put(variable, result == null ? NULL : result);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/resolve/JavaResolveCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeConstantValueWithCaching";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

