/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.FileIconKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create("iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = key -> {
        VirtualFile file = key.getFile();
        int flags = IconUtil.filterFileIconFlags(file, key.getFlags());
        Project project = key.getProject();
        if (!file.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
            return null;
        }
        Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
        Icon icon = providersIcon == null ? VirtualFilePresentation.getIconImpl(file) : providersIcon;
        boolean dumb = project != null && DumbService.getInstance(project).isDumb();
        for (FileIconPatcher patcher : IconUtil.getPatchers()) {
            if (dumb && !DumbService.isDumbAware(patcher)) continue;
            icon = patcher.patchIcon(icon, file, flags & 0xFFFFFFFD, project);
        }
        if (file.is(VFileProperty.SYMLINK)) {
            icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
        }
        if (!(!BitUtil.isSet(flags, 2) || file.isWritable() && WritingAccessProvider.isPotentiallyWritable(file, project))) {
            icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
        }
        Iconable.LastComputedIcon.put(file, icon, flags);
        return icon;
    };

    private static boolean wasEverInitialized(@NotNull Project project) {
        Boolean was;
        if (project == null) {
            IconUtil.$$$reportNull$$$0(0);
        }
        if ((was = project.getUserData(PROJECT_WAS_EVER_INITIALIZED)) == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, true);
            } else {
                was = false;
            }
        }
        return was;
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon, int maxWidth, int maxHeight) {
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(1);
        }
        if (icon.getIconHeight() <= maxHeight && icon.getIconWidth() <= maxWidth) {
            Icon icon2 = icon;
            if (icon2 == null) {
                IconUtil.$$$reportNull$$$0(2);
            }
            return icon2;
        }
        Image image = IconUtil.toImage(icon);
        if (image == null) {
            Icon icon3 = icon;
            if (icon3 == null) {
                IconUtil.$$$reportNull$$$0(3);
            }
            return icon3;
        }
        double scale = 1.0;
        if (image instanceof JBHiDPIScaledImage) {
            scale = ((JBHiDPIScaledImage)image).getScale();
            image = ((JBHiDPIScaledImage)image).getDelegate();
        }
        BufferedImage bi = ImageUtil.toBufferedImage(image);
        Graphics2D g = bi.createGraphics();
        int imageWidth = ImageUtil.getRealWidth(image);
        int imageHeight = ImageUtil.getRealHeight(image);
        maxWidth = maxWidth == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.round((double)maxWidth * scale);
        maxHeight = maxHeight == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.round((double)maxHeight * scale);
        int w = Math.min(imageWidth, maxWidth);
        int h = Math.min(imageHeight, maxHeight);
        BufferedImage img = UIUtil.createImage(g, w, h, 3);
        int offX = imageWidth > maxWidth ? (imageWidth - maxWidth) / 2 : 0;
        int offY = imageHeight > maxHeight ? (imageHeight - maxHeight) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row = 0; row < h; ++row) {
                img.setRGB(col, row, bi.getRGB(col + offX, row + offY));
            }
        }
        g.dispose();
        JBImageIcon jBImageIcon = new JBImageIcon(RetinaImage.createFrom((Image)img, scale, null));
        if (jBImageIcon == null) {
            IconUtil.$$$reportNull$$$0(4);
        }
        return jBImageIcon;
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon, @NotNull Rectangle area) {
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(5);
        }
        if (area == null) {
            IconUtil.$$$reportNull$$$0(6);
        }
        if (!new Rectangle(icon.getIconWidth(), icon.getIconHeight()).contains(area)) {
            Icon icon2 = icon;
            if (icon2 == null) {
                IconUtil.$$$reportNull$$$0(7);
            }
            return icon2;
        }
        CropIcon cropIcon = new CropIcon(icon, area);
        if (cropIcon == null) {
            IconUtil.$$$reportNull$$$0(8);
        }
        return cropIcon;
    }

    @NotNull
    public static Icon flip(final @NotNull Icon icon, final boolean horizontal) {
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(9);
        }
        Icon icon2 = new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    AffineTransform transform = AffineTransform.getTranslateInstance(horizontal ? (double)(x + this.getIconWidth()) : (double)x, horizontal ? (double)y : (double)(y + this.getIconHeight()));
                    transform.concatenate(AffineTransform.getScaleInstance(horizontal ? -1.0 : 1.0, horizontal ? 1.0 : -1.0));
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    icon.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        };
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(10);
        }
        return icon2;
    }

    @Iconable.IconFlags
    private static int filterFileIconFlags(@NotNull VirtualFile file, @Iconable.IconFlags int flags) {
        if (file == null) {
            IconUtil.$$$reportNull$$$0(11);
        }
        UserDataHolder fileTypeDataHolder = ObjectUtils.tryCast(file.getFileType(), UserDataHolder.class);
        int fileTypeFlagIgnoreMask = Iconable.ICON_FLAG_IGNORE_MASK.get(fileTypeDataHolder, 0);
        int flagIgnoreMask = Iconable.ICON_FLAG_IGNORE_MASK.get(file, fileTypeFlagIgnoreMask);
        return flags & ~flagIgnoreMask;
    }

    public static Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
        Icon lastIcon;
        if (file == null) {
            IconUtil.$$$reportNull$$$0(12);
        }
        Icon base = (lastIcon = Iconable.LastComputedIcon.get(file, flags)) != null ? lastIcon : VirtualFilePresentation.getIconImpl(file);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file, project, flags), ICON_NULLABLE_FUNCTION);
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, Project project) {
        if (file == null) {
            IconUtil.$$$reportNull$$$0(13);
        }
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @NotNull
    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/class.png"), 0);
        if (showVisibility) {
            baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/c_public.png"), 1);
        }
        RowIcon rowIcon = baseIcon;
        if (rowIcon == null) {
            IconUtil.$$$reportNull$$$0(14);
        }
        return rowIcon;
    }

    @NotNull
    private static Icon createEmptyIconLike(@NotNull String baseIconPath) {
        Icon baseIcon;
        if (baseIconPath == null) {
            IconUtil.$$$reportNull$$$0(15);
        }
        if ((baseIcon = IconLoader.findIcon(baseIconPath)) == null) {
            Icon icon = EmptyIcon.ICON_16;
            if (icon == null) {
                IconUtil.$$$reportNull$$$0(16);
            }
            return icon;
        }
        EmptyIcon emptyIcon = EmptyIcon.create(baseIcon);
        if (emptyIcon == null) {
            IconUtil.$$$reportNull$$$0(17);
        }
        return emptyIcon;
    }

    @NotNull
    private static FileIconProvider[] getProviders() {
        FileIconProvider[] fileIconProviderArray = FileIconProviderHolder.myProviders;
        if (fileIconProviderArray == null) {
            IconUtil.$$$reportNull$$$0(18);
        }
        return fileIconProviderArray;
    }

    @NotNull
    private static FileIconPatcher[] getPatchers() {
        FileIconPatcher[] fileIconPatcherArray = FileIconPatcherHolder.ourPatchers;
        if (fileIconPatcherArray == null) {
            IconUtil.$$$reportNull$$$0(19);
        }
        return fileIconPatcherArray;
    }

    public static Image toImage(@NotNull Icon icon) {
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(20);
        }
        return IconLoader.toImage(icon);
    }

    @NotNull
    public static Icon getAddIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("add.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(21);
        }
        return icon;
    }

    @NotNull
    public static Icon getRemoveIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("remove.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(22);
        }
        return icon;
    }

    @NotNull
    public static Icon getMoveUpIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("moveUp.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(23);
        }
        return icon;
    }

    @NotNull
    public static Icon getMoveDownIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("moveDown.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(24);
        }
        return icon;
    }

    @NotNull
    public static Icon getEditIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("edit.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(25);
        }
        return icon;
    }

    @NotNull
    public static Icon getAddClassIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addClass.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(26);
        }
        return icon;
    }

    @NotNull
    public static Icon getAddPatternIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addPattern.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(27);
        }
        return icon;
    }

    @NotNull
    public static Icon getAddJiraPatternIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addJira.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(28);
        }
        return icon;
    }

    @NotNull
    public static Icon getAddYouTrackPatternIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addYouTrack.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(29);
        }
        return icon;
    }

    @NotNull
    public static Icon getAddBlankLineIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addBlankLine.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(30);
        }
        return icon;
    }

    @NotNull
    public static Icon getAddPackageIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addPackage.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(31);
        }
        return icon;
    }

    @NotNull
    public static Icon getAddLinkIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addLink.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(32);
        }
        return icon;
    }

    @NotNull
    public static Icon getAddFolderIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addFolder.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(33);
        }
        return icon;
    }

    @NotNull
    public static Icon getAnalyzeIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("analyze.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(34);
        }
        return icon;
    }

    public static void paintInCenterOf(@NotNull Component c, @NotNull Graphics g, @NotNull Icon icon) {
        if (c == null) {
            IconUtil.$$$reportNull$$$0(35);
        }
        if (g == null) {
            IconUtil.$$$reportNull$$$0(36);
        }
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(37);
        }
        int x = (c.getWidth() - icon.getIconWidth()) / 2;
        int y = (c.getHeight() - icon.getIconHeight()) / 2;
        icon.paintIcon(c, g, x, y);
    }

    @NotNull
    private static Icon getToolbarDecoratorIcon(@NotNull String name) {
        if (name == null) {
            IconUtil.$$$reportNull$$$0(38);
        }
        Icon icon = IconLoader.getIcon(IconUtil.getToolbarDecoratorIconsFolder() + name);
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(39);
        }
        return icon;
    }

    @NotNull
    private static String getToolbarDecoratorIconsFolder() {
        String string = "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
        if (string == null) {
            IconUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public static Icon[] getEqualSizedIcons(Icon ... icons) {
        if (icons == null) {
            IconUtil.$$$reportNull$$$0(41);
        }
        Icon[] result = new Icon[icons.length];
        int width = 0;
        int height = 0;
        for (Icon icon : icons) {
            width = Math.max(width, icon.getIconWidth());
            height = Math.max(height, icon.getIconHeight());
        }
        for (int i = 0; i < icons.length; ++i) {
            result[i] = new IconSizeWrapper(icons[i], width, height);
        }
        if (result == null) {
            IconUtil.$$$reportNull$$$0(42);
        }
        return result;
    }

    @NotNull
    public static Icon toSize(@Nullable Icon icon, int width, int height) {
        IconSizeWrapper iconSizeWrapper = new IconSizeWrapper(icon, width, height);
        if (iconSizeWrapper == null) {
            IconUtil.$$$reportNull$$$0(43);
        }
        return iconSizeWrapper;
    }

    @NotNull
    public static Icon scale(final @NotNull Icon source, double _scale) {
        Image image;
        if (source == null) {
            IconUtil.$$$reportNull$$$0(44);
        }
        final int hiDPIscale = source instanceof ImageIcon ? (RetinaImage.isAppleHiDPIScaledImage(image = ((ImageIcon)source).getImage()) || image instanceof JBHiDPIScaledImage ? 2 : 1) : 1;
        final double scale = Math.min(32.0, Math.max(0.1, _scale));
        Icon icon = new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    g2d.translate(x, y);
                    AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    source.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return (int)((double)source.getIconWidth() * scale) / hiDPIscale;
            }

            @Override
            public int getIconHeight() {
                return (int)((double)source.getIconHeight() * scale) / hiDPIscale;
            }
        };
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(45);
        }
        return icon;
    }

    @NotNull
    public static Icon scale(@NotNull Icon icon, @Nullable Component ancestor, float scale) {
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(46);
        }
        if (icon instanceof ScalableIcon) {
            if (icon instanceof JBUI.ScaleContextAware) {
                ((JBUI.ScaleContextAware)((Object)icon)).updateScaleContext(ancestor != null ? JBUI.ScaleContext.create(ancestor) : null);
            }
            Icon icon2 = ((ScalableIcon)icon).scale(scale);
            if (icon2 == null) {
                IconUtil.$$$reportNull$$$0(47);
            }
            return icon2;
        }
        Icon icon3 = IconUtil.scale(icon, scale);
        if (icon3 == null) {
            IconUtil.$$$reportNull$$$0(48);
        }
        return icon3;
    }

    @NotNull
    public static Icon scaleByFont(@NotNull Icon icon, @Nullable Component ancestor, float fontSize) {
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(49);
        }
        float scale = JBUI.getFontScale(fontSize);
        if (icon instanceof ScalableIcon) {
            if (icon instanceof JBUI.ScaleContextAware) {
                JBUI.ScaleContextAware ctxIcon = (JBUI.ScaleContextAware)((Object)icon);
                ctxIcon.updateScaleContext(ancestor != null ? JBUI.ScaleContext.create(ancestor) : null);
                double usrScale = ((JBUI.BaseScaleContext)ctxIcon.getScaleContext()).getScale(JBUI.ScaleType.USR_SCALE);
                scale = (float)((double)scale / usrScale);
            }
            Icon icon2 = ((ScalableIcon)icon).scale(scale);
            if (icon2 == null) {
                IconUtil.$$$reportNull$$$0(50);
            }
            return icon2;
        }
        Icon icon3 = IconUtil.scale(icon, scale);
        if (icon3 == null) {
            IconUtil.$$$reportNull$$$0(51);
        }
        return icon3;
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(52);
        }
        if (color == null) {
            IconUtil.$$$reportNull$$$0(53);
        }
        Icon icon = IconUtil.colorize(source, color, false);
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(54);
        }
        return icon;
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(55);
        }
        if (color == null) {
            IconUtil.$$$reportNull$$$0(56);
        }
        Icon icon = IconUtil.colorize(g, source, color, false);
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(57);
        }
        return icon;
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color, boolean keepGray) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(58);
        }
        if (color == null) {
            IconUtil.$$$reportNull$$$0(59);
        }
        Icon icon = IconUtil.filterIcon(null, source, new ColorFilter(color, keepGray));
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(60);
        }
        return icon;
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color, boolean keepGray) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(61);
        }
        if (color == null) {
            IconUtil.$$$reportNull$$$0(62);
        }
        Icon icon = IconUtil.filterIcon(g, source, new ColorFilter(color, keepGray));
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(63);
        }
        return icon;
    }

    @NotNull
    public static Icon desaturate(@NotNull Icon source) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(64);
        }
        Icon icon = IconUtil.filterIcon(null, source, new DesaturationFilter());
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(65);
        }
        return icon;
    }

    @NotNull
    public static Icon brighter(@NotNull Icon source, int tones) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(66);
        }
        Icon icon = IconUtil.filterIcon(null, source, new BrighterFilter(tones));
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(67);
        }
        return icon;
    }

    @NotNull
    public static Icon darker(@NotNull Icon source, int tones) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(68);
        }
        Icon icon = IconUtil.filterIcon(null, source, new DarkerFilter(tones));
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(69);
        }
        return icon;
    }

    @NotNull
    private static Icon filterIcon(Graphics2D g, @NotNull Icon source, @NotNull Filter filter) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(70);
        }
        if (filter == null) {
            IconUtil.$$$reportNull$$$0(71);
        }
        BufferedImage src = g != null ? UIUtil.createImage(g, source.getIconWidth(), source.getIconHeight(), 3) : UIUtil.createImage(source.getIconWidth(), source.getIconHeight(), 3);
        Graphics2D g2d = src.createGraphics();
        source.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        BufferedImage img = g != null ? UIUtil.createImage(g, source.getIconWidth(), source.getIconHeight(), 3) : UIUtil.createImage(source.getIconWidth(), source.getIconHeight(), 3);
        int[] rgba = new int[4];
        for (int y = 0; y < src.getRaster().getHeight(); ++y) {
            for (int x = 0; x < src.getRaster().getWidth(); ++x) {
                src.getRaster().getPixel(x, y, rgba);
                if (rgba[3] == 0) continue;
                img.getRaster().setPixel(x, y, filter.convert(rgba));
            }
        }
        JBImageIcon jBImageIcon = IconUtil.createImageIcon((Image)img);
        if (jBImageIcon == null) {
            IconUtil.$$$reportNull$$$0(72);
        }
        return jBImageIcon;
    }

    @Deprecated
    @NotNull
    public static JBImageIcon createImageIcon(@NotNull BufferedImage img) {
        if (img == null) {
            IconUtil.$$$reportNull$$$0(73);
        }
        JBImageIcon jBImageIcon = IconUtil.createImageIcon((Image)img);
        if (jBImageIcon == null) {
            IconUtil.$$$reportNull$$$0(74);
        }
        return jBImageIcon;
    }

    @NotNull
    public static JBImageIcon createImageIcon(@NotNull Image img) {
        if (img == null) {
            IconUtil.$$$reportNull$$$0(75);
        }
        JBImageIcon jBImageIcon = new JBImageIcon(img){

            @Override
            public int getIconWidth() {
                return ImageUtil.getUserWidth(this.getImage());
            }

            @Override
            public int getIconHeight() {
                return ImageUtil.getUserHeight(this.getImage());
            }
        };
        if (jBImageIcon == null) {
            IconUtil.$$$reportNull$$$0(76);
        }
        return jBImageIcon;
    }

    @NotNull
    public static Icon textToIcon(final @NotNull String text, @NotNull Component component, float fontSize) {
        if (text == null) {
            IconUtil.$$$reportNull$$$0(77);
        }
        if (component == null) {
            IconUtil.$$$reportNull$$$0(78);
        }
        final JBFont font = JBFont.create(JBUI.Fonts.label().deriveFont(fontSize));
        FontMetrics metrics = component.getFontMetrics(font);
        final int width = metrics.stringWidth(text) + JBUI.scale(4);
        final int height = metrics.getHeight();
        Icon icon = new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g = g.create();
                try {
                    GraphicsUtil.setupAntialiasing(g);
                    g.setFont(font);
                    UIUtil.drawStringWithHighlighting(g, text, x + JBUI.scale(2), y + height - JBUI.scale(1), JBColor.foreground(), JBColor.background());
                }
                finally {
                    g.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public int getIconHeight() {
                return height;
            }
        };
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(79);
        }
        return icon;
    }

    @NotNull
    public static Icon addText(@NotNull Icon base, @NotNull String text) {
        if (base == null) {
            IconUtil.$$$reportNull$$$0(80);
        }
        if (text == null) {
            IconUtil.$$$reportNull$$$0(81);
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(base, 0);
        icon.setIcon(IconUtil.textToIcon(text, new JLabel(), JBUI.scale(6.0f)), 1, 4);
        LayeredIcon layeredIcon = icon;
        if (layeredIcon == null) {
            IconUtil.$$$reportNull$$$0(82);
        }
        return layeredIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 20: 
            case 37: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/IconUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIconPath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 44: 
            case 52: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 53: 
            case 56: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "img";
                break;
            }
            case 77: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/IconUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cropIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "flip";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyIcon";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIconLike";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddIcon";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoveIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveUpIcon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveDownIcon";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditIcon";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddClassIcon";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPatternIcon";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddJiraPatternIcon";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddYouTrackPatternIcon";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddBlankLineIcon";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPackageIcon";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddLinkIcon";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFolderIcon";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyzeIcon";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarDecoratorIcon";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarDecoratorIconsFolder";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualSizedIcons";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "toSize";
                break;
            }
            case 45: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleByFont";
                break;
            }
            case 54: 
            case 57: 
            case 60: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "colorize";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "desaturate";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "brighter";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "darker";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIcon";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageIcon";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "textToIcon";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "addText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wasEverInitialized";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cropIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "flip";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterFileIconFlags";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyIconLike";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "paintInCenterOf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getToolbarDecoratorIcon";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getEqualSizedIcons";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "scaleByFont";
                break;
            }
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "colorize";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "filterIcon";
                break;
            }
            case 73: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createImageIcon";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "textToIcon";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DarkerFilter
    extends Filter {
        private final int myTones;

        public DarkerFilter(int tones) {
            this.myTones = tones;
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            if (rgba == null) {
                DarkerFilter.$$$reportNull$$$0(0);
            }
            float[] hsb = Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], null);
            float brightness = hsb[2];
            for (int i = 0; i < this.myTones && (brightness = Math.max(0.0f, brightness / 1.1f)) != 0.0f; ++i) {
            }
            Color color = Color.getHSBColor(hsb[0], hsb[1], brightness);
            int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue(), rgba[3]};
            if (nArray == null) {
                DarkerFilter.$$$reportNull$$$0(1);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rgba";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/IconUtil$DarkerFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/IconUtil$DarkerFilter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BrighterFilter
    extends Filter {
        private final int myTones;

        public BrighterFilter(int tones) {
            this.myTones = tones;
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            if (rgba == null) {
                BrighterFilter.$$$reportNull$$$0(0);
            }
            float[] hsb = Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], null);
            float brightness = hsb[2];
            for (int i = 0; i < this.myTones && (brightness = Math.min(1.0f, brightness * 1.1f)) != 1.0f; ++i) {
            }
            Color color = Color.getHSBColor(hsb[0], hsb[1], brightness);
            int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue(), rgba[3]};
            if (nArray == null) {
                BrighterFilter.$$$reportNull$$$0(1);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rgba";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/IconUtil$BrighterFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/IconUtil$BrighterFilter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DesaturationFilter
    extends Filter {
        private DesaturationFilter() {
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            if (rgba == null) {
                DesaturationFilter.$$$reportNull$$$0(0);
            }
            int min = Math.min(Math.min(rgba[0], rgba[1]), rgba[2]);
            int max = Math.max(Math.max(rgba[0], rgba[1]), rgba[2]);
            int grey = (max + min) / 2;
            int[] nArray = new int[]{grey, grey, grey, rgba[3]};
            if (nArray == null) {
                DesaturationFilter.$$$reportNull$$$0(1);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rgba";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/IconUtil$DesaturationFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/IconUtil$DesaturationFilter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ColorFilter
    extends Filter {
        private final float[] myBase;
        private final boolean myKeepGray;

        private ColorFilter(@NotNull Color color, boolean keepGray) {
            if (color == null) {
                ColorFilter.$$$reportNull$$$0(0);
            }
            this.myKeepGray = keepGray;
            this.myBase = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            if (rgba == null) {
                ColorFilter.$$$reportNull$$$0(1);
            }
            float[] hsb = new float[3];
            Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], hsb);
            int rgb = Color.HSBtoRGB(this.myBase[0], this.myBase[1] * (this.myKeepGray ? hsb[1] : 1.0f), this.myBase[2] * hsb[2]);
            int[] nArray = new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgba[3]};
            if (nArray == null) {
                ColorFilter.$$$reportNull$$$0(2);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rgba";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/IconUtil$ColorFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/IconUtil$ColorFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Filter {
        private Filter() {
        }

        @NotNull
        abstract int[] convert(@NotNull int[] var1);
    }

    private static class CropIcon
    implements Icon {
        private final Icon mySrc;
        private final Rectangle myCrop;

        private CropIcon(@NotNull Icon src, @NotNull Rectangle crop) {
            if (src == null) {
                CropIcon.$$$reportNull$$$0(0);
            }
            if (crop == null) {
                CropIcon.$$$reportNull$$$0(1);
            }
            this.mySrc = src;
            this.myCrop = crop;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.mySrc.paintIcon(c, g, x - this.myCrop.x, y - this.myCrop.y);
        }

        @Override
        public int getIconWidth() {
            return this.myCrop.width;
        }

        @Override
        public int getIconHeight() {
            return this.myCrop.height;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "src";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "crop";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/IconUtil$CropIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class IconSizeWrapper
    implements Icon {
        private final Icon myIcon;
        private final int myWidth;
        private final int myHeight;

        protected IconSizeWrapper(@Nullable Icon icon, int width, int height) {
            this.myIcon = icon;
            this.myWidth = width;
            this.myHeight = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintIcon(this.myIcon, c, g, x, y);
        }

        protected void paintIcon(@Nullable Icon icon, Component c, Graphics g, int x, int y) {
            if (icon == null) {
                return;
            }
            icon.paintIcon(c, g, x += (this.myWidth - icon.getIconWidth()) / 2, y += (this.myHeight - icon.getIconHeight()) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = Extensions.getExtensions(FileIconPatcher.EP_NAME);

        private FileIconPatcherHolder() {
        }
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = Extensions.getExtensions(FileIconProvider.EP_NAME);

        private FileIconProviderHolder() {
        }
    }
}

