/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.value.DfaInstanceofValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ExpressionTypeMemoryState
extends DfaMemoryStateImpl {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.guess.impl.ExpressionTypeMemoryState");
    public static final TObjectHashingStrategy<PsiExpression> EXPRESSION_HASHING_STRATEGY = new TObjectHashingStrategy<PsiExpression>(){

        public int computeHashCode(PsiExpression object) {
            if (object instanceof PsiReferenceExpression) {
                return Objects.hashCode(((PsiReferenceExpression)object).getReferenceName()) * 31 + 1;
            }
            if (object instanceof PsiMethodCallExpression) {
                return Objects.hashCode(((PsiMethodCallExpression)object).getMethodExpression().getReferenceName()) * 31 + 2;
            }
            return object.getNode().getElementType().hashCode();
        }

        public boolean equals(PsiExpression o1, PsiExpression o2) {
            if (JavaPsiEquivalenceUtil.areExpressionsEquivalent(o1, o2)) {
                if (this.computeHashCode(o1) != this.computeHashCode(o2)) {
                    LOG.error("different hashCodes: " + o1 + "; " + o2 + "; " + this.computeHashCode(o1) + "!=" + this.computeHashCode(o2));
                }
                return true;
            }
            return false;
        }
    };
    private MultiMap<PsiExpression, PsiType> myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);

    public ExpressionTypeMemoryState(DfaValueFactory factory) {
        super(factory);
    }

    private ExpressionTypeMemoryState(DfaMemoryStateImpl toCopy) {
        super(toCopy);
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        ExpressionTypeMemoryState copy = new ExpressionTypeMemoryState(this);
        copy.myStates = this.myStates;
        ExpressionTypeMemoryState expressionTypeMemoryState = copy;
        if (expressionTypeMemoryState == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(0);
        }
        return expressionTypeMemoryState;
    }

    @Override
    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        if (!super.isSuperStateOf(that)) {
            return false;
        }
        MultiMap<PsiExpression, PsiType> thatStates = ((ExpressionTypeMemoryState)that).myStates;
        if (thatStates == this.myStates) {
            return true;
        }
        for (Map.Entry<PsiExpression, Collection<PsiType>> entry : this.myStates.entrySet()) {
            Collection<PsiType> thisTypes = entry.getValue();
            Collection<PsiType> thatTypes = thatStates.get(entry.getKey());
            if (thatTypes.containsAll(thisTypes)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaInstanceofValue) {
            DfaInstanceofValue value = (DfaInstanceofValue)dfaCond;
            if (!value.isNegated()) {
                this.setExpressionType(value.getExpression(), value.getCastType());
            }
            return super.applyCondition(((DfaInstanceofValue)dfaCond).getRelation());
        }
        return super.applyCondition(dfaCond);
    }

    MultiMap<PsiExpression, PsiType> getStates() {
        return this.myStates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpressionTypeMemoryState that = (ExpressionTypeMemoryState)o;
        return this.myStates.equals(that.myStates);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStates.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return super.toString() + " states=[" + this.myStates + "]";
    }

    void removeExpressionType(@NotNull PsiExpression expression) {
        if (expression == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(1);
        }
        if (this.myStates.containsKey(expression)) {
            MultiMap<PsiExpression, PsiType> oldStates = this.myStates;
            this.myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);
            for (Map.Entry<PsiExpression, Collection<PsiType>> entry : oldStates.entrySet()) {
                if (EXPRESSION_HASHING_STRATEGY.equals((Object)entry.getKey(), (Object)expression)) continue;
                this.myStates.putValues(entry.getKey(), entry.getValue());
            }
        }
    }

    void setExpressionType(@NotNull PsiExpression expression, @NotNull PsiType type) {
        if (expression == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(2);
        }
        if (type == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(3);
        }
        if (!this.myStates.get(expression).contains(type)) {
            MultiMap<PsiExpression, PsiType> oldStates = this.myStates;
            this.myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);
            this.myStates.putAllValues(oldStates);
            this.myStates.putValue(expression, type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/guess/impl/ExpressionTypeMemoryState";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/ExpressionTypeMemoryState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeExpressionType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExpressionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

