/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.EquationsLimitException;
import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ParameterAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.PuritySolver;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Solver;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ProjectBytecodeAnalysis {
    private static final boolean SKIP_INDEX = false;
    public static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.bytecodeAnalysis");
    public static final Key<Boolean> INFERRED_ANNOTATION = Key.create("INFERRED_ANNOTATION");
    public static final String NULLABLE_METHOD = "java.annotations.inference.nullable.method";
    public static final String NULLABLE_METHOD_TRANSITIVITY = "java.annotations.inference.nullable.method.transitivity";
    public static final int EQUATIONS_LIMIT = 1000;
    private final Project myProject;
    private final boolean nullableMethod;
    private final boolean nullableMethodTransitivity;
    private final EquationProvider<?> myEquationProvider;

    public static ProjectBytecodeAnalysis getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(0);
        }
        return ServiceManager.getService(project, ProjectBytecodeAnalysis.class);
    }

    public ProjectBytecodeAnalysis(Project project) {
        this.myProject = project;
        this.myEquationProvider = new IndexedEquationProvider(this.myProject);
        this.nullableMethod = Registry.is(NULLABLE_METHOD);
        this.nullableMethodTransitivity = Registry.is(NULLABLE_METHOD_TRANSITIVITY);
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(1);
        }
        if (annotationFQN == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(2);
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            return null;
        }
        if (annotationFQN.equals("org.jetbrains.annotations.NotNull") || annotationFQN.equals("org.jetbrains.annotations.Nullable") || annotationFQN.equals(ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = this.findInferredAnnotations(listOwner)) {
                if (!annotationFQN.equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(3);
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(4);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue(listOwner, () -> {
            if (listOwner == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(28);
            }
            return CachedValueProvider.Result.create(this.collectInferredAnnotations(listOwner), listOwner);
        });
        if (psiAnnotationArray == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(5);
        }
        return psiAnnotationArray;
    }

    @NotNull
    private PsiAnnotation[] collectInferredAnnotations(PsiModifierListOwner listOwner) {
        block15: {
            block14: {
                EKey primaryKey;
                block13: {
                    block11: {
                        block12: {
                            VirtualFile file;
                            PsiFile psiFile = listOwner.getContainingFile();
                            VirtualFile virtualFile = file = psiFile == null ? null : psiFile.getVirtualFile();
                            if (file != null && ClassDataIndexer.isFileExcluded(file)) {
                                if (PsiAnnotation.EMPTY_ARRAY == null) {
                                    ProjectBytecodeAnalysis.$$$reportNull$$$0(6);
                                }
                                return PsiAnnotation.EMPTY_ARRAY;
                            }
                            try {
                                MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
                                primaryKey = this.getKey(listOwner, md);
                                if (primaryKey != null) break block11;
                                if (PsiAnnotation.EMPTY_ARRAY != null) break block12;
                            }
                            catch (EquationsLimitException e) {
                                if (LOG.isDebugEnabled()) {
                                    String externalName = PsiFormatUtil.getExternalName(listOwner, false, Integer.MAX_VALUE);
                                    LOG.debug("Too many equations for " + externalName);
                                }
                                if (PsiAnnotation.EMPTY_ARRAY == null) {
                                    ProjectBytecodeAnalysis.$$$reportNull$$$0(11);
                                }
                                return PsiAnnotation.EMPTY_ARRAY;
                            }
                            ProjectBytecodeAnalysis.$$$reportNull$$$0(7);
                        }
                        return PsiAnnotation.EMPTY_ARRAY;
                    }
                    if (!(listOwner instanceof PsiMethod)) break block13;
                    ArrayList<EKey> allKeys = ProjectBytecodeAnalysis.collectMethodKeys((PsiMethod)listOwner, primaryKey);
                    MethodAnnotations methodAnnotations = this.loadMethodAnnotations((PsiMethod)listOwner, primaryKey, allKeys);
                    PsiAnnotation[] psiAnnotationArray = this.toPsi(primaryKey, methodAnnotations);
                    if (psiAnnotationArray == null) {
                        ProjectBytecodeAnalysis.$$$reportNull$$$0(8);
                    }
                    return psiAnnotationArray;
                }
                if (!(listOwner instanceof PsiParameter)) break block14;
                ParameterAnnotations parameterAnnotations = this.loadParameterAnnotations(primaryKey);
                PsiAnnotation[] psiAnnotationArray = this.toPsi(parameterAnnotations);
                if (psiAnnotationArray == null) {
                    ProjectBytecodeAnalysis.$$$reportNull$$$0(9);
                }
                return psiAnnotationArray;
            }
            if (PsiAnnotation.EMPTY_ARRAY != null) break block15;
            ProjectBytecodeAnalysis.$$$reportNull$$$0(10);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    private PsiAnnotation[] toPsi(EKey primaryKey, MethodAnnotations methodAnnotations) {
        PsiAnnotation psiAnnotation;
        boolean notNull = methodAnnotations.notNulls.contains(primaryKey);
        boolean nullable = methodAnnotations.nullables.contains(primaryKey);
        boolean pure = methodAnnotations.pures.contains(primaryKey);
        String contractValues = methodAnnotations.contractsValues.get(primaryKey);
        String contractPsiText = null;
        if (contractValues != null) {
            contractPsiText = pure ? "value=" + contractValues + ",pure=true" : contractValues;
        } else if (pure) {
            contractPsiText = "pure=true";
        }
        PsiAnnotation psiAnnotation2 = psiAnnotation = contractPsiText == null ? null : this.createContractAnnotation(contractPsiText);
        if (notNull && psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation(), psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(12);
            }
            return psiAnnotationArray;
        }
        if (nullable && psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation(), psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(13);
            }
            return psiAnnotationArray;
        }
        if (notNull) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(14);
            }
            return psiAnnotationArray;
        }
        if (nullable) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(15);
            }
            return psiAnnotationArray;
        }
        if (psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(16);
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(17);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    private PsiAnnotation[] toPsi(ParameterAnnotations parameterAnnotations) {
        if (parameterAnnotations.notNull) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(18);
            }
            return psiAnnotationArray;
        }
        if (parameterAnnotations.nullable) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(19);
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(20);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public PsiAnnotation getNotNullAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager(this.myProject).getCachedValue(this.myProject, () -> CachedValueProvider.Result.create(this.createAnnotationFromText("@org.jetbrains.annotations.NotNull"), ModificationTracker.NEVER_CHANGED));
    }

    public PsiAnnotation getNullableAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager(this.myProject).getCachedValue(this.myProject, () -> CachedValueProvider.Result.create(this.createAnnotationFromText("@org.jetbrains.annotations.Nullable"), ModificationTracker.NEVER_CHANGED));
    }

    public PsiAnnotation createContractAnnotation(String contractValue) {
        Map cache = (Map)CachedValuesManager.getManager(this.myProject).getCachedValue(this.myProject, () -> {
            ConcurrentMap<String, PsiAnnotation> map = ConcurrentFactoryMap.createMap(attrs -> this.createAnnotationFromText("@org.jetbrains.annotations.Contract(" + attrs + ")"));
            return CachedValueProvider.Result.create(map, ModificationTracker.NEVER_CHANGED);
        });
        return (PsiAnnotation)cache.get(contractValue);
    }

    @Nullable
    public EKey getKey(@NotNull PsiModifierListOwner owner, MessageDigest md) {
        PsiElement gParent;
        PsiElement parent;
        if (owner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(21);
        }
        LOG.assertTrue(owner instanceof PsiCompiledElement, owner);
        if (owner instanceof PsiMethod) {
            EKey key = BytecodeAnalysisConverter.psiKey((PsiMethod)owner, Direction.Out);
            return key == null ? null : this.myEquationProvider.adaptKey(key, md);
        }
        if (owner instanceof PsiParameter && (parent = owner.getParent()) instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod) {
            int index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)owner);
            EKey key = BytecodeAnalysisConverter.psiKey((PsiMethod)gParent, new Direction.In(index, false));
            return key == null ? null : this.myEquationProvider.adaptKey(key, md);
        }
        return null;
    }

    public static ArrayList<EKey> collectMethodKeys(@NotNull PsiMethod method, EKey primaryKey) {
        if (method == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(22);
        }
        return BytecodeAnalysisConverter.mkInOutKeys(method, primaryKey);
    }

    private ParameterAnnotations loadParameterAnnotations(@NotNull EKey notNullKey) throws EquationsLimitException {
        if (notNullKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(23);
        }
        Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(notNullKey), notNullSolver);
        Map<EKey, Value> notNullSolutions = notNullSolver.solve();
        boolean notNull = Value.NotNull == notNullSolutions.get(notNullKey) || Value.NotNull == notNullSolutions.get(notNullKey.mkUnstable());
        Solver nullableSolver = new Solver(new ELattice<Value>(Value.Null, Value.Top), Value.Top);
        EKey nullableKey = new EKey(notNullKey.member, notNullKey.dirKey + 1, true, false);
        this.collectEquations(Collections.singletonList(nullableKey), nullableSolver);
        Map<EKey, Value> nullableSolutions = nullableSolver.solve();
        boolean nullable = Value.Null == nullableSolutions.get(nullableKey) || Value.Null == nullableSolutions.get(nullableKey.mkUnstable());
        return new ParameterAnnotations(notNull, nullable);
    }

    private MethodAnnotations loadMethodAnnotations(@NotNull PsiMethod owner, @NotNull EKey key, ArrayList<EKey> allKeys) throws EquationsLimitException {
        if (owner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(24);
        }
        if (key == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(25);
        }
        MethodAnnotations result2 = new MethodAnnotations();
        PuritySolver puritySolver = new PuritySolver();
        this.collectPurityEquations(key.withDirection(Direction.Pure), puritySolver);
        Map<EKey, Effects> puritySolutions = puritySolver.solve();
        int arity = owner.getParameterList().getParameters().length;
        BytecodeAnalysisConverter.addEffectAnnotations(puritySolutions, result2, key, owner.isConstructor());
        EKey failureKey = key.withDirection(Direction.Throw);
        Solver failureSolver = new Solver(new ELattice<Value>(Value.Fail, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(failureKey), failureSolver);
        if (failureSolver.solve().get(failureKey) == Value.Fail) {
            result2.contractsValues.put(key, StreamEx.constant((Object)"_", (long)arity).joining((CharSequence)",", (CharSequence)"\"", (CharSequence)"->fail\""));
        } else {
            Solver outSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Top), Value.Top);
            this.collectEquations(allKeys, outSolver);
            Map<EKey, Value> solutions = outSolver.solve();
            BytecodeAnalysisConverter.addMethodAnnotations(solutions, result2, key, arity);
        }
        if (this.nullableMethod) {
            Solver nullableMethodSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Null), Value.Bot);
            EKey nullableKey = key.withDirection(Direction.NullableOut);
            if (this.nullableMethodTransitivity) {
                this.collectEquations(Collections.singletonList(nullableKey), nullableMethodSolver);
            } else {
                this.collectSingleEquation(nullableKey, nullableMethodSolver);
            }
            Map<EKey, Value> nullableSolutions = nullableMethodSolver.solve();
            if (nullableSolutions.get(nullableKey) == Value.Null || nullableSolutions.get(nullableKey.invertStability()) == Value.Null) {
                result2.nullables.add(key);
            }
        }
        return result2;
    }

    private static EKey withStability(EKey key, boolean stability) {
        return new EKey(key.member, key.dirKey, stability, false);
    }

    private void collectPurityEquations(EKey key, PuritySolver puritySolver) throws EquationsLimitException {
        HashSet<EKey> queued = new HashSet<EKey>();
        ArrayDeque<EKey> queue = new ArrayDeque<EKey>();
        queue.push(key);
        queued.add(key);
        while (!queue.isEmpty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            EKey curKey = (EKey)queue.pop();
            boolean stable = true;
            Effects combined = null;
            for (Equations equations : this.myEquationProvider.getEquations(curKey.member)) {
                stable &= equations.stable;
                Effects effects = (Effects)equations.find(curKey.getDirection()).orElseGet(() -> new Effects(DataValue.UnknownDataValue1, Effects.TOP_EFFECTS));
                combined = combined == null ? effects : combined.combine(effects);
            }
            if (combined == null) continue;
            combined.dependencies().filter(queued::add).forEach(queue::push);
            puritySolver.addEquation(ProjectBytecodeAnalysis.withStability(curKey, stable), combined);
        }
        puritySolver.addPlainFieldEquations(md -> true);
    }

    private void collectEquations(List<EKey> keys, Solver solver) throws EquationsLimitException {
        HashSet<EKey> queued = new HashSet<EKey>();
        Stack<EKey> queue = new Stack<EKey>();
        for (EKey key : keys) {
            queue.push(key);
            queued.add(key);
        }
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            EKey curKey = (EKey)queue.pop();
            for (Equations equations : this.myEquationProvider.getEquations(curKey.member)) {
                Result result2 = equations.find(curKey.getDirection()).orElseGet(solver::getUnknownResult);
                solver.addEquation(new Equation(ProjectBytecodeAnalysis.withStability(curKey, equations.stable), result2));
                result2.dependencies().filter(queued::add).forEach(queue::push);
            }
        }
    }

    private void collectSingleEquation(EKey curKey, Solver solver) {
        ProgressManager.checkCanceled();
        for (Equations equations : this.myEquationProvider.getEquations(curKey.member)) {
            Result result2 = equations.find(curKey.getDirection()).orElseGet(solver::getUnknownResult);
            solver.addEquation(new Equation(ProjectBytecodeAnalysis.withStability(curKey, equations.stable), result2));
        }
    }

    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(26);
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory(this.myProject).createAnnotationFromText(text2, null);
        annotation.putUserData(INFERRED_ANNOTATION, Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(27);
        }
        return psiAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullKey";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInferredAnnotations";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInferredAnnotations";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsi";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodKeys";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadParameterAnnotations";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadMethodAnnotations";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findInferredAnnotations$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class IndexedEquationProvider
    extends EquationProvider<HMember> {
        IndexedEquationProvider(Project project) {
            super(project);
        }

        @Override
        public EKey adaptKey(@NotNull EKey key, MessageDigest messageDigest) {
            if (key == null) {
                IndexedEquationProvider.$$$reportNull$$$0(0);
            }
            return key.hashed(messageDigest);
        }

        @Override
        public List<Equations> getEquations(MemberDescriptor method) {
            HMember key = method.hashed(null);
            return this.myEquationCache.computeIfAbsent(key, m -> BytecodeAnalysisIndex.getEquations(ProjectScope.getLibrariesScope(this.myProject), m));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$IndexedEquationProvider", "adaptKey"));
        }
    }

    static class PlainEquationProvider
    extends EquationProvider<Member> {
        PlainEquationProvider(Project project) {
            super(project);
        }

        @Override
        public EKey adaptKey(@NotNull EKey key, MessageDigest messageDigest) {
            if (key == null) {
                PlainEquationProvider.$$$reportNull$$$0(0);
            }
            assert (key.member instanceof Member);
            return key;
        }

        @Override
        public List<Equations> getEquations(MemberDescriptor memberDescriptor) {
            assert (memberDescriptor instanceof Member);
            Member method = (Member)memberDescriptor;
            List<Equations> equations = (List<Equations>)this.myEquationCache.get(method);
            return equations == null ? this.loadEquations(method) : equations;
        }

        private VirtualFile findClassFile(String internalClassName) {
            String packageName = StringUtil.getPackageName(internalClassName, '/').replace('/', '.');
            String className = StringUtil.getShortName(internalClassName, '/');
            PsiPackage aPackage = JavaPsiFacade.getInstance(this.myProject).findPackage(packageName);
            if (aPackage == null) {
                PsiModifierListOwner compiledClass;
                PsiClass psiClass = JavaPsiFacade.getInstance(this.myProject).findClass(StringUtil.getQualifiedName(packageName, className), GlobalSearchScope.allScope(this.myProject));
                if (psiClass != null && (compiledClass = PsiUtil.preferCompiledElement(psiClass)) instanceof ClsClassImpl) {
                    return compiledClass.getContainingFile().getVirtualFile();
                }
                return null;
            }
            String classFileName = className + ".class";
            for (PsiDirectory directory : aPackage.getDirectories()) {
                VirtualFile file = directory.getVirtualFile().findChild(classFileName);
                if (file == null || ClassDataIndexer.isFileExcluded(file)) continue;
                return file;
            }
            return null;
        }

        private List<Equations> loadEquations(Member method) {
            VirtualFile file = this.findClassFile(method.internalClassName);
            if (file == null) {
                return Collections.emptyList();
            }
            try {
                Map<EKey, Equations> map = ClassDataIndexer.processClass(new ClassReader(file.contentsToByteArray(false)), file.getPresentableUrl());
                Map groups = EntryStream.of(map).mapKeys(key -> (Member)key.member).grouping();
                this.myEquationCache.putAll(groups);
                return groups.getOrDefault(method, Collections.emptyList());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$PlainEquationProvider", "adaptKey"));
        }
    }

    static abstract class EquationProvider<T extends MemberDescriptor> {
        final Map<T, List<Equations>> myEquationCache = ContainerUtil.createConcurrentSoftValueMap();
        final Project myProject;

        EquationProvider(Project project) {
            this.myProject = project;
            project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, () -> this.myEquationCache.clear());
        }

        abstract EKey adaptKey(@NotNull EKey var1, MessageDigest var2);

        abstract List<Equations> getEquations(MemberDescriptor var1);
    }
}

