/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInsight.intention.impl.AddNullableAnnotationFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.DataFlowInstructionVisitor;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullParameterConstraintChecker;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.fix.RedundantInstanceofFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithConstantValueFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithObjectsEqualsFix;
import com.intellij.codeInspection.dataFlow.fix.SimplifyToAssignmentFix;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.DataFlowInspection");
    @NonNls
    private static final String SHORT_NAME = "ConstantConditions";
    public boolean SUGGEST_NULLABLE_ANNOTATIONS;
    public boolean DONT_REPORT_TRUE_ASSERT_STATEMENTS;
    public boolean TREAT_UNKNOWN_MEMBERS_AS_NULLABLE;
    public boolean IGNORE_ASSERT_STATEMENTS;
    public boolean REPORT_CONSTANT_REFERENCE_VALUES = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    public boolean REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = true;
    public boolean REPORT_UNCHECKED_OPTIONALS = true;

    @Override
    public JComponent createOptionsPanel() {
        throw new RuntimeException("no UI in headless mode");
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(0);
        }
        node.addContent(new Element("option").setAttribute("name", "SUGGEST_NULLABLE_ANNOTATIONS").setAttribute("value", String.valueOf(this.SUGGEST_NULLABLE_ANNOTATIONS)));
        node.addContent(new Element("option").setAttribute("name", "DONT_REPORT_TRUE_ASSERT_STATEMENTS").setAttribute("value", String.valueOf(this.DONT_REPORT_TRUE_ASSERT_STATEMENTS)));
        if (this.IGNORE_ASSERT_STATEMENTS) {
            node.addContent(new Element("option").setAttribute("name", "IGNORE_ASSERT_STATEMENTS").setAttribute("value", "true"));
        }
        if (!this.REPORT_CONSTANT_REFERENCE_VALUES) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_CONSTANT_REFERENCE_VALUES").setAttribute("value", "false"));
        }
        if (this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE) {
            node.addContent(new Element("option").setAttribute("name", "TREAT_UNKNOWN_MEMBERS_AS_NULLABLE").setAttribute("value", "true"));
        }
        if (!this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER").setAttribute("value", "false"));
        }
        if (!this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL").setAttribute("value", "false"));
        }
        if (!this.REPORT_UNCHECKED_OPTIONALS) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_UNCHECKED_OPTIONALS").setAttribute("value", "false"));
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(1);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitClass(PsiClass aClass) {
                if (aClass instanceof PsiTypeParameter) {
                    return;
                }
                DataFlowInspectionBase.this.analyzeCodeBlock(aClass, holder);
            }

            @Override
            public void visitMethod(PsiMethod method) {
                DataFlowInspectionBase.this.analyzeCodeBlock(method.getBody(), holder);
                DataFlowInspectionBase.this.analyzeNullLiteralMethodArguments(method, holder);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                PsiType returnType;
                PsiType methodReturnType;
                super.visitMethodReferenceExpression(expression);
                PsiElement resolve = expression.resolve();
                if (resolve instanceof PsiMethod && TypeConversionUtil.isPrimitiveWrapper(methodReturnType = ((PsiMethod)resolve).getReturnType()) && NullableNotNullManager.isNullable((PsiMethod)resolve) && TypeConversionUtil.isPrimitiveAndNotNull(returnType = LambdaUtil.getFunctionalInterfaceReturnType(expression))) {
                    holder.registerProblem((PsiElement)expression, InspectionsBundle.message("dataflow.message.unboxing.method.reference", new Object[0]), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitIfStatement(PsiIfStatement statement) {
                PsiExpression condition = PsiUtil.skipParenthesizedExprDown(statement.getCondition());
                if (BranchingInstruction.isBoolConst(condition)) {
                    LocalQuickFix fix = DataFlowInspectionBase.this.createSimplifyBooleanExpressionFix(condition, condition.textMatches("true"));
                    holder.registerProblem((PsiElement)condition, "Condition is always " + condition.getText(), fix);
                }
            }

            @Override
            public void visitWhileStatement(PsiWhileStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            @Override
            public void visitDoWhileStatement(PsiDoWhileStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            @Override
            public void visitForStatement(PsiForStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            private void checkLoopCondition(PsiExpression condition) {
                if ((condition = PsiUtil.skipParenthesizedExprDown(condition)) != null && condition.textMatches("false")) {
                    holder.registerProblem((PsiElement)condition, "Condition is always false", DataFlowInspectionBase.this.createSimplifyBooleanExpressionFix(condition, false));
                }
            }
        };
        if (javaElementVisitor == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private void analyzeNullLiteralMethodArguments(PsiMethod method, ProblemsHolder holder) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && holder.isOnTheFly()) {
            for (PsiParameter parameter : NullParameterConstraintChecker.checkMethodParameters(method)) {
                PsiIdentifier name = parameter.getNameIdentifier();
                if (name == null) continue;
                holder.registerProblem((PsiElement)name, InspectionsBundle.message("dataflow.method.fails.with.null.argument", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createNavigateToNullParameterUsagesFix(parameter));
            }
        }
    }

    private void analyzeCodeBlock(@Nullable PsiElement scope, ProblemsHolder holder) {
        if (scope == null) {
            return;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType(scope, PsiClass.class);
        if (containingClass != null && PsiUtil.isLocalOrAnonymousClass(containingClass) && !(containingClass instanceof PsiEnumConstantInitializer)) {
            return;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, !DfaUtil.isInsideConstructorOrInitializer(scope));
        this.analyzeDfaWithNestedClosures(scope, holder, dfaRunner, Collections.singletonList(dfaRunner.createMemoryState()));
    }

    private void analyzeDfaWithNestedClosures(PsiElement scope, ProblemsHolder holder, StandardDataFlowRunner dfaRunner, Collection<? extends DfaMemoryState> initialStates) {
        DataFlowInstructionVisitor visitor = new DataFlowInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod(scope, visitor, this.IGNORE_ASSERT_STATEMENTS, initialStates);
        if (rc == RunnerResult.OK) {
            this.createDescription(dfaRunner, holder, visitor, scope);
            dfaRunner.forNestedClosures((closure, states) -> this.analyzeDfaWithNestedClosures((PsiElement)closure, holder, dfaRunner, (Collection<? extends DfaMemoryState>)states));
        } else if (rc == RunnerResult.TOO_COMPLEX) {
            PsiIdentifier name = null;
            String message = null;
            if (scope.getParent() instanceof PsiMethod) {
                name = ((PsiMethod)scope.getParent()).getNameIdentifier();
                message = InspectionsBundle.message("dataflow.too.complex", new Object[0]);
            } else if (scope instanceof PsiClass) {
                name = ((PsiClass)scope).getNameIdentifier();
                message = InspectionsBundle.message("dataflow.too.complex.class", new Object[0]);
            }
            if (name != null) {
                holder.registerProblem((PsiElement)name, message, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    protected List<LocalQuickFix> createNPEFixes(PsiExpression qualifier, PsiExpression expression, boolean onTheFly) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected List<LocalQuickFix> createMethodReferenceNPEFixes(PsiMethodReferenceExpression methodRef) {
        return Collections.emptyList();
    }

    @Nullable
    protected LocalQuickFix createIntroduceVariableFix(PsiExpression expression) {
        return null;
    }

    protected LocalQuickFix createRemoveAssignmentFix(PsiAssignmentExpression assignment) {
        return null;
    }

    protected LocalQuickFix createReplaceWithTrivialLambdaFix(Object value) {
        return null;
    }

    private void createDescription(StandardDataFlowRunner runner, ProblemsHolder holder, DataFlowInstructionVisitor visitor, PsiElement scope) {
        Pair<Set<Instruction>, Set<Instruction>> constConditions = runner.getConstConditionalExpressions();
        Set<Instruction> trueSet = constConditions.getFirst();
        Set<Instruction> falseSet = constConditions.getSecond();
        ArrayList<Instruction> allProblems = new ArrayList<Instruction>();
        allProblems.addAll(trueSet);
        allProblems.addAll(falseSet);
        allProblems.addAll(visitor.getClassCastExceptionInstructions());
        allProblems.addAll(ContainerUtil.filter(runner.getInstructions(), instruction1 -> instruction1 instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction1)));
        HashSet<PsiElement> reportedAnchors = new HashSet<PsiElement>();
        for (Instruction instruction : allProblems) {
            if (instruction instanceof TypeCastInstruction && reportedAnchors.add(((TypeCastInstruction)instruction).getCastExpression().getCastType())) {
                DataFlowInspectionBase.reportCastMayFail(holder, (TypeCastInstruction)instruction);
                continue;
            }
            if (!(instruction instanceof BranchingInstruction)) continue;
            this.handleBranchingInstruction(holder, visitor, trueSet, falseSet, reportedAnchors, (BranchingInstruction)instruction);
        }
        DataFlowInspectionBase.reportAlwaysFailingCalls(holder, visitor, reportedAnchors);
        this.reportConstantPushes(runner, holder, reportedAnchors);
        this.reportNullabilityProblems(holder, visitor, reportedAnchors);
        this.reportNullableReturns(visitor, holder, reportedAnchors, scope);
        if (this.SUGGEST_NULLABLE_ANNOTATIONS) {
            this.reportNullableArgumentsPassedToNonAnnotated(visitor, holder, reportedAnchors);
        }
        DataFlowInspectionBase.reportOptionalOfNullableImprovements(holder, reportedAnchors, visitor.getOfNullableCalls());
        this.reportUncheckedOptionalGet(holder, visitor.getOptionalCalls(), visitor.getOptionalQualifiers());
        visitor.getBooleanCalls().forEach((call, state) -> {
            if (state != ThreeState.UNSURE && reportedAnchors.add((PsiElement)call)) {
                this.reportConstantCondition(holder, (PsiElement)call, state.toBoolean());
            }
        });
        this.reportMethodReferenceProblems(holder, visitor);
        DataFlowInspectionBase.reportArrayAccessProblems(holder, visitor);
        DataFlowInspectionBase.reportArrayStoreProblems(holder, visitor);
        if (this.REPORT_CONSTANT_REFERENCE_VALUES) {
            this.reportConstantReferenceValues(holder, visitor, reportedAnchors);
        }
        if (this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL && visitor.isAlwaysReturnsNotNull(runner.getInstructions())) {
            this.reportAlwaysReturnsNotNull(holder, scope);
        }
        DataFlowInspectionBase.reportMutabilityViolations(holder, reportedAnchors, visitor.getMutabilityViolations(true), InspectionsBundle.message("dataflow.message.immutable.modified", new Object[0]));
        DataFlowInspectionBase.reportMutabilityViolations(holder, reportedAnchors, visitor.getMutabilityViolations(false), InspectionsBundle.message("dataflow.message.immutable.passed", new Object[0]));
        this.reportDuplicateAssignments(holder, reportedAnchors, visitor);
    }

    private void reportDuplicateAssignments(ProblemsHolder holder, HashSet<PsiElement> reportedAnchors, DataFlowInstructionVisitor visitor) {
        visitor.sameValueAssignments().forEach(expr -> {
            PsiReferenceExpression ref;
            PsiElement target;
            Object constValue;
            if (!reportedAnchors.add((PsiElement)expr)) {
                return;
            }
            PsiAssignmentExpression assignment = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiAssignmentExpression.class);
            Object context = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiForStatement.class, PsiClassInitializer.class);
            if (context instanceof PsiForStatement && PsiTreeUtil.isAncestor(((PsiForStatement)context).getInitialization(), expr, true)) {
                return;
            }
            if (context instanceof PsiClassInitializer && expr instanceof PsiReferenceExpression && assignment != null && (constValue = ExpressionUtils.computeConstantExpression(assignment.getRExpression())) == PsiTypesUtil.getDefaultValue(expr.getType()) && (target = (ref = (PsiReferenceExpression)expr).resolve()) instanceof PsiField && (((PsiField)target).hasModifierProperty("static") || ExpressionUtil.isEffectivelyUnqualified(ref)) && ((PsiField)target).getContainingClass() == ((PsiClassInitializer)context).getContainingClass()) {
                return;
            }
            holder.registerProblem((PsiElement)expr, InspectionsBundle.message("dataflow.message.redundant.assignment", new Object[0]), this.createRemoveAssignmentFix(assignment));
        });
    }

    private static void reportMutabilityViolations(ProblemsHolder holder, Set<PsiElement> reportedAnchors, Set<PsiElement> violations, String message) {
        for (PsiElement violation : violations) {
            if (!reportedAnchors.add(violation)) continue;
            holder.registerProblem(violation, message, new LocalQuickFix[0]);
        }
    }

    private void reportNullabilityProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor, HashSet<PsiElement> reportedAnchors) {
        visitor.problems().forEach(problem -> {
            if (NullabilityProblemKind.passingNullableArgumentToNonAnnotatedParameter.isMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem) || NullabilityProblemKind.nullableReturn.isMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem)) {
                return;
            }
            if (!reportedAnchors.add((PsiElement)problem.getAnchor())) {
                return;
            }
            NullabilityProblemKind.innerClassNPE.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, newExpression -> {
                List<LocalQuickFix> fixes = this.createNPEFixes(newExpression.getQualifier(), (PsiExpression)newExpression, holder.isOnTheFly());
                holder.registerProblem(DataFlowInspectionBase.getElementToHighlight(newExpression), problem.getMessage(), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            });
            NullabilityProblemKind.callMethodRefNPE.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, methodRef -> holder.registerProblem((PsiElement)methodRef, InspectionsBundle.message("dataflow.message.npe.methodref.invocation", new Object[0]), this.createMethodReferenceNPEFixes((PsiMethodReferenceExpression)methodRef).toArray(LocalQuickFix.EMPTY_ARRAY)));
            NullabilityProblemKind.callNPE.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, call -> this.reportCallMayProduceNpe(holder, (PsiMethodCallExpression)call));
            NullabilityProblemKind.passingNullableToNotNullParameter.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, expr -> this.reportNullableArgument(holder, (PsiElement)expr));
            NullabilityProblemKind.arrayAccessNPE.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, expression -> {
                LocalQuickFix[] fix = this.createNPEFixes(expression.getArrayExpression(), (PsiExpression)expression, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
                holder.registerProblem((PsiElement)expression, problem.getMessage(), fix);
            });
            NullabilityProblemKind.fieldAccessNPE.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, element -> {
                PsiElement parent = element.getParent();
                PsiExpression fieldAccess = parent instanceof PsiReferenceExpression ? (PsiExpression)parent : element;
                LocalQuickFix[] fix = this.createNPEFixes((PsiExpression)element, fieldAccess, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
                holder.registerProblem((PsiElement)element, problem.getMessage(), fix);
            });
            NullabilityProblemKind.unboxingNullable.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, element -> holder.registerProblem((PsiElement)element, problem.getMessage(), new LocalQuickFix[0]));
            NullabilityProblemKind.nullableFunctionReturn.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, expr -> holder.registerProblem((PsiElement)expr, problem.getMessage(), new LocalQuickFix[0]));
            NullabilityProblemKind.assigningToNotNull.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, expr -> this.reportNullabilityProblem(holder, (NullabilityProblemKind.NullabilityProblem<?>)problem, (PsiExpression)expr));
            NullabilityProblemKind.storingToNotNullArray.ifMyProblem((NullabilityProblemKind.NullabilityProblem<?>)problem, expr -> this.reportNullabilityProblem(holder, (NullabilityProblemKind.NullabilityProblem<?>)problem, (PsiExpression)expr));
        });
    }

    private void reportNullabilityProblem(ProblemsHolder holder, NullabilityProblemKind.NullabilityProblem<?> problem, PsiExpression expr) {
        holder.registerProblem((PsiElement)expr, problem.getMessage(), this.createNPEFixes(expr, expr, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static void reportArrayAccessProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor) {
        visitor.outOfBoundsArrayAccesses().forEach(access -> {
            PsiExpression indexExpression = access.getIndexExpression();
            if (indexExpression != null) {
                holder.registerProblem((PsiElement)indexExpression, InspectionsBundle.message("dataflow.message.array.index.out.of.bounds", new Object[0]), new LocalQuickFix[0]);
            }
        });
    }

    private static void reportArrayStoreProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor) {
        visitor.getArrayStoreProblems().forEach((assignment, types) -> holder.registerProblem((PsiElement)assignment.getOperationSign(), InspectionsBundle.message("dataflow.message.arraystore", ((PsiType)types.getFirst()).getCanonicalText(), ((PsiType)types.getSecond()).getCanonicalText()), new LocalQuickFix[0]));
    }

    private void reportMethodReferenceProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor) {
        visitor.getMethodReferenceResults().forEach((methodRef, dfaValue) -> {
            Object value;
            if (dfaValue instanceof DfaConstValue && (value = ((DfaConstValue)dfaValue).getValue()) instanceof Boolean) {
                holder.registerProblem((PsiElement)methodRef, InspectionsBundle.message("dataflow.message.constant.method.reference", value), this.createReplaceWithTrivialLambdaFix(value));
            }
        });
    }

    private void reportUncheckedOptionalGet(ProblemsHolder holder, Map<PsiMethodCallExpression, ThreeState> calls, List<PsiExpression> qualifiers) {
        if (!this.REPORT_UNCHECKED_OPTIONALS) {
            return;
        }
        for (Map.Entry<PsiMethodCallExpression, ThreeState> entry : calls.entrySet()) {
            PsiExpression qualifier;
            PsiClass optionalClass;
            PsiMethodCallExpression call;
            PsiMethod method;
            ThreeState state = entry.getValue();
            if (state != ThreeState.UNSURE || (method = (call = entry.getKey()).resolveMethod()) == null || (optionalClass = method.getContainingClass()) == null || (qualifier = PsiUtil.skipParenthesizedExprDown(call.getMethodExpression().getQualifierExpression())) instanceof PsiMethodCallExpression && qualifiers.stream().anyMatch(q -> PsiEquivalenceUtil.areElementsEquivalent(q, qualifier))) continue;
            SetInspectionOptionFix fix = holder.isOnTheFly() ? new SetInspectionOptionFix(this, "REPORT_UNCHECKED_OPTIONALS", InspectionsBundle.message("inspection.data.flow.turn.off.unchecked.optional.get.quickfix", new Object[0]), false) : null;
            holder.registerProblem(DataFlowInspectionBase.getElementToHighlight(call), InspectionsBundle.message("dataflow.message.optional.get.without.is.present", optionalClass.getName()), fix);
        }
    }

    private void reportAlwaysReturnsNotNull(ProblemsHolder holder, PsiElement scope) {
        if (!(scope.getParent() instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)scope.getParent();
        if (PsiUtil.canBeOverridden(method)) {
            return;
        }
        PsiAnnotation nullableAnno = NullableNotNullManager.getInstance(scope.getProject()).getNullableAnnotation(method, false);
        if (nullableAnno == null || !nullableAnno.isPhysical()) {
            return;
        }
        PsiJavaCodeReferenceElement annoName = nullableAnno.getNameReferenceElement();
        assert (annoName != null);
        String msg = "@" + NullableStuffInspectionBase.getPresentableAnnoName(nullableAnno) + " method '" + method.getName() + "' always returns a non-null value";
        LocalQuickFix[] fixes = new LocalQuickFix[]{new AddNotNullAnnotationFix(method)};
        if (holder.isOnTheFly()) {
            fixes = ArrayUtil.append(fixes, new SetInspectionOptionFix(this, "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL", InspectionsBundle.message("inspection.data.flow.turn.off.nullable.returning.notnull.quickfix", new Object[0]), false));
        }
        holder.registerProblem((PsiElement)annoName, msg, fixes);
    }

    private static void reportAlwaysFailingCalls(ProblemsHolder holder, DataFlowInstructionVisitor visitor, HashSet<PsiElement> reportedAnchors) {
        visitor.getAlwaysFailingCalls().forEach((call, contracts2) -> {
            if (TestUtils.isExceptionExpected(call)) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method != null && reportedAnchors.add((PsiElement)call)) {
                holder.registerProblem(DataFlowInspectionBase.getElementToHighlight(call), DataFlowInspectionBase.getContractMessage(contracts2), new LocalQuickFix[0]);
            }
        });
    }

    @NotNull
    private static String getContractMessage(List<MethodContract> contracts2) {
        if (contracts2.stream().allMatch(mc -> mc.getConditions().stream().allMatch(cv -> cv.isBoundCheckingCondition()))) {
            String string = InspectionsBundle.message("dataflow.message.contract.fail.index", new Object[0]);
            if (string == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = InspectionsBundle.message("dataflow.message.contract.fail", new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PsiCall call) {
        PsiJavaCodeReferenceElement ref;
        if (call == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(6);
        }
        if (call instanceof PsiNewExpression) {
            ref = ((PsiNewExpression)call).getClassReference();
        } else if (call instanceof PsiMethodCallExpression) {
            ref = ((PsiMethodCallExpression)call).getMethodExpression();
        } else {
            PsiCall psiCall = call;
            if (psiCall == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(7);
            }
            return psiCall;
        }
        if (ref != null) {
            PsiElement name = ref.getReferenceNameElement();
            PsiElement psiElement = name != null ? name : ref;
            if (psiElement == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        PsiCall psiCall = call;
        if (psiCall == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(9);
        }
        return psiCall;
    }

    private void reportConstantPushes(StandardDataFlowRunner runner, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (Instruction instruction : runner.getInstructions()) {
            Object constant;
            if (!(instruction instanceof PushInstruction)) continue;
            PsiExpression place = ((PushInstruction)instruction).getPlace();
            DfaValue value = ((PushInstruction)instruction).getValue();
            Object object = constant = value instanceof DfaConstValue ? ((DfaConstValue)value).getValue() : null;
            if (!(place instanceof PsiPolyadicExpression) || !(constant instanceof Boolean) || DataFlowInspectionBase.isFlagCheck(place) || !reportedAnchors.add(place)) continue;
            this.reportConstantCondition(holder, place, (Boolean)constant);
        }
    }

    private static void reportOptionalOfNullableImprovements(ProblemsHolder holder, Set<PsiElement> reportedAnchors, Map<MethodCallInstruction, ThreeState> nullArgs) {
        nullArgs.forEach((call, nullArg) -> {
            PsiElement arg = call.getArgumentAnchor(0);
            if (reportedAnchors.add(arg)) {
                switch (nullArg) {
                    case YES: {
                        holder.registerProblem(arg, "Passing <code>null</code> argument to <code>Optional</code>", DfaOptionalSupport.createReplaceOptionalOfNullableWithEmptyFix(arg));
                        break;
                    }
                    case NO: {
                        holder.registerProblem(arg, "Passing a non-null argument to <code>Optional</code>", DfaOptionalSupport.createReplaceOptionalOfNullableWithOfFix(arg));
                        break;
                    }
                }
            }
        });
    }

    private void reportConstantReferenceValues(ProblemsHolder holder, DataFlowInstructionVisitor visitor, Set<PsiElement> reportedAnchors) {
        for (Pair<PsiReferenceExpression, DfaConstValue> pair : visitor.getConstantReferenceValues()) {
            PsiReferenceExpression ref = (PsiReferenceExpression)pair.first;
            if (ref.getParent() instanceof PsiReferenceExpression || !reportedAnchors.add(ref)) continue;
            Object value = ((DfaConstValue)pair.second).getValue();
            PsiVariable constant = ((DfaConstValue)pair.second).getConstant();
            String presentableName = constant != null ? constant.getName() : String.valueOf(value);
            String exprText = String.valueOf(value);
            if (presentableName == null || exprText == null) continue;
            LocalQuickFix[] fixes = new LocalQuickFix[]{new ReplaceWithConstantValueFix(presentableName, exprText)};
            if (holder.isOnTheFly()) {
                fixes = ArrayUtil.append(fixes, new SetInspectionOptionFix(this, "REPORT_CONSTANT_REFERENCE_VALUES", InspectionsBundle.message("inspection.data.flow.turn.off.constant.references.quickfix", new Object[0]), false));
            }
            holder.registerProblem((PsiElement)ref, "Value <code>#ref</code> #loc is always '" + presentableName + "'", fixes);
        }
    }

    private void reportNullableArgumentsPassedToNonAnnotated(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.problems().map(NullabilityProblemKind.passingNullableArgumentToNonAnnotatedParameter::asMyProblem).nonNull().map(NullabilityProblemKind.NullabilityProblem::getAnchor)) {
            PsiParameter[] parameters;
            PsiMethod psiMethod;
            PsiElement gParent;
            int idx;
            if (reportedAnchors.contains(expr)) continue;
            if (expr.getParent() instanceof PsiMethodReferenceExpression) {
                holder.registerProblem(expr.getParent(), "Method reference argument might be null but passed to non annotated parameter", new LocalQuickFix[0]);
                continue;
            }
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? "Passing <code>null</code> argument to non annotated parameter" : "Argument <code>#ref</code> #loc might be null but passed to non annotated parameter";
            List<LocalQuickFix> fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            PsiElement parent = expr.getParent();
            if (!(parent instanceof PsiExpressionList) || (idx = ArrayUtilRt.find(((PsiExpressionList)parent).getExpressions(), expr)) <= -1 || !((gParent = parent.getParent()) instanceof PsiCallExpression) || (psiMethod = ((PsiCallExpression)gParent).resolveMethod()) == null || !psiMethod.getManager().isInProject(psiMethod) || !AnnotationUtil.isAnnotatingApplicable(psiMethod) || idx >= (parameters = psiMethod.getParameterList().getParameters()).length) continue;
            fixes.add(new AddNullableAnnotationFix(parameters[idx]));
            holder.registerProblem(expr, text2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            reportedAnchors.add(expr);
        }
    }

    private void reportCallMayProduceNpe(ProblemsHolder holder, PsiMethodCallExpression callExpression) {
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        List<LocalQuickFix> fixes = this.createNPEFixes(methodExpression.getQualifierExpression(), callExpression, holder.isOnTheFly());
        ContainerUtil.addIfNotNull(fixes, ReplaceWithObjectsEqualsFix.createFix(callExpression, methodExpression));
        PsiElement toHighlight = DataFlowInspectionBase.getElementToHighlight(callExpression);
        holder.registerProblem(toHighlight, InspectionsBundle.message("dataflow.message.npe.method.invocation", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static void reportCastMayFail(ProblemsHolder holder, TypeCastInstruction instruction) {
        PsiTypeCastExpression typeCast = instruction.getCastExpression();
        PsiExpression operand = typeCast.getOperand();
        PsiTypeElement castType = typeCast.getCastType();
        assert (castType != null);
        assert (operand != null);
        holder.registerProblem((PsiElement)castType, InspectionsBundle.message("dataflow.message.cce", operand.getText()), new LocalQuickFix[0]);
    }

    private void handleBranchingInstruction(ProblemsHolder holder, StandardInstructionVisitor visitor, Set<Instruction> trueSet, Set<Instruction> falseSet, HashSet<PsiElement> reportedAnchors, BranchingInstruction instruction) {
        PsiElement psiAnchor = instruction.getPsiAnchor();
        if (instruction instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction)) {
            if (visitor.canBeNull((BinopInstruction)instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.redundant.instanceof", new Object[0]), new RedundantInstanceofFix());
            } else {
                LocalQuickFix localQuickFix = this.createSimplifyBooleanExpressionFix(psiAnchor, true);
                String message = InspectionsBundle.message(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition", Boolean.toString(true));
                holder.registerProblem(psiAnchor, message, localQuickFix);
            }
        } else if (psiAnchor instanceof PsiSwitchLabelStatement) {
            if (falseSet.contains(instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.unreachable.switch.label", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (psiAnchor != null && !reportedAnchors.contains(psiAnchor) && !DataFlowInspectionBase.isFlagCheck(psiAnchor)) {
            boolean evaluatesToTrue = trueSet.contains(instruction);
            PsiElement parent = psiAnchor.getParent();
            if (parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getLExpression() == psiAnchor) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.pointless.assignment.expression", Boolean.toString(evaluatesToTrue)), this.createConditionalAssignmentFixes(evaluatesToTrue, (PsiAssignmentExpression)parent, holder.isOnTheFly()));
            } else {
                this.reportConstantCondition(holder, psiAnchor, evaluatesToTrue);
            }
            reportedAnchors.add(psiAnchor);
        }
    }

    private void reportConstantCondition(ProblemsHolder holder, PsiElement psiAnchor, boolean evaluatesToTrue) {
        if (psiAnchor.getParent() instanceof PsiForeachStatement) {
            if (!evaluatesToTrue) {
                return;
            }
            boolean array = psiAnchor instanceof PsiExpression && ((PsiExpression)psiAnchor).getType() instanceof PsiArrayType;
            holder.registerProblem(psiAnchor, array ? InspectionsBundle.message("dataflow.message.loop.on.empty.array", new Object[0]) : InspectionsBundle.message("dataflow.message.loop.on.empty.collection", new Object[0]), new LocalQuickFix[0]);
        } else if (psiAnchor instanceof PsiMethodReferenceExpression) {
            holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.constant.method.reference", evaluatesToTrue), this.createReplaceWithTrivialLambdaFix(evaluatesToTrue));
        } else {
            boolean isAssertion = DataFlowInspectionBase.isAssertionEffectively(psiAnchor, evaluatesToTrue);
            if (!this.DONT_REPORT_TRUE_ASSERT_STATEMENTS || !isAssertion) {
                ArrayList<SetInspectionOptionFix> fixes = new ArrayList<SetInspectionOptionFix>();
                ContainerUtil.addIfNotNull(fixes, this.createSimplifyBooleanExpressionFix(psiAnchor, evaluatesToTrue));
                if (isAssertion && holder.isOnTheFly()) {
                    fixes.add(new SetInspectionOptionFix(this, "DONT_REPORT_TRUE_ASSERT_STATEMENTS", InspectionsBundle.message("inspection.data.flow.turn.off.true.asserts.quickfix", new Object[0]), true));
                }
                String message = InspectionsBundle.message(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition", Boolean.toString(evaluatesToTrue));
                holder.registerProblem(psiAnchor, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression parent, boolean onTheFly) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private void reportNullableArgument(ProblemsHolder holder, PsiElement expr) {
        if (expr.getParent() instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expr.getParent();
            holder.registerProblem((PsiElement)methodRef, InspectionsBundle.message("dataflow.message.passing.nullable.argument.methodref", new Object[0]), this.createMethodReferenceNPEFixes(methodRef).toArray(LocalQuickFix.EMPTY_ARRAY));
        } else {
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.passing.null.argument", new Object[0]) : InspectionsBundle.message("dataflow.message.passing.nullable.argument", new Object[0]);
            List<LocalQuickFix> fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            holder.registerProblem(expr, text2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    @Nullable
    private static PsiMethod getScopeMethod(PsiElement block) {
        PsiElement parent = block.getParent();
        if (parent instanceof PsiMethod) {
            return (PsiMethod)parent;
        }
        if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    private void reportNullableReturns(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors, @NotNull PsiElement block) {
        PsiMethod method;
        if (block == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(10);
        }
        if ((method = DataFlowInspectionBase.getScopeMethod(block)) == null || NullableStuffInspectionBase.isNullableNotInferred(method, true)) {
            return;
        }
        PsiAnnotation notNullAnno = NullableNotNullManager.getInstance(method.getProject()).getNotNullAnnotation(method, true);
        if (notNullAnno == null && (!this.SUGGEST_NULLABLE_ANNOTATIONS || block.getParent() instanceof PsiLambdaExpression)) {
            return;
        }
        PsiType returnType = method.getReturnType();
        if (block instanceof PsiExpression && block.getParent() instanceof PsiLambdaExpression && PsiType.VOID.equals(returnType)) {
            return;
        }
        if (returnType == null || returnType.equalsToText("java.lang.Void")) {
            return;
        }
        for (NullabilityProblemKind.NullabilityProblem problem : visitor.problems().map(NullabilityProblemKind.nullableReturn::asMyProblem).nonNull()) {
            LocalQuickFix[] localQuickFixArray;
            String text2;
            PsiExpression expr = (PsiExpression)problem.getAnchor();
            if (!reportedAnchors.add(expr)) continue;
            if (notNullAnno != null) {
                String presentable = NullableStuffInspectionBase.getPresentableAnnoName(notNullAnno);
                String text3 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.return.null.from.notnull", presentable) : InspectionsBundle.message("dataflow.message.return.nullable.from.notnull", presentable);
                holder.registerProblem((PsiElement)expr, text3, new LocalQuickFix[0]);
                continue;
            }
            if (!AnnotationUtil.isAnnotatingApplicable(expr)) continue;
            NullableNotNullManager manager = NullableNotNullManager.getInstance(expr.getProject());
            String defaultNullable = manager.getDefaultNullable();
            String presentableNullable = StringUtil.getShortName(defaultNullable);
            String string = text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.return.null.from.notnullable", presentableNullable) : InspectionsBundle.message("dataflow.message.return.nullable.from.notnullable", presentableNullable);
            if (PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class, PsiLambdaExpression.class) instanceof PsiLambdaExpression) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new AnnotateMethodFix(defaultNullable, ArrayUtil.toStringArray(manager.getNotNulls()));
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem((PsiElement)expr, text2, fixes);
        }
    }

    private static boolean isAssertionEffectively(PsiElement psiAnchor, boolean evaluatesToTrue) {
        PsiStatement thenBranch;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(psiAnchor.getParent());
        if (parent instanceof PsiAssertStatement) {
            return evaluatesToTrue;
        }
        if (parent instanceof PsiIfStatement && psiAnchor == ((PsiIfStatement)parent).getCondition() && (thenBranch = ControlFlowUtils.stripBraces(((PsiIfStatement)parent).getThenBranch())) instanceof PsiThrowStatement) {
            return !evaluatesToTrue;
        }
        return false;
    }

    private static boolean isAtRHSOfBooleanAnd(PsiElement expr) {
        PsiElement cur = expr;
        while (cur != null && !(cur instanceof PsiMember)) {
            PsiElement parent = cur.getParent();
            if (parent instanceof PsiBinaryExpression && cur == ((PsiBinaryExpression)parent).getROperand()) {
                return true;
            }
            cur = parent;
        }
        return false;
    }

    private static boolean isFlagCheck(PsiElement element) {
        PsiExpression topExpression;
        Object scope = PsiTreeUtil.getParentOfType(element, PsiStatement.class, PsiVariable.class);
        PsiExpression psiExpression = scope instanceof PsiIfStatement ? ((PsiIfStatement)scope).getCondition() : (topExpression = scope instanceof PsiVariable ? ((PsiVariable)scope).getInitializer() : null);
        if (!PsiTreeUtil.isAncestor(topExpression, element, false)) {
            return false;
        }
        return StreamEx.ofTree((Object)topExpression, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(DataFlowInspectionBase::isCompileTimeFlagCheck);
    }

    private static boolean isCompileTimeFlagCheck(PsiElement element) {
        PsiBinaryExpression binOp;
        if (element instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation((binOp = (PsiBinaryExpression)element).getOperationTokenType())) {
            PsiBinaryExpression subOp;
            PsiExpression comparedWith = null;
            if (ExpressionUtils.isLiteral(binOp.getROperand())) {
                comparedWith = binOp.getLOperand();
            } else if (ExpressionUtils.isLiteral(binOp.getLOperand())) {
                comparedWith = binOp.getROperand();
            }
            comparedWith = PsiUtil.skipParenthesizedExprDown(comparedWith);
            if (DataFlowInspectionBase.isConstantOfType(comparedWith, PsiType.INT, PsiType.LONG)) {
                return true;
            }
            if (comparedWith instanceof PsiBinaryExpression && (subOp = (PsiBinaryExpression)comparedWith).getOperationTokenType().equals(JavaTokenType.AND)) {
                PsiExpression left = PsiUtil.skipParenthesizedExprDown(subOp.getLOperand());
                PsiExpression right = PsiUtil.skipParenthesizedExprDown(subOp.getROperand());
                if (DataFlowInspectionBase.isConstantOfType(left, PsiType.INT, PsiType.LONG) || DataFlowInspectionBase.isConstantOfType(right, PsiType.INT, PsiType.LONG)) {
                    return true;
                }
            }
        }
        return DataFlowInspectionBase.isConstantOfType(element, PsiType.BOOLEAN);
    }

    private static boolean isConstantOfType(PsiElement element, PsiPrimitiveType ... types) {
        PsiElement resolved;
        PsiElement psiElement = resolved = element instanceof PsiReferenceExpression ? ((PsiReferenceExpression)element).resolve() : null;
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiVariable field = (PsiVariable)resolved;
        return field.hasModifierProperty("static") && PsiUtil.isCompileTimeConstant(field) && ArrayUtil.contains(field.getType(), types);
    }

    private static boolean isNullLiteralExpression(PsiElement expr) {
        return expr instanceof PsiExpression && ExpressionUtils.isNullLiteral((PsiExpression)expr);
    }

    @Nullable
    private LocalQuickFix createSimplifyBooleanExpressionFix(PsiElement element, final boolean value) {
        LocalQuickFixOnPsiElement fix = this.createSimplifyBooleanFix(element, value);
        if (fix == null) {
            return null;
        }
        final String text2 = fix.getText();
        return new LocalQuickFix(){

            @Override
            @NotNull
            public String getName() {
                String string = text2;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement psiElement;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((psiElement = descriptor.getPsiElement()) == null) {
                    return;
                }
                LocalQuickFixOnPsiElement fix = DataFlowInspectionBase.this.createSimplifyBooleanFix(psiElement, value);
                if (fix == null) {
                    return;
                }
                try {
                    LOG.assertTrue(psiElement.isValid());
                    fix.applyFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }

            @Override
            @NotNull
            public String getFamilyName() {
                String string = InspectionsBundle.message("inspection.data.flow.simplify.boolean.expression.quickfix", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    protected static LocalQuickFix createSimplifyToAssignmentFix() {
        SimplifyToAssignmentFix simplifyToAssignmentFix = new SimplifyToAssignmentFix();
        if (simplifyToAssignmentFix == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(11);
        }
        return simplifyToAssignmentFix;
    }

    protected LocalQuickFixOnPsiElement createSimplifyBooleanFix(PsiElement element, boolean value) {
        return null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.data.flow.display.name", new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(14);
        }
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNPEFixes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractMessage";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimplifyToAssignmentFix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportNullableReturns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

