/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaFactMap {
    public static final DfaFactMap EMPTY = new DfaFactMap(KeyFMap.EMPTY_MAP);
    @NotNull
    private final KeyFMap myMap;

    private DfaFactMap(@NotNull KeyFMap map) {
        if (map == null) {
            DfaFactMap.$$$reportNull$$$0(0);
        }
        this.myMap = map;
    }

    @Nullable
    public <T> T get(@NotNull DfaFactType<T> type) {
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(1);
        }
        return this.myMap.get(type);
    }

    @NotNull
    public <T> DfaFactMap with(@NotNull DfaFactType<T> type, @Nullable T value) {
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(2);
        }
        KeyFMap newMap = value == null || type.isUnknown(value) ? this.myMap.minus(type) : this.myMap.plus(type, value);
        DfaFactMap dfaFactMap = newMap == this.myMap ? this : new DfaFactMap(newMap);
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(3);
        }
        return dfaFactMap;
    }

    public boolean isSuperStateOf(DfaFactMap subMap) {
        for (DfaFactType<?> key : DfaFactType.getTypes()) {
            Object other;
            Object thisValue;
            DfaFactType<?> type = key;
            if (type.isSuper(thisValue = this.myMap.get(type), other = subMap.get(type))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public <T> DfaFactMap intersect(@NotNull DfaFactType<T> type, @Nullable T value) {
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(4);
        }
        if (value == null) {
            return this;
        }
        T curFact = this.get(type);
        if (curFact == null) {
            return this.with(type, value);
        }
        T newFact = type.intersectFacts(curFact, value);
        return newFact == null ? null : this.with(type, newFact);
    }

    private <TT> DfaFactMap intersect(@NotNull DfaFactMap otherMap, @NotNull DfaFactType<TT> type) {
        if (otherMap == null) {
            DfaFactMap.$$$reportNull$$$0(5);
        }
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(6);
        }
        return this.intersect(type, otherMap.get(type));
    }

    @Nullable
    public DfaFactMap intersect(@NotNull DfaFactMap other) {
        if (other == null) {
            DfaFactMap.$$$reportNull$$$0(7);
        }
        DfaFactMap result2 = this;
        List<DfaFactType<?>> types = DfaFactType.getTypes();
        for (DfaFactType<?> type : types) {
            if ((result2 = result2.intersect(other, type)) != null) continue;
            return null;
        }
        return result2;
    }

    @NotNull
    public <T> DfaFactMap union(@NotNull DfaFactType<T> type, @Nullable T value) {
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(8);
        }
        if (value == null) {
            DfaFactMap dfaFactMap = this.with(type, null);
            if (dfaFactMap == null) {
                DfaFactMap.$$$reportNull$$$0(9);
            }
            return dfaFactMap;
        }
        T curFact = this.get(type);
        if (curFact == null) {
            DfaFactMap dfaFactMap = this;
            if (dfaFactMap == null) {
                DfaFactMap.$$$reportNull$$$0(10);
            }
            return dfaFactMap;
        }
        T newFact = type.unionFacts(curFact, value);
        DfaFactMap dfaFactMap = this.with(type, newFact);
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(11);
        }
        return dfaFactMap;
    }

    @NotNull
    private <TT> DfaFactMap union(DfaFactMap otherMap, @NotNull DfaFactType<TT> type) {
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(12);
        }
        DfaFactMap dfaFactMap = this.union(type, otherMap.get(type));
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(13);
        }
        return dfaFactMap;
    }

    @NotNull
    public DfaFactMap union(@NotNull DfaFactMap other) {
        if (other == null) {
            DfaFactMap.$$$reportNull$$$0(14);
        }
        DfaFactMap dfaFactMap = (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)this, (map, type) -> {
            if (other == null) {
                DfaFactMap.$$$reportNull$$$0(18);
            }
            return map.union(other, (DfaFactType)type);
        });
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(15);
        }
        return dfaFactMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DfaFactMap && this.myMap.equals(((DfaFactMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return StreamEx.of((Object[])this.myMap.getKeys()).map(key -> ((DfaFactType)key).toString(Objects.requireNonNull(this.myMap.get(key)))).joining((CharSequence)", ");
    }

    public static DfaFactMap calcFromVariable(@NotNull DfaVariableValue value) {
        if (value == null) {
            DfaFactMap.$$$reportNull$$$0(16);
        }
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)EMPTY, (factMap, type) -> {
            if (value == null) {
                DfaFactMap.$$$reportNull$$$0(17);
            }
            return DfaFactMap.updateMap(factMap, type, value);
        });
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map, DfaFactType<T> factType, DfaVariableValue value) {
        return map.with(factType, factType.calcFromVariable(value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMap";
                break;
            }
            case 7: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "with";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calcFromVariable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calcFromVariable$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$union$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

