/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaPsiUtil {
    public static boolean isFinalField(PsiVariable var) {
        return var.hasModifierProperty("final") && !var.hasModifierProperty("transient") && var instanceof PsiField;
    }

    static PsiElement getEnclosingCodeBlock(PsiVariable variable, PsiElement context) {
        PsiAnonymousClass anon;
        PsiElement codeBlock;
        if (variable instanceof PsiParameter) {
            codeBlock = ((PsiParameter)variable).getDeclarationScope();
            if (codeBlock instanceof PsiMethod) {
                codeBlock = ((PsiMethod)codeBlock).getBody();
            }
        } else {
            codeBlock = variable instanceof PsiLocalVariable ? PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class) : DfaPsiUtil.getTopmostBlockInSameClass(context);
        }
        while (codeBlock != null && (anon = PsiTreeUtil.getParentOfType(codeBlock, PsiAnonymousClass.class)) != null) {
            codeBlock = PsiTreeUtil.getParentOfType((PsiElement)anon, PsiCodeBlock.class);
        }
        return codeBlock;
    }

    @NotNull
    public static Nullness getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner) {
        Nullness nullness = DfaPsiUtil.getElementNullability(resultType, owner, false);
        if (nullness == null) {
            DfaPsiUtil.$$$reportNull$$$0(0);
        }
        return nullness;
    }

    @NotNull
    public static Nullness getElementNullabilityIgnoringParameterInference(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner) {
        Nullness nullness = DfaPsiUtil.getElementNullability(resultType, owner, true);
        if (nullness == null) {
            DfaPsiUtil.$$$reportNull$$$0(1);
        }
        return nullness;
    }

    @NotNull
    private static Nullness getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner, boolean ignoreParameterNullabilityInference) {
        PsiField field;
        if (owner == null) {
            Nullness nullness = DfaPsiUtil.getTypeNullability(resultType);
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(2);
            }
            return nullness;
        }
        if (resultType instanceof PsiPrimitiveType) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(3);
            }
            return nullness;
        }
        if (owner instanceof PsiEnumConstant || PsiUtil.isAnnotationMethod(owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(4);
            }
            return nullness;
        }
        if (owner instanceof PsiMethod && DfaPsiUtil.isEnumPredefinedMethod((PsiMethod)owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(5);
            }
            return nullness;
        }
        if (NullableNotNullManager.isNullable(owner)) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(6);
            }
            return nullness;
        }
        if (DfaPsiUtil.isNotNullLocally(owner, ignoreParameterNullabilityInference)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(7);
            }
            return nullness;
        }
        if (owner instanceof PsiMethod && DfaPsiUtil.isMapMethodWithUnknownNullity((PsiMethod)owner)) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(8);
            }
            return nullness;
        }
        Nullness fromType = DfaPsiUtil.getTypeNullability(resultType);
        if (fromType != Nullness.UNKNOWN) {
            Nullness nullness = fromType;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(9);
            }
            return nullness;
        }
        if (owner instanceof PsiParameter) {
            Nullness nullness = DfaPsiUtil.inferParameterNullability((PsiParameter)owner);
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(10);
            }
            return nullness;
        }
        if (owner instanceof PsiMethod && (field = PropertyUtil.getFieldOfGetter((PsiMethod)owner)) != null && DfaPsiUtil.getElementNullability(resultType, field) == Nullness.NULLABLE) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(11);
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaPsiUtil.$$$reportNull$$$0(12);
        }
        return nullness;
    }

    private static boolean isMapMethodWithUnknownNullity(@NotNull PsiMethod method) {
        String name;
        if (method == null) {
            DfaPsiUtil.$$$reportNull$$$0(13);
        }
        if (!"get".equals(name = method.getName()) && !"remove".equals(name)) {
            return false;
        }
        PsiMethod superMethod = DeepestSuperMethodsSearch.search(method).findFirst();
        return ("java.util.Map." + name).equals(PsiUtil.getMemberQualifiedName(superMethod != null ? superMethod : method));
    }

    @NotNull
    public static Nullness inferParameterNullability(@NotNull PsiParameter parameter) {
        PsiElement parent;
        if (parameter == null) {
            DfaPsiUtil.$$$reportNull$$$0(14);
        }
        if ((parent = parameter.getParent()) instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression) {
            Nullness nullness = DfaPsiUtil.getFunctionalParameterNullability((PsiLambdaExpression)parent.getParent(), ((PsiParameterList)parent).getParameterIndex(parameter));
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(15);
            }
            return nullness;
        }
        if (parent instanceof PsiForeachStatement) {
            Nullness nullness = DfaPsiUtil.getTypeNullability(DfaPsiUtil.inferLoopParameterTypeWithNullability((PsiForeachStatement)parent));
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(16);
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaPsiUtil.$$$reportNull$$$0(17);
        }
        return nullness;
    }

    @Nullable
    private static PsiType inferLoopParameterTypeWithNullability(PsiForeachStatement loop) {
        PsiForeachStatement targetLoop;
        PsiElement target;
        PsiExpression iteratedValue = PsiUtil.skipParenthesizedExprDown(loop.getIteratedValue());
        if (iteratedValue == null) {
            return null;
        }
        PsiType iteratedType = iteratedValue.getType();
        if (iteratedValue instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)iteratedValue).resolve()) instanceof PsiParameter && target.getParent() instanceof PsiForeachStatement && PsiTreeUtil.isAncestor(targetLoop = (PsiForeachStatement)target.getParent(), loop, true) && !HighlightControlFlowUtil.isReassigned((PsiParameter)target, new HashMap<PsiElement, Collection<ControlFlowUtil.VariableInfo>>())) {
            iteratedType = DfaPsiUtil.inferLoopParameterTypeWithNullability(targetLoop);
        }
        return JavaGenericsUtil.getCollectionItemType(iteratedType, iteratedValue.getResolveScope());
    }

    @NotNull
    public static Nullness getTypeNullability(@Nullable PsiType type) {
        if (type == null || type instanceof PsiPrimitiveType) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(18);
            }
            return nullness;
        }
        Ref<Nullness> result2 = Ref.create(Nullness.UNKNOWN);
        InheritanceUtil.processSuperTypes(type, true, eachType -> {
            result2.set(DfaPsiUtil.getTypeOwnNullability(eachType));
            return result2.get() == Nullness.UNKNOWN;
        });
        Nullness nullness = result2.get();
        if (nullness == null) {
            DfaPsiUtil.$$$reportNull$$$0(19);
        }
        return nullness;
    }

    @NotNull
    private static Nullness getTypeOwnNullability(PsiType eachType) {
        for (PsiAnnotation annotation : eachType.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            NullableNotNullManager nnn = NullableNotNullManager.getInstance(annotation.getProject());
            if (nnn.getNullables().contains(qualifiedName)) {
                Nullness nullness = Nullness.NULLABLE;
                if (nullness == null) {
                    DfaPsiUtil.$$$reportNull$$$0(20);
                }
                return nullness;
            }
            if (!nnn.getNotNulls().contains(qualifiedName)) continue;
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(21);
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaPsiUtil.$$$reportNull$$$0(22);
        }
        return nullness;
    }

    @NotNull
    public static Nullness getFunctionalParameterNullability(PsiFunctionalExpression function, int index) {
        Nullness nullness = DfaPsiUtil.inferLambdaParameterNullness(function, index);
        if (nullness != Nullness.UNKNOWN) {
            Nullness nullness2 = nullness;
            if (nullness2 == null) {
                DfaPsiUtil.$$$reportNull$$$0(23);
            }
            return nullness2;
        }
        PsiClassType type = ObjectUtils.tryCast(LambdaUtil.getFunctionalInterfaceType(function, true), PsiClassType.class);
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod(type);
        if (sam2 != null && index < sam2.getParameterList().getParametersCount()) {
            PsiParameter parameter = sam2.getParameterList().getParameters()[index];
            nullness = DfaPsiUtil.getElementNullability(null, parameter);
            if (nullness != Nullness.UNKNOWN) {
                Nullness nullness3 = nullness;
                if (nullness3 == null) {
                    DfaPsiUtil.$$$reportNull$$$0(24);
                }
                return nullness3;
            }
            PsiType parameterType = type.resolveGenerics().getSubstitutor().substitute(parameter.getType());
            Nullness nullness4 = DfaPsiUtil.getTypeNullability(GenericsUtil.eliminateWildcards(parameterType, false, true));
            if (nullness4 == null) {
                DfaPsiUtil.$$$reportNull$$$0(25);
            }
            return nullness4;
        }
        Nullness nullness5 = Nullness.UNKNOWN;
        if (nullness5 == null) {
            DfaPsiUtil.$$$reportNull$$$0(26);
        }
        return nullness5;
    }

    @NotNull
    private static Nullness inferLambdaParameterNullness(PsiFunctionalExpression lambda2, int parameterIndex) {
        PsiMethod method;
        PsiExpressionList list;
        PsiElement listParent;
        PsiElement expression = lambda2;
        PsiElement expressionParent = lambda2.getParent();
        while (expressionParent instanceof PsiConditionalExpression || expressionParent instanceof PsiParenthesizedExpression) {
            expression = expressionParent;
            expressionParent = expressionParent.getParent();
        }
        if (expressionParent instanceof PsiExpressionList && (listParent = (list = (PsiExpressionList)expressionParent).getParent()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)listParent).resolveMethod()) != null) {
            int expressionIndex = ArrayUtil.find(list.getExpressions(), expression);
            Nullness nullness = DfaPsiUtil.getLambdaParameterNullness(method, expressionIndex, parameterIndex);
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(27);
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaPsiUtil.$$$reportNull$$$0(28);
        }
        return nullness;
    }

    @NotNull
    private static Nullness getLambdaParameterNullness(@NotNull PsiMethod method, int parameterIndex, int lambdaParameterIndex) {
        String methodName;
        PsiClass type;
        if (method == null) {
            DfaPsiUtil.$$$reportNull$$$0(29);
        }
        if ((type = method.getContainingClass()) != null && "java.util.Optional".equals(type.getQualifiedName()) && ((methodName = method.getName()).equals("map") || methodName.equals("filter") || methodName.equals("ifPresent") || methodName.equals("flatMap")) && parameterIndex == 0 && lambdaParameterIndex == 0) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                DfaPsiUtil.$$$reportNull$$$0(30);
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaPsiUtil.$$$reportNull$$$0(31);
        }
        return nullness;
    }

    private static boolean isNotNullLocally(@NotNull PsiModifierListOwner owner, boolean ignoreParameterNullabilityInference) {
        NullableNotNullManager nnnm;
        PsiAnnotation notNullAnno;
        if (owner == null) {
            DfaPsiUtil.$$$reportNull$$$0(32);
        }
        if ((notNullAnno = (nnnm = NullableNotNullManager.getInstance(owner.getProject())).getNotNullAnnotation(owner, true)) == null || ignoreParameterNullabilityInference && owner instanceof PsiParameter && AnnotationUtil.isInferredAnnotation(notNullAnno)) {
            return false;
        }
        if (!(owner instanceof PsiParameter)) {
            return true;
        }
        return DfaPsiUtil.isOwnAnnotation(owner, notNullAnno) || nnnm.isContainerAnnotation(notNullAnno);
    }

    private static boolean isOwnAnnotation(@NotNull PsiModifierListOwner owner, @NotNull PsiAnnotation anno) {
        if (owner == null) {
            DfaPsiUtil.$$$reportNull$$$0(33);
        }
        if (anno == null) {
            DfaPsiUtil.$$$reportNull$$$0(34);
        }
        return AnnotationUtil.findAnnotation(owner, anno.getQualifiedName()) == anno;
    }

    private static boolean isEnumPredefinedMethod(PsiMethod method) {
        PsiClass containingClass;
        String methodName = method.getName();
        if (("valueOf".equals(methodName) || "values".equals(methodName)) && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && containingClass.isEnum()) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if ("values".equals(methodName)) {
                return parameters.length == 0;
            }
            return parameters.length == 1 && parameters[0].getType().equalsToText("java.lang.String");
        }
        return false;
    }

    public static boolean isInitializedNotNull(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod method : constructors) {
            if (DfaPsiUtil.getNotNullInitializedFields(method, containingClass).contains(field)) continue;
            return false;
        }
        return true;
    }

    private static Set<PsiField> getNotNullInitializedFields(final PsiMethod constructor, final PsiClass containingClass) {
        if (!constructor.getLanguage().isKindOf(JavaLanguage.INSTANCE)) {
            return Collections.emptySet();
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return Collections.emptySet();
        }
        return CachedValuesManager.getCachedValue(constructor, new CachedValueProvider<Set<PsiField>>(){

            @Override
            @NotNull
            public CachedValueProvider.Result<Set<PsiField>> compute() {
                PsiCodeBlock body = constructor.getBody();
                final HashMap map = ContainerUtil.newHashMap();
                StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(false, false){

                    private boolean isCallExposingNonInitializedFields(Instruction instruction) {
                        PsiExpression qualifier;
                        if (!(instruction instanceof MethodCallInstruction) || ((MethodCallInstruction)instruction).getMethodType() != MethodCallInstruction.MethodType.REGULAR_METHOD_CALL) {
                            return false;
                        }
                        PsiCall call = ((MethodCallInstruction)instruction).getCallExpression();
                        if (call == null) {
                            return false;
                        }
                        if (call instanceof PsiNewExpression && this.canAccessFields((PsiExpression)((Object)call))) {
                            return true;
                        }
                        if (call instanceof PsiMethodCallExpression && ((qualifier = ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression()) == null || this.canAccessFields(qualifier))) {
                            return true;
                        }
                        PsiExpressionList argumentList = call.getArgumentList();
                        if (argumentList != null) {
                            for (PsiExpression expression : argumentList.getExpressions()) {
                                if (!this.canAccessFields(expression)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean canAccessFields(PsiExpression expression) {
                        PsiClass type = PsiUtil.resolveClassInClassTypeOnly(expression.getType());
                        JBIterable<PsiClass> typeContainers = JBIterable.generate(type, PsiClass::getContainingClass).takeWhile(c -> !c.hasModifierProperty("static"));
                        return typeContainers.contains(containingClass);
                    }

                    @Override
                    @NotNull
                    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
                        Instruction instruction;
                        if (visitor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (instructionState == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (this.isCallExposingNonInitializedFields(instruction = instructionState.getInstruction()) || instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
                            for (PsiField field : containingClass.getFields()) {
                                if (!instructionState.getMemoryState().isNotNull(this.getFactory().getVarFactory().createVariableValue(field, false))) {
                                    map.put(field, false);
                                    continue;
                                }
                                if (map.containsKey(field)) continue;
                                map.put(field, true);
                            }
                            if (DfaInstructionState.EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return DfaInstructionState.EMPTY_ARRAY;
                        }
                        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
                        if (dfaInstructionStateArray == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return dfaInstructionStateArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: 
                            case 3: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: 
                            case 3: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "visitor";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "instructionState";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "acceptInstruction";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "acceptInstruction";
                                break;
                            }
                            case 2: 
                            case 3: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: 
                            case 3: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                RunnerResult rc = dfaRunner.analyzeMethod(body, new StandardInstructionVisitor());
                HashSet notNullFields = ContainerUtil.newHashSet();
                if (rc == RunnerResult.OK) {
                    for (PsiField field : map.keySet()) {
                        if (!((Boolean)map.get(field)).booleanValue()) continue;
                        notNullFields.add(field);
                    }
                }
                CachedValueProvider.Result<Set<PsiField>> result2 = CachedValueProvider.Result.create(notNullFields, constructor, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1", "compute"));
            }
        });
    }

    public static List<PsiExpression> findAllConstructorInitializers(PsiField field) {
        List<PsiExpression> result2 = ContainerUtil.createLockFreeCopyOnWriteList();
        ContainerUtil.addIfNotNull(result2, field.getInitializer());
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !(containingClass instanceof PsiCompiledElement)) {
            result2.addAll(DfaPsiUtil.getAllConstructorFieldInitializers(containingClass).get(field));
        }
        return result2;
    }

    private static MultiMap<PsiField, PsiExpression> getAllConstructorFieldInitializers(final PsiClass psiClass) {
        if (psiClass instanceof PsiCompiledElement) {
            return MultiMap.empty();
        }
        return CachedValuesManager.getCachedValue(psiClass, new CachedValueProvider<MultiMap<PsiField, PsiExpression>>(){

            @Override
            @NotNull
            public CachedValueProvider.Result<MultiMap<PsiField, PsiExpression>> compute() {
                final HashSet fieldNames = ContainerUtil.newHashSet();
                for (PsiField field : psiClass.getFields()) {
                    ContainerUtil.addIfNotNull(fieldNames, field.getName());
                }
                final MultiMap result2 = new MultiMap();
                JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                    @Override
                    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                        PsiElement target;
                        super.visitAssignmentExpression(assignment);
                        PsiExpression lExpression = assignment.getLExpression();
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression != null && lExpression instanceof PsiReferenceExpression && fieldNames.contains(((PsiReferenceExpression)lExpression).getReferenceName()) && (target = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField && ((PsiField)target).getContainingClass() == psiClass) {
                            result2.putValue((PsiField)target, rExpression);
                        }
                    }
                };
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    if (!constructor.getLanguage().isKindOf(JavaLanguage.INSTANCE)) continue;
                    constructor.accept(visitor);
                }
                CachedValueProvider.Result<MultiMap<PsiField, PsiExpression>> result3 = CachedValueProvider.Result.create(result2, psiClass);
                if (result3 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$2", "compute"));
            }
        });
    }

    @Nullable
    public static PsiElement getTopmostBlockInSameClass(@NotNull PsiElement position) {
        if (position == null) {
            DfaPsiUtil.$$$reportNull$$$0(35);
        }
        return JBIterable.generate(position, PsiElement::getParent).takeWhile(e -> !(e instanceof PsiMember) && !(e instanceof PsiFile) && !(e instanceof PsiLambdaExpression)).filter(e -> e instanceof PsiCodeBlock || e instanceof PsiExpression && e.getParent() instanceof PsiLambdaExpression).last();
    }

    @NotNull
    public static Collection<PsiExpression> getVariableAssignmentsInFile(@NotNull PsiVariable psiVariable, boolean literalsOnly, PsiElement place) {
        if (psiVariable == null) {
            DfaPsiUtil.$$$reportNull$$$0(36);
        }
        Ref<Boolean> modificationRef = Ref.create(Boolean.FALSE);
        PsiElement codeBlock = place == null ? null : DfaPsiUtil.getTopmostBlockInSameClass(place);
        int placeOffset = codeBlock != null ? place.getTextRange().getStartOffset() : 0;
        PsiFile containingFile = psiVariable.getContainingFile();
        LocalSearchScope scope = new LocalSearchScope(new PsiElement[]{containingFile}, null, true);
        Collection<PsiReference> references = ReferencesSearch.search(psiVariable, scope).findAll();
        List<PsiExpression> list = ContainerUtil.mapNotNull(references, psiReference -> {
            if (((Boolean)modificationRef.get()).booleanValue()) {
                return null;
            }
            PsiElement parent = psiReference.getElement().getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                IElementType operation = assignmentExpression.getOperationTokenType();
                if (assignmentExpression.getLExpression() == psiReference) {
                    if (JavaTokenType.EQ.equals(operation)) {
                        PsiExpression rValue = assignmentExpression.getRExpression();
                        if (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(rValue)) {
                            if (codeBlock != null && PsiTreeUtil.isAncestor(codeBlock, parent, true) && placeOffset < parent.getTextRange().getStartOffset()) {
                                return null;
                            }
                            return rValue;
                        }
                        modificationRef.set(Boolean.TRUE);
                    } else if (JavaTokenType.PLUSEQ.equals(operation)) {
                        modificationRef.set(Boolean.TRUE);
                    }
                }
            }
            return null;
        });
        if (modificationRef.get().booleanValue()) {
            List<PsiExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                DfaPsiUtil.$$$reportNull$$$0(37);
            }
            return list2;
        }
        PsiExpression initializer = psiVariable.getInitializer();
        if (initializer != null && (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(initializer))) {
            list = ContainerUtil.concat(list, Collections.singletonList(initializer));
        }
        List<PsiExpression> list3 = list;
        if (list3 == null) {
            DfaPsiUtil.$$$reportNull$$$0(38);
        }
        return list3;
    }

    private static boolean allOperandsAreLiterals(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiPolyadicExpression) {
            Stack<PsiExpression> stack = new Stack<PsiExpression>();
            stack.add(expression);
            while (!stack.isEmpty()) {
                PsiExpression psiExpression = (PsiExpression)stack.pop();
                if (psiExpression instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)psiExpression;
                    for (PsiExpression op : binaryExpression.getOperands()) {
                        stack.push(op);
                    }
                    continue;
                }
                if (psiExpression instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 13: 
            case 14: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 13: 
            case 14: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil";
                break;
            }
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementNullability";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementNullabilityIgnoringParameterInference";
                break;
            }
            case 13: 
            case 14: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "inferParameterNullability";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNullability";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOwnNullability";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionalParameterNullability";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "inferLambdaParameterNullness";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLambdaParameterNullness";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableAssignmentsInFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMapMethodWithUnknownNullity";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferParameterNullability";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaParameterNullness";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullLocally";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isOwnAnnotation";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostBlockInSameClass";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getVariableAssignmentsInFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

