/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SpecialField {
    ARRAY_LENGTH(null, "length", true, LongRangeSet.indexRange()){

        @Override
        public boolean isMyAccessor(PsiModifierListOwner accessor) {
            return accessor instanceof PsiField && "length".equals(((PsiField)accessor).getName()) && JavaPsiFacade.getElementFactory(accessor.getProject()).getArrayClass(PsiUtil.getLanguageLevel(accessor)) == ((PsiField)accessor).getContainingClass();
        }

        @Override
        DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
            if (initializer instanceof PsiArrayInitializerExpression) {
                return factory.getInt(((PsiArrayInitializerExpression)initializer).getInitializers().length);
            }
            if (initializer instanceof PsiNewExpression) {
                Object length;
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                if (arrayInitializer != null) {
                    return factory.getInt(arrayInitializer.getInitializers().length);
                }
                PsiExpression[] dimensions = ((PsiNewExpression)initializer).getArrayDimensions();
                if (dimensions.length > 0 && (length = ExpressionUtils.computeConstantExpression(dimensions[0])) instanceof Integer) {
                    return factory.getInt((Integer)length);
                }
            }
            return null;
        }

        @Override
        @Nullable
        PsiModifierListOwner getCanonicalOwner(@Nullable PsiModifierListOwner qualifier, @Nullable PsiClass psiClass) {
            if (qualifier == null) {
                return null;
            }
            PsiClass arrayClass = JavaPsiFacade.getElementFactory(qualifier.getProject()).getArrayClass(PsiUtil.getLanguageLevel(qualifier));
            return arrayClass.findFieldByName("length", false);
        }

        @Override
        public String toString() {
            return "Array.length";
        }
    }
    ,
    STRING_LENGTH("java.lang.String", "length", true, LongRangeSet.indexRange()){

        @Override
        DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
            Object value = ExpressionUtils.computeConstantExpression(initializer);
            if (value instanceof String) {
                return factory.getInt(((String)value).length());
            }
            return null;
        }

        @Override
        public DfaValue fromConstant(DfaValueFactory factory, @NotNull Object obj) {
            if (obj == null) {
                2.$$$reportNull$$$0(0);
            }
            return obj instanceof String ? factory.getInt(((String)obj).length()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/codeInspection/dataFlow/SpecialField$2", "fromConstant"));
        }
    }
    ,
    COLLECTION_SIZE("java.util.Collection", "size", false, LongRangeSet.indexRange()),
    MAP_SIZE("java.util.Map", "size", false, LongRangeSet.indexRange());

    private final String myClassName;
    private final String myMethodName;
    private final boolean myFinal;
    private final LongRangeSet myRange;

    private SpecialField(String className, String methodName, boolean isFinal, LongRangeSet range) {
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myFinal = isFinal;
        this.myRange = range;
    }

    public boolean isFinal() {
        return this.myFinal;
    }

    public LongRangeSet getRange() {
        return this.myRange;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public boolean isMyAccessor(PsiModifierListOwner accessor) {
        return accessor instanceof PsiMethod && MethodUtils.methodMatches((PsiMethod)accessor, this.myClassName, null, this.myMethodName, new PsiType[0]);
    }

    @Nullable
    PsiModifierListOwner getCanonicalOwner(@Nullable PsiModifierListOwner qualifier, @Nullable PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            return null;
        }
        if (!this.myClassName.equals(psiClass.getQualifiedName())) {
            PsiClass myClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(this.myClassName, psiClass.getResolveScope());
            if (!InheritanceUtil.isInheritorOrSelf(psiClass, myClass, true)) {
                return null;
            }
            psiClass = myClass;
        }
        return (methods = psiClass.findMethodsByName(this.myMethodName, false)).length == 1 ? methods[0] : null;
    }

    public DfaValue createValue(DfaValueFactory factory, DfaValue qualifier) {
        DfaValue value;
        Object obj;
        if (qualifier instanceof DfaVariableValue) {
            DfaValue value2;
            PsiExpression initializer;
            DfaVariableValue variableValue = (DfaVariableValue)qualifier;
            PsiModifierListOwner psiVariable = variableValue.getPsiVariable();
            if (factory.isHonorFieldInitializers() && psiVariable instanceof PsiField && psiVariable.hasModifierProperty("static") && psiVariable.hasModifierProperty("final") && (initializer = ((PsiField)psiVariable).getInitializer()) != null && (value2 = this.fromInitializer(factory, initializer)) != null) {
                return value2;
            }
            PsiModifierListOwner owner = this.getCanonicalOwner(psiVariable, PsiUtil.resolveClassInClassTypeOnly(variableValue.getVariableType()));
            if (owner != null) {
                return factory.getVarFactory().createVariableValue(owner, PsiType.INT, false, variableValue);
            }
        }
        if (qualifier instanceof DfaConstValue && (obj = ((DfaConstValue)qualifier).getValue()) != null && (value = this.fromConstant(factory, obj)) != null) {
            return value;
        }
        return factory.getFactValue(DfaFactType.RANGE, this.myRange);
    }

    DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
        return null;
    }

    DfaValue fromConstant(DfaValueFactory factory, @NotNull Object obj) {
        if (obj == null) {
            SpecialField.$$$reportNull$$$0(0);
        }
        return null;
    }

    public List<MethodContract> getEmptyContracts() {
        ContractValue thisValue = ContractValue.qualifier().specialField(this);
        return Arrays.asList(MethodContract.singleConditionContract(thisValue, DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.TRUE_VALUE), MethodContract.trivialContract(MethodContract.ValueConstraint.FALSE_VALUE));
    }

    public List<MethodContract> getEqualsContracts() {
        return Arrays.asList(new StandardMethodContract(new MethodContract.ValueConstraint[]{MethodContract.ValueConstraint.NULL_VALUE}, MethodContract.ValueConstraint.FALSE_VALUE), MethodContract.singleConditionContract(ContractValue.qualifier().specialField(this), DfaRelationValue.RelationType.NE, ContractValue.argument(0).specialField(this), MethodContract.ValueConstraint.FALSE_VALUE));
    }

    public String toString() {
        return StringUtil.getShortName(this.myClassName) + "." + this.myMethodName + "()";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/codeInspection/dataFlow/SpecialField", "fromConstant"));
    }
}

