/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryModuleDependencyAnnotator
extends RefGraphAnnotator {
    public static final Key<Set<Module>> DEPENDENCIES = Key.create("inspection.dependencies");
    private final RefManager myManager;

    public UnnecessaryModuleDependencyAnnotator(RefManager manager) {
        this.myManager = manager;
    }

    @Override
    public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
        if (what != null && from != null) {
            RefModule refModule;
            Module fromModule = ModuleUtilCore.findModuleForFile(from.getContainingFile());
            Set<Module> onModules = UnnecessaryModuleDependencyAnnotator.getAllPossibleWhatModules(what);
            if (onModules != null && fromModule != null && (refModule = this.myManager.getRefModule(fromModule)) != null) {
                HashSet<Module> modules = new HashSet<Module>(onModules);
                UnnecessaryModuleDependencyAnnotator.collectRequiredModulesInHierarchy(what, modules);
                modules.remove(fromModule);
                UnnecessaryModuleDependencyAnnotator.getModules(refModule).addAll(modules);
            }
        }
    }

    @Override
    public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
        RefModule fromModule = refFrom.getModule();
        RefModule whatModule = refWhat.getModule();
        if (fromModule != null && whatModule != null) {
            Set<Module> currentFromModules = UnnecessaryModuleDependencyAnnotator.getModules(fromModule);
            currentFromModules.add(whatModule.getModule());
            Set<Module> modules = refWhat.getUserData(DEPENDENCIES);
            if (modules != null) {
                currentFromModules.addAll(modules);
            }
        }
    }

    @Override
    public void onInitialize(RefElement refElement) {
        PsiElement element = refElement.getElement();
        RefModule refModule = refElement.getModule();
        if (refModule != null) {
            HashSet<Module> modules = new HashSet<Module>();
            UnnecessaryModuleDependencyAnnotator.collectRequiredModulesInHierarchy(element, modules);
            modules.remove(refModule.getModule());
            if (!modules.isEmpty()) {
                refElement.putUserData(DEPENDENCIES, modules);
                UnnecessaryModuleDependencyAnnotator.getModules(refModule).addAll(modules);
            }
        }
    }

    private static void collectRequiredModulesInHierarchy(PsiElement element, Set<Module> modules) {
        PsiClass aClass;
        if (element instanceof PsiClass) {
            UnnecessaryModuleDependencyAnnotator.processClassHierarchy((PsiClass)element, modules);
        } else if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            HashSet<PsiClass> classes = new HashSet<PsiClass>();
            UnnecessaryModuleDependencyAnnotator.processTypeHierarchy(classes, method.getReturnType(), modules);
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                UnnecessaryModuleDependencyAnnotator.processTypeHierarchy(classes, parameter.getType(), modules);
            }
        } else if (element instanceof PsiField && (aClass = PsiUtil.resolveClassInType(((PsiField)element).getType())) != null) {
            UnnecessaryModuleDependencyAnnotator.processClassHierarchy(aClass, modules);
        }
    }

    private static void processTypeHierarchy(Set<PsiClass> classes, PsiType returnType, Set<Module> modules) {
        PsiClass aClass = PsiUtil.resolveClassInType(returnType);
        if (aClass != null && classes.add(aClass)) {
            UnnecessaryModuleDependencyAnnotator.processClassHierarchy(aClass, modules);
        }
    }

    private static void processClassHierarchy(PsiClass currentClass, Set<Module> modules) {
        LinkedHashSet<PsiClass> superClasses = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses(currentClass, superClasses, false);
        for (PsiClass superClass : superClasses) {
            Set<Module> onModules = UnnecessaryModuleDependencyAnnotator.getAllPossibleWhatModules(superClass);
            if (onModules == null) continue;
            modules.addAll(onModules);
        }
    }

    private static Set<Module> getAllPossibleWhatModules(@NotNull PsiElement what) {
        VirtualFile vFile;
        if (what == null) {
            UnnecessaryModuleDependencyAnnotator.$$$reportNull$$$0(0);
        }
        if ((vFile = PsiUtilCore.getVirtualFile(what)) == null) {
            return null;
        }
        Project project = what.getProject();
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
            List<OrderEntry> orderEntries = fileIndex.getOrderEntriesForFile(vFile);
            if (orderEntries.isEmpty()) {
                return null;
            }
            HashSet<Module> modules = new HashSet<Module>();
            for (OrderEntry orderEntry : orderEntries) {
                modules.add(orderEntry.getOwnerModule());
            }
            return modules;
        }
        Module module = ModuleUtilCore.findModuleForFile(vFile, project);
        return module != null ? Collections.singleton(module) : null;
    }

    private static Set<Module> getModules(RefModule refModule) {
        Set<Module> modules = refModule.getUserData(DEPENDENCIES);
        if (modules == null) {
            modules = new HashSet<Module>();
            refModule.putUserData(DEPENDENCIES, modules);
        }
        return modules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyAnnotator", "getAllPossibleWhatModules"));
    }
}

