/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ExternalModuleListStorageKt;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalModuleListStorage", storages={@Storage(value="modules.xml")}, externalStorageOnly=true)
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R4\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/module/impl/ExternalModuleListStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/roots/ProjectModelElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "", "Lcom/intellij/openapi/module/impl/ModulePath;", "loadedState", "getLoadedState", "()Ljava/util/Set;", "setLoadedState", "(Ljava/util/Set;)V", "getExternalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getState", "loadState", "", "state", "projectModel-impl"})
public final class ExternalModuleListStorage
implements PersistentStateComponent<Element>,
ProjectModelElement {
    @Nullable
    private Set<ModulePath> loadedState;
    private final Project project;

    @Nullable
    public final Set<ModulePath> getLoadedState() {
        return this.loadedState;
    }

    private final void setLoadedState(Set<ModulePath> set) {
        this.loadedState = set;
    }

    @Override
    @NotNull
    public Element getState() {
        Element e = new Element("state");
        if (!ProjectUtilCore.isExternalStorageEnabled(this.project)) {
            return e;
        }
        ModuleManagerImpl moduleManager = ModuleManagerImpl.getInstanceImpl(this.project);
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"moduleManager.modules");
        moduleManager.writeExternal(e, ExternalModuleListStorageKt.getFilteredModuleList(this.project, moduleArray, true));
        return e;
    }

    @Override
    public void loadState(@NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.loadedState = ModuleManagerImpl.getPathsToModuleFiles(state);
    }

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        ExternalProjectSystemRegistry externalProjectSystemRegistry = ExternalProjectSystemRegistry.getInstance();
        for (Module module : ModuleManagerImpl.getInstanceImpl(this.project).getModules()) {
            ProjectModelExternalSource projectModelExternalSource;
            ProjectModelExternalSource projectModelExternalSource2 = externalProjectSystemRegistry.getExternalSource(module);
            if (projectModelExternalSource2 == null) continue;
            ProjectModelExternalSource it = projectModelExternalSource = projectModelExternalSource2;
            return it;
        }
        return null;
    }

    public ExternalModuleListStorage(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

