/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.impl.ModulePointerImpl;
import com.intellij.openapi.module.impl.ModuleRenamingHistoryState;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@State(name="ModuleRenamingHistory", storages={@Storage(value="modules.xml")})
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u001a\u0010\u001d\u001a\u00020\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001fJ\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J \u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/module/impl/ModulePointerManagerImpl;", "Lcom/intellij/openapi/module/ModulePointerManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/module/impl/ModuleRenamingHistoryState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "oldToNewName", "Lgnu/trove/THashMap;", "", "pointers", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/module/Module;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/module/impl/ModulePointerImpl;", "unresolved", "create", "Lcom/intellij/openapi/module/ModulePointer;", "module", "moduleName", "getState", "loadState", "", "state", "moduleAppears", "registerPointer", "pointer", "setRenamingScheme", "renamingScheme", "", "unregisterPointer", "updateUnresolvedPointers", "oldName", "newName", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "projectModel-impl"})
public final class ModulePointerManagerImpl
extends ModulePointerManager
implements PersistentStateComponent<ModuleRenamingHistoryState> {
    private final MultiMap<String, ModulePointerImpl> unresolved;
    private final MultiMap<Module, ModulePointerImpl> pointers;
    private final ReentrantReadWriteLock lock;
    private final THashMap<String, String> oldToNewName;
    private final Project project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModuleRenamingHistoryState getState() {
        ModuleRenamingHistoryState moduleRenamingHistoryState;
        ModuleRenamingHistoryState $receiver = moduleRenamingHistoryState = new ModuleRenamingHistoryState();
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            $receiver.oldToNewName.putAll((Map)this.oldToNewName);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return moduleRenamingHistoryState;
    }

    @Override
    public void loadState(@NotNull ModuleRenamingHistoryState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.setRenamingScheme((Map<String, String>)state.oldToNewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRenamingScheme(@NotNull Map<String, String> renamingScheme) {
        int n;
        Intrinsics.checkParameterIsNotNull(renamingScheme, (String)"renamingScheme");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.oldToNewName.clear();
            this.oldToNewName.putAll(renamingScheme);
            ModuleManager moduleManager = ModuleManager.getInstance(this.project);
            Iterable $receiver$iv = renamingScheme.entrySet();
            for (Object element$iv : $receiver$iv) {
                Map.Entry $oldName_newName;
                Map.Entry entry = $oldName_newName = (Map.Entry)element$iv;
                String oldName = (String)entry.getKey();
                entry = $oldName_newName;
                String newName = (String)entry.getValue();
                Module oldModule = moduleManager.findModuleByName(oldName);
                if (oldModule != null) {
                    this.unregisterPointer(oldModule);
                }
                ModuleManager moduleManager2 = moduleManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager2, (String)"moduleManager");
                this.updateUnresolvedPointers(oldName, newName, moduleManager2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    private final void updateUnresolvedPointers(String oldName, String newName, ModuleManager moduleManager) {
        Collection<ModulePointerImpl> pointers;
        Collection<ModulePointerImpl> collection = pointers = this.unresolved.remove(oldName);
        if (collection != null) {
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                ModulePointerImpl pointer = (ModulePointerImpl)element$iv;
                pointer.renameUnresolved$projectModel_impl(newName);
                Module module = moduleManager.findModuleByName(newName);
                if (module != null) {
                    pointer.moduleAdded$projectModel_impl(module);
                    ModulePointerImpl modulePointerImpl = pointer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)modulePointerImpl, (String)"pointer");
                    this.registerPointer(module, modulePointerImpl);
                    continue;
                }
                this.unresolved.putValue(newName, pointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void moduleAppears(Module module) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = 0;
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = n3 - 1;
        if (n2 <= n4) {
            do {
                n = ++n2;
                readLock.unlock();
            } while (n2 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Unit unit;
            Collection<ModulePointerImpl> collection = this.unresolved.remove(module.getName());
            if (collection != null) {
                Iterable $receiver$iv = collection;
                for (Object element$iv : $receiver$iv) {
                    ModulePointerImpl it = (ModulePointerImpl)element$iv;
                    it.moduleAdded$projectModel_impl(module);
                    ModulePointerImpl modulePointerImpl = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)modulePointerImpl, (String)"it");
                    this.registerPointer(module, modulePointerImpl);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            n = 0;
            int n5 = n3 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    private final void registerPointer(Module module, ModulePointerImpl pointer) {
        this.pointers.putValue(module, pointer);
        Disposer.register(module, new Disposable(this, module){
            final /* synthetic */ ModulePointerManagerImpl this$0;
            final /* synthetic */ Module $module;

            public final void dispose() {
                ModulePointerManagerImpl.access$unregisterPointer(this.this$0, this.$module);
            }
            {
                this.this$0 = modulePointerManagerImpl;
                this.$module = module;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unregisterPointer(Module module) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = 0;
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = n3 - 1;
        if (n2 <= n4) {
            do {
                n = ++n2;
                readLock.unlock();
            } while (n2 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Unit unit;
            Collection<ModulePointerImpl> collection = this.pointers.remove(module);
            if (collection != null) {
                Iterable $receiver$iv = collection;
                for (Object element$iv : $receiver$iv) {
                    ModulePointerImpl it = (ModulePointerImpl)element$iv;
                    it.moduleRemoved$projectModel_impl(module);
                    this.unresolved.putValue(it.getModuleName(), it);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            n = 0;
            int n5 = n3 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModulePointer create(@NotNull Module module) {
        ModulePointer modulePointer;
        ModulePointerImpl modulePointerImpl;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            ModulePointerImpl modulePointerImpl2 = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)this.pointers.get(module));
            modulePointerImpl = modulePointerImpl2;
        }
        finally {
            readLock.unlock();
        }
        if (modulePointerImpl != null) {
            modulePointer = modulePointerImpl;
        } else {
            ModulePointerImpl modulePointerImpl3;
            int n;
            reentrantReadWriteLock = this.lock;
            readLock = reentrantReadWriteLock.readLock();
            int n2 = 0;
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n4 = n3 - 1;
            if (n2 <= n4) {
                do {
                    n = ++n2;
                    readLock.unlock();
                } while (n2 != n4);
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                ModulePointerImpl modulePointerImpl4;
                ModulePointerImpl modulePointerImpl5 = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)this.pointers.get(module));
                if (modulePointerImpl5 != null) {
                    ModulePointerImpl modulePointerImpl6;
                    ModulePointerImpl it = modulePointerImpl6 = modulePointerImpl5;
                    ModulePointer modulePointer2 = it;
                    return modulePointer2;
                }
                Collection<ModulePointerImpl> pointers = this.unresolved.remove(module.getName());
                if (pointers == null || pointers.isEmpty()) {
                    ModulePointerImpl pointer = new ModulePointerImpl(module, this.lock);
                    this.registerPointer(module, pointer);
                    modulePointerImpl4 = pointer;
                } else {
                    Iterable $receiver$iv = pointers;
                    for (Object element$iv : $receiver$iv) {
                        ModulePointerImpl it = (ModulePointerImpl)element$iv;
                        it.moduleAdded$projectModel_impl(module);
                        ModulePointerImpl modulePointerImpl7 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)modulePointerImpl7, (String)"it");
                        this.registerPointer(module, modulePointerImpl7);
                    }
                    modulePointerImpl4 = (ModulePointerImpl)CollectionsKt.first((Iterable)pointers);
                }
                ModulePointerImpl modulePointerImpl8 = modulePointerImpl4;
                modulePointerImpl3 = modulePointerImpl8;
            }
            finally {
                n = 0;
                int n5 = n3 - 1;
                if (n <= n5) {
                    do {
                        int it = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)modulePointerImpl3, (String)"lock.write {\n      point\u2026ers.first()\n      }\n    }");
            modulePointer = modulePointerImpl3;
        }
        return modulePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ModulePointer create(@NotNull String moduleName) {
        String $i$a$1$read;
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Module module = ModuleManager.getInstance(this.project).findModuleByName(moduleName);
        if (module != null) {
            Module module2;
            Module it;
            Module module3 = it = (module2 = module);
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"it");
            return this.create(module3);
        }
        Object object = this.lock;
        ReentrantReadWriteLock.ReadLock $i$a$3$let = ((ReentrantReadWriteLock)object).readLock();
        $i$a$3$let.lock();
        try {
            $i$a$1$read = (String)this.oldToNewName.get((Object)moduleName);
        }
        finally {
            $i$a$3$let.unlock();
        }
        String newName = $i$a$1$read;
        if (newName != null) {
            Module module4 = ModuleManager.getInstance(this.project).findModuleByName(newName);
            if (module4 != null) {
                Object it;
                Object object2 = it = (object = module4);
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                return this.create((Module)object2);
            }
        }
        object = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        readLock.lock();
        try {
            Object object3;
            ModulePointer modulePointer;
            ModulePointerImpl modulePointerImpl = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)this.unresolved.get(moduleName));
            if (modulePointerImpl != null) {
                modulePointer = modulePointerImpl;
            } else {
                ModulePointerImpl modulePointerImpl2;
                int n;
                object3 = this.lock;
                ReentrantReadWriteLock.ReadLock readLock2 = ((ReentrantReadWriteLock)object3).readLock();
                int n2 = 0;
                int n3 = ((ReentrantReadWriteLock)object3).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object3).getReadHoldCount() : 0;
                int n4 = n3 - 1;
                if (n2 <= n4) {
                    do {
                        n = ++n2;
                        readLock2.unlock();
                    } while (n2 != n4);
                }
                ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object3).writeLock();
                writeLock.lock();
                try {
                    Object v7;
                    Object it2;
                    Object $receiver$iv;
                    block26: {
                        ModulePointerImpl modulePointerImpl3 = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)this.unresolved.get(moduleName));
                        if (modulePointerImpl3 != null) {
                            ModulePointerImpl modulePointerImpl4;
                            ModulePointerImpl it2 = modulePointerImpl4 = modulePointerImpl3;
                            ModulePointer modulePointer2 = it2;
                            ModulePointer modulePointer3 = modulePointer2;
                            return modulePointer3;
                        }
                        $receiver$iv = this.pointers.keySet();
                        it2 = $receiver$iv.iterator();
                        while (it2.hasNext()) {
                            Object element$iv = it2.next();
                            Module it3 = (Module)element$iv;
                            if (!Intrinsics.areEqual((Object)it3.getName(), (Object)moduleName)) continue;
                            v7 = element$iv;
                            break block26;
                        }
                        v7 = null;
                    }
                    Module module5 = v7;
                    if (module5 != null) {
                        it2 = $receiver$iv = module5;
                        ModulePointer modulePointer4 = this.create((Module)it2);
                        ModulePointer modulePointer5 = modulePointer4;
                        return modulePointer5;
                    }
                    ModulePointerImpl pointer = new ModulePointerImpl(moduleName, this.lock);
                    this.unresolved.putValue(moduleName, pointer);
                    modulePointerImpl2 = pointer;
                }
                finally {
                    n = 0;
                    int n5 = n3 - 1;
                    if (n <= n5) {
                        do {
                            int it2 = ++n;
                            readLock2.lock();
                        } while (n != n5);
                    }
                    writeLock.unlock();
                }
                modulePointer = modulePointerImpl2;
            }
            object3 = modulePointer;
            return object3;
        }
        finally {
            readLock.unlock();
        }
    }

    public ModulePointerManagerImpl(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.unresolved = MultiMap.createSmart();
        this.pointers = MultiMap.createSmart();
        this.lock = new ReentrantReadWriteLock();
        this.oldToNewName = new THashMap();
        this.project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, new ModuleListener(){

            @Override
            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                this.unregisterPointer(module);
            }

            @Override
            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                this.moduleAppears(module);
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
                Intrinsics.checkParameterIsNotNull(oldNameProvider, (String)"oldNameProvider");
                for (Module module : modules) {
                    this.moduleAppears(module);
                }
            }
        });
    }
}

