/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import com.intellij.psi.impl.compiled.ClsBinaryExpressionImpl;
import com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.impl.compiled.ClsParsingUtil");
    private static final JavaParserUtil.ParserWrapper ANNOTATION_VALUE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotationValue(builder);
        }
    };

    private ClsParsingUtil() {
    }

    public static PsiExpression createExpressionFromText(@NotNull String exprText, @NotNull PsiManager manager, @NotNull ClsElementImpl parent) {
        if (exprText == null) {
            ClsParsingUtil.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ClsParsingUtil.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            ClsParsingUtil.$$$reportNull$$$0(2);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
        try {
            PsiExpression expr = parserFacade.createExpressionFromText(exprText, null);
            return ClsParsingUtil.psiToClsExpression(expr, parent);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    public static PsiAnnotationMemberValue createMemberValueFromText(@NotNull String text2, @NotNull PsiManager manager, @NotNull ClsElementImpl parent) {
        LanguageLevel level;
        DummyHolder holder;
        PsiElement element;
        if (text2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            ClsParsingUtil.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            ClsParsingUtil.$$$reportNull$$$0(5);
        }
        if (!((element = SourceTreeToPsiMap.treeElementToPsi((holder = DummyHolderFactory.createHolder(manager, new JavaDummyElement(text2, ANNOTATION_VALUE, level = PsiUtil.getLanguageLevel(parent)), null)).getTreeElement().getFirstChildNode())) instanceof PsiAnnotationMemberValue)) {
            LOG.error("Could not parse initializer:'" + text2 + "'");
            return null;
        }
        return ClsParsingUtil.getMemberValue(element, parent);
    }

    public static PsiAnnotationMemberValue getMemberValue(@NotNull PsiElement element, @NotNull ClsElementImpl parent) {
        if (element == null) {
            ClsParsingUtil.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            ClsParsingUtil.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiExpression) {
            return ClsParsingUtil.psiToClsExpression((PsiExpression)element, parent);
        }
        if (element instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent, clsInitializers);
            for (int i = 0; i < initializers.length; ++i) {
                clsInitializers[i] = ClsParsingUtil.getMemberValue(initializers[i], arrayValue);
            }
            return arrayValue;
        }
        if (element instanceof PsiAnnotation) {
            final PsiAnnotation psiAnnotation = (PsiAnnotation)element;
            PsiJavaCodeReferenceElement referenceElement = psiAnnotation.getNameReferenceElement();
            assert (referenceElement != null) : psiAnnotation;
            final String canonicalText = referenceElement.getText();
            return new ClsAnnotationValueImpl(parent){

                @Override
                protected ClsJavaCodeReferenceElementImpl createReference() {
                    return new ClsJavaCodeReferenceElementImpl(this, canonicalText);
                }

                @Override
                protected ClsAnnotationParameterListImpl createParameterList() {
                    PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                    return new ClsAnnotationParameterListImpl(this, psiAttributes);
                }

                @Override
                public PsiAnnotationOwner getOwner() {
                    return (PsiAnnotationOwner)((Object)this.getParent());
                }
            };
        }
        LOG.error("Unexpected source element for annotation member value: " + element);
        return null;
    }

    static PsiExpression psiToClsExpression(@NotNull PsiExpression expr, @NotNull ClsElementImpl parent) {
        String exprText;
        if (expr == null) {
            ClsParsingUtil.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            ClsParsingUtil.$$$reportNull$$$0(9);
        }
        if (expr instanceof PsiLiteralExpression) {
            boolean forDecompiling = ((ClsFileImpl)parent.getContainingFile()).isForDecompiling();
            PsiType type = forDecompiling ? PsiType.NULL : expr.getType();
            Object value = forDecompiling ? null : ((PsiLiteralExpression)expr).getValue();
            return new ClsLiteralExpressionImpl(parent, expr.getText(), type, value);
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiJavaToken sign = ((PsiPrefixExpression)expr).getOperationSign();
            PsiExpression operand = ((PsiPrefixExpression)expr).getOperand();
            if (operand == null) {
                LOG.error("Invalid prefix expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsPrefixExpressionImpl(parent, sign, operand);
        }
        if (expr instanceof PsiClassObjectAccessExpression && StringUtil.endsWith(exprText = expr.getText(), ".class")) {
            String classText = exprText.substring(0, exprText.length() - 6);
            return new ClsClassObjectAccessExpressionImpl(parent, classText);
        }
        if (expr instanceof PsiReferenceExpression) {
            return new ClsReferenceExpressionImpl(parent, (PsiReferenceExpression)expr);
        }
        if (expr instanceof PsiBinaryExpression) {
            PsiJavaToken sign = ((PsiBinaryExpression)expr).getOperationSign();
            PsiExpression left = ((PsiBinaryExpression)expr).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)expr).getROperand();
            if (right == null) {
                LOG.error("Invalid binary expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsBinaryExpressionImpl(parent, sign, left, right);
        }
        if (((ClsFileImpl)parent.getContainingFile()).isForDecompiling()) {
            return new ClsLiteralExpressionImpl(parent, expr.getText(), PsiType.NULL, null);
        }
        PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance(expr.getProject()).getConstantEvaluationHelper();
        Object value = evaluator.computeConstantExpression(expr);
        if (value != null) {
            return new ClsLiteralExpressionImpl(parent, expr.getText(), expr.getType(), value);
        }
        LOG.error("Unable to compute expression value: " + expr + " [" + expr.getText() + "]");
        return null;
    }

    public static boolean isJavaIdentifier(@NotNull String identifier, @NotNull LanguageLevel level) {
        if (identifier == null) {
            ClsParsingUtil.$$$reportNull$$$0(10);
        }
        if (level == null) {
            ClsParsingUtil.$$$reportNull$$$0(11);
        }
        return StringUtil.isJavaIdentifier(identifier) && !JavaLexer.isKeyword(identifier, level);
    }

    @Nullable
    public static JavaSdkVersion getJdkVersionByBytecode(int major) {
        if (major == 196653 || major == 45) {
            return JavaSdkVersion.JDK_1_1;
        }
        if (major >= 46) {
            JavaVersion version = JavaVersion.compose(major - 44);
            return JavaSdkVersion.fromJavaVersion(version);
        }
        return null;
    }

    public static LanguageLevel getLanguageLevelByVersion(int major) {
        JavaSdkVersion sdkVersion = ClsParsingUtil.getJdkVersionByBytecode(major);
        return sdkVersion != null ? sdkVersion.getMaxLanguageLevel() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprText";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/compiled/ClsParsingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpressionFromText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createMemberValueFromText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMemberValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "psiToClsExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

